/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntityManager;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.TaskHelper;
import kd.bos.workflow.engine.task.Comment;
import kd.bos.workflow.engine.task.TaskInfo;
import kd.bos.workflow.engine.task.TaskUtils;
import kd.bos.workflow.exception.WFBizException;
import kd.bos.workflow.exception.WFBizOperationException;
import kd.bos.workflow.exception.WFObjectNotFoundException;

public abstract class BatchComplateMCTasks {
    private Log logger = LogFactory.getLog(BatchComplateMCTasks.class);
    public static final String DEALWITHCOMPOSITETASK = "dealWithCompositeTask";
    private static final String BATCHCOMPLATETASK = "BatchCompleteTask";
    private static final String LITERAL = "%s[%s]";
    private static final String LITERALPOINT = "%s.%s";

    protected boolean checkTasks(Long[] taskids, TaskEntity task) {
        String taskCacheKey;
        Boolean canNextStep = Boolean.TRUE;
        if (null == taskids && task == null) {
            canNextStep = Boolean.FALSE;
        }
        String string = taskCacheKey = task != null ? task.getId().toString() : WfUtils.listToString(Arrays.asList(taskids), ",");
        if (TaskUtils.handledRequest(BATCHCOMPLATETASK, taskCacheKey)) {
            canNextStep = Boolean.FALSE;
        }
        return canNextStep;
    }

    protected void removeTaskCacheSign(Long[] taskids, TaskEntity task) {
        String taskCacheKey;
        String string = taskCacheKey = task != null ? task.getId().toString() : WfUtils.listToString(Arrays.asList(taskids), ",");
        if (WfUtils.isNotEmpty(taskCacheKey)) {
            TaskUtils.removeHandledRequest(BATCHCOMPLATETASK, taskCacheKey);
        }
    }

    protected Map<String, Object> getVariables(CommandContext commandContext, Map<String, Object> variables, ILocaleString opinion, Long userId) {
        if (variables == null) {
            variables = new HashMap<String, Object>();
        }
        variables.put("auditTime", commandContext.getProcessEngineConfiguration().getClock().getCurrentTime().getTime());
        if (WfUtils.isNotEmpty(opinion)) {
            variables.put("auditMessage", opinion);
        }
        if (variables.get("auditType") == null) {
            variables.put("auditType", "approve");
        }
        if (variables.get("terminal") == null) {
            variables.put("terminal", RequestContext.get().getClient());
        }
        if (WfUtils.isNotEmpty(userId)) {
            variables.put("auditUserId", userId);
        }
        return variables;
    }

    protected Map<String, Object> setTaskComplate(CommandContext commandContext, List<TaskEntity> tasks, boolean verify, Map<String, Object> variables, StringBuilder failedBillnos, JSONArray successIds) {
        TaskHelper taskHelper = commandContext.getProcessEngineConfiguration().getTaskHelper();
        ArrayList<TaskEntity> taskEntityList = new ArrayList<TaskEntity>();
        StringBuilder handleTaskNotice = new StringBuilder();
        HashMap checkMap = new HashMap();
        HashSet needQueryTaskIds = new HashSet();
        HashMap<String, Object> taskResult = new HashMap<String, Object>();
        int failedCount = 0;
        int successCount = 0;
        if (WfUtils.isNotEmptyForCollection(tasks)) {
            for (TaskEntity task : tasks) {
                try {
                    String taskSource = task.getSource();
                    if (task.isBizTask() || BpmnModelUtil.instanceofAuditTask(task.getCategory())) {
                        boolean handle = true;
                        if (verify) {
                            handle = taskHelper.isValidate(task, variables);
                        }
                        if (handle) {
                            Long procInstId = task.getProcessInstanceId();
                            HashSet<Long> checkIds = (HashSet<Long>)checkMap.get(procInstId);
                            if (checkIds == null) {
                                checkIds = new HashSet<Long>();
                                checkMap.put(procInstId, checkIds);
                                checkIds.add(task.getId());
                            } else {
                                needQueryTaskIds.addAll(checkIds);
                                needQueryTaskIds.add(task.getId());
                            }
                            if (task.isDisplay()) {
                                task.setDisplay(false);
                                commandContext.getTaskEntityManager().update(task);
                            }
                            ++successCount;
                            successIds.add((Object)task.getId());
                            taskEntityList.add(task);
                            handleTaskNotice.append(task.getId()).append(",");
                        }
                    } else {
                        failedBillnos.append(String.format(ResManager.loadKDString((String)"\u5355\u636e\u5b9e\u4f53\uff1a%1$s\uff0c\u5355\u636e\u7f16\u7801\uff1a%2$s\uff0c\u4e3a\u975e\u5ba1\u6279\u7c7b\u4efb\u52a1\uff0c\u65e0\u6cd5\u6279\u91cf\u5904\u7406\u3002", (String)"BatchCompleteTask_7", (String)"bos-wf-engine", (Object[])new Object[0]), task.getEntityName().getLocaleValue(), task.getBillNo()));
                        ++failedCount;
                    }
                    task.setTransientVariable("updateQuantitySummaryDone", Boolean.TRUE);
                }
                catch (Exception e) {
                    this.logger.error((Throwable)e);
                    ++failedCount;
                    if (e instanceof WFBizOperationException || e instanceof KDBizException) {
                        failedBillnos.append(String.format(LITERAL, task.getBillNo(), e.getMessage())).append(";");
                        continue;
                    }
                    if (e instanceof WFBizException) {
                        failedBillnos.append(String.format(LITERAL, task.getBillNo(), e.getMessage())).append(";");
                        continue;
                    }
                    if (e instanceof WFObjectNotFoundException) {
                        failedBillnos.append(String.format(LITERAL, task.getBillNo(), ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u5904\u7406\uff0c\u65e0\u6cd5\u518d\u6b21\u63d0\u4ea4\u3002", (String)"BatchCompleteTask_2", (String)"bos-wf-engine", (Object[])new Object[0]))).append(";");
                        continue;
                    }
                    failedBillnos.append(String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\u3002\u5355\u636e\u7f16\u7801\u201c%1$s\u201d\uff0c\u5f02\u5e38\u539f\u56e0\uff1a%2$s\u3002", (String)"BatchCompleteTask_3", (String)"bos-wf-engine", (Object[])new Object[0]), task.getBillNo(), e.getMessage())).append(";");
                }
            }
        }
        taskResult.put("handleTaskNotice", handleTaskNotice);
        taskResult.put("taskEntityList", taskEntityList);
        taskResult.put("needQueryTaskIds", needQueryTaskIds);
        taskResult.put("failedCount", failedCount);
        taskResult.put("successCount", successCount);
        return taskResult;
    }

    protected Map<String, Object> filterConflictingTasks(CommandContext commandContext, Map<String, Object> variables, List<TaskEntity> tasks, Set<Long> needQueryTaskIds, StringBuilder failedBillno, JSONArray successIds) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        int failedCount = 0;
        int successCount = 0;
        Object needFilter = WfConfigurationUtil.getConfigCenterVal("workflow.filter.conflictingTasks");
        if ("true".equals(needFilter) && "reject".equals(variables.get("batchOpType"))) {
            int filterCount = this.filterConflictingTasks(commandContext, tasks, needQueryTaskIds, failedBillno, successIds);
            failedCount += filterCount;
            successCount -= filterCount;
        }
        res.put("failedCount", failedCount);
        res.put("successCount", successCount);
        return res;
    }

    protected String getResultOfTaskComplate(int taskBalance, int failedCount, int successCount, JSONArray successIds, StringBuilder failedBillnos, List<TaskEntity> tasks) {
        if (taskBalance > 0) {
            failedCount += taskBalance;
            failedBillnos = failedBillnos.append(ResManager.loadKDString((String)"\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u88ab\u5904\u7406\u3002", (String)"BatchCompleteTask_8", (String)"bos-wf-engine", (Object[])new Object[0])).append(";");
        }
        String resultFinal = "";
        String messageFinal = "";
        StringBuilder message = new StringBuilder();
        if (0 != failedBillnos.length()) {
            resultFinal = failedBillnos.substring(0, failedBillnos.toString().length() - 1);
        }
        if (0 != message.length()) {
            messageFinal = message.substring(0, message.toString().length() - 1);
        }
        if (WfUtils.isEmptyForCollection(tasks)) {
            failedCount = 1;
            messageFinal = ResManager.loadKDString((String)"\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u88ab\u5904\u7406\u3002", (String)"BatchCompleteTask_8", (String)"bos-wf-engine", (Object[])new Object[0]);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("success", (Object)(failedCount == 0 ? 1 : 0));
        jsonObject.put("failedCount", (Object)failedCount);
        jsonObject.put("successCount", (Object)successCount);
        jsonObject.put("result", (Object)resultFinal);
        jsonObject.put("message", (Object)messageFinal);
        jsonObject.put("successIds", (Object)successIds);
        return jsonObject.toJSONString();
    }

    protected List<TaskEntity> getTaskEntityList(CommandContext commandContext, boolean compensation, TaskEntity task, Long[] taskids) {
        List<TaskEntity> taskEntitys = null;
        TaskEntityManager taskEntityManager = commandContext.getTaskEntityManager();
        if (compensation) {
            taskEntitys = taskEntityManager.findByTaskIds(taskids, false);
        } else if (task != null) {
            taskEntitys = new ArrayList<TaskEntity>();
            taskEntitys.add(task);
        } else {
            taskEntitys = taskEntityManager.findByTaskIds(taskids, true);
        }
        return taskEntitys;
    }

    protected Map<String, Object> handleTaskWhenCompensation(CommandContext commandContext, List<TaskEntity> tasks, Map<String, Object> variables, Long userId) {
        TaskHelper taskHelper = commandContext.getProcessEngineConfiguration().getTaskHelper();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Map<String, Object> tempVaraibles = null;
        Long taskId = null;
        Long procinstanceId = null;
        for (TaskEntity task : tasks) {
            taskId = task.getId();
            procinstanceId = task.getProcessInstanceId();
            tempVaraibles = this.getAuditParameters(task, variables);
            tempVaraibles.put("taskCompensation", true);
            tempVaraibles.put("terminal", variables.get("terminal"));
            Comment comment = taskHelper.addComment(taskId, procinstanceId, userId, null, tempVaraibles);
            taskHelper.addHiAttachment(comment, tempVaraibles);
            taskHelper.completeCustomTask(task, this.getUserId(userId), tempVaraibles);
        }
        return resultMap;
    }

    private void fixLocaleString(Map<String, Object> variables, String key) {
        LocaleString value = null;
        Object message = variables.get(key);
        if (message instanceof Map) {
            value = LocaleString.fromMap((Map)((Map)message));
        } else if (message != null && message.toString().startsWith("{")) {
            try {
                value = LocaleString.fromMap((Map)((Map)SerializationUtils.fromJsonString((String)message.toString(), Map.class)));
            }
            catch (Exception e) {
                this.logger.info(String.format("error parse auditmessage when fixLocaleString[%s]", message));
            }
        } else {
            value = WfUtils.getMultiLangValue(message != null ? message.toString() : "");
        }
        if (value != null) {
            variables.put(key, value);
        }
    }

    protected Long getUserId(Long userId) {
        if (WfUtils.isEmpty(userId)) {
            userId = Long.valueOf(RequestContext.get().getUserId());
        }
        return userId;
    }

    private Map<String, Object> getAuditParameters(TaskInfo info, Map<String, Object> variables) {
        HashMap<String, Object> mapParams = new HashMap<String, Object>();
        mapParams.put("auditNumber", variables.get("auditNumber"));
        mapParams.put("auditName", variables.get("auditName"));
        mapParams.put("auditType", variables.get("auditType"));
        mapParams.put("auditMessage", variables.get("auditMessage"));
        mapParams.put("terminal", variables.get("terminal"));
        mapParams.put("updateQuantitySummaryDone", variables.get("updateQuantitySummaryDone"));
        return mapParams;
    }

    private Integer filterConflictingTasks(CommandContext commandContext, List<TaskEntity> ts, Set<Long> needQueryTaskIds, StringBuilder resultStr, JSONArray successIds) {
        int ret = 0;
        if (needQueryTaskIds == null || needQueryTaskIds.isEmpty() || ts == null || ts.isEmpty()) {
            return ret;
        }
        QFilter filter = new QFilter("taskId", "in", needQueryTaskIds);
        List actInsts = commandContext.getHistoricActivityInstanceEntityManager().findByQueryFilters(new QFilter[]{filter}, "processInstanceId,taskId,forkPath,activityName", "");
        HashMap<String, Set> rt = new HashMap<String, Set>();
        HashMap keyCols = new HashMap();
        HashMap<Long, String> taskNames = new HashMap<Long, String>(0);
        for (Object i : actInsts) {
            String forkPath = i.getForkPath();
            Long taskId = i.getTaskId();
            ILocaleString lActName = i.getActivityName();
            String actName = null == lActName ? "" : i.getActivityName().getLocaleValue();
            taskNames.put(taskId, actName);
            String procInstId = String.valueOf(i.getProcessInstanceId());
            if ("#M".equals(forkPath) || WfUtils.isEmpty(forkPath) || !forkPath.contains("$")) continue;
            String markKey = forkPath.substring(forkPath.lastIndexOf("$"));
            ArrayList<String> fps = (ArrayList<String>)keyCols.get(procInstId);
            if (fps == null) {
                fps = new ArrayList<String>();
                keyCols.put(procInstId, fps);
                fps.add(markKey);
                HashSet<Long> taskCols = new HashSet<Long>();
                rt.put(String.format(LITERALPOINT, procInstId, markKey), taskCols);
                taskCols.add(taskId);
                continue;
            }
            Iterator iter = fps.iterator();
            while (iter.hasNext()) {
                String s = (String)iter.next();
                String longForkPathMark = String.format(LITERALPOINT, procInstId, s);
                Set taskCols = (Set)rt.get(longForkPathMark);
                taskCols.add(taskId);
                if (!s.contains(markKey)) continue;
                String currLongForkPathMark = String.format(LITERALPOINT, procInstId, markKey);
                Set originalTaskCols = (Set)rt.get(currLongForkPathMark);
                if (originalTaskCols != null) {
                    taskCols.addAll(originalTaskCols);
                }
                iter.remove();
                rt.remove(longForkPathMark);
                rt.put(markKey, taskCols);
            }
        }
        if (!rt.values().isEmpty()) {
            HashSet canNotRejectTasks = new HashSet();
            for (Set taskIds : rt.values()) {
                if (taskIds.size() <= 1) continue;
                canNotRejectTasks.addAll(taskIds);
            }
            for (int i = ts.size(); i > 0; --i) {
                TaskEntity t = ts.get(i - 1);
                if (!canNotRejectTasks.contains(t.getId())) continue;
                ts.remove(t);
                t.setDisplay(true);
                commandContext.getTaskEntityManager().update(t);
                successIds.remove((Object)t.getId());
                ++ret;
            }
            StringBuilder idStr = new StringBuilder();
            for (Long i : canNotRejectTasks) {
                idStr.append(",").append((String)taskNames.get(i));
            }
            if (idStr.length() > 0) {
                resultStr.append(String.format("[%s][%s]", idStr.toString().substring(1), ResManager.loadKDString((String)"\u4efb\u52a1\u4e4b\u95f4\u5b58\u5728\u51b2\u7a81\uff0c\u4e0d\u80fd\u6279\u91cf\u9a73\u56de\u3002", (String)"BatchCompleteTask_10", (String)"bos-wf-engine", (Object[])new Object[0]))).append(";");
            }
        }
        return ret;
    }

    private boolean isNeedDealWithCompositeTask(Map<String, Object> variables) {
        Object dealWithCompositeTaskObj;
        boolean dealWithCompositeTask = true;
        if (WfUtils.isNotEmptyForMap(variables) && WfUtils.isNotEmptyString(dealWithCompositeTaskObj = variables.get(DEALWITHCOMPOSITETASK))) {
            dealWithCompositeTask = Boolean.parseBoolean(dealWithCompositeTaskObj.toString());
        }
        if (dealWithCompositeTask) {
            variables.put(DEALWITHCOMPOSITETASK, false);
        }
        return dealWithCompositeTask;
    }
}

