/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.TaskHelper;
import kd.bos.workflow.exception.WFBizException;
import kd.bos.workflow.exception.WFBizOperationException;
import kd.bos.workflow.exception.WFObjectNotFoundException;

public class BatchCompleteCompositeTask
implements Command<String> {
    private Log logger = LogFactory.getLog(this.getClass());
    private Map<Long, Map<String, Object>> batchTasks;
    private static final String LITERAL = "%s[%s]";

    public BatchCompleteCompositeTask(Map<Long, Map<String, Object>> tasks) {
        this.batchTasks = tasks == null ? Collections.EMPTY_MAP : tasks;
    }

    @Override
    public String execute(CommandContext commandContext) {
        if (this.batchTasks.isEmpty()) {
            return null;
        }
        JSONObject jsonObject = new JSONObject();
        int failedCount = 0;
        int successCount = 0;
        StringBuilder result = new StringBuilder();
        StringBuilder message = new StringBuilder();
        String resultFinal = "";
        String messageFinal = "";
        List<TaskEntity> tasks = null;
        TaskHelper taskHelper = commandContext.getProcessEngineConfiguration().getTaskHelper();
        Long[] taskids = this.batchTasks.keySet().toArray(new Long[0]);
        tasks = commandContext.getTaskEntityManager().findByTaskIds(taskids, true);
        boolean async = true;
        StringBuilder sb = new StringBuilder();
        for (TaskEntity task : tasks) {
            try {
                boolean isAuditTask = BpmnModelUtil.instanceofAuditTask(task.getCategory());
                if (isAuditTask) {
                    Map<String, Object> variable = this.batchTasks.get(task.getId());
                    boolean handle = taskHelper.isValidate(task, variable);
                    if (!handle) continue;
                    if (task.isDisplay()) {
                        task.setDisplay(false);
                        commandContext.getTaskEntityManager().update(task);
                    }
                    ++successCount;
                    sb.append(task.getId()).append(",");
                    taskHelper.quickCompleteTask(task, async);
                    variable.put("dealWithCompositeTask", false);
                    taskHelper.planCompensationTaskJob(task, variable);
                    continue;
                }
                result.append(String.format(ResManager.loadKDString((String)"%1$s\u201c%2$s\u201d\u7684\u5f53\u524d\u8282\u70b9\u4e3a\u4eba\u5de5\u8282\u70b9,\u65e0\u6cd5\u6279\u91cf\u5904\u7406\u3002", (String)"BatchCompleteCompositeTask_1", (String)"bos-wf-engine", (Object[])new Object[0]), task.getEntityName().getLocaleValue(), task.getBillNo()));
                ++failedCount;
            }
            catch (Exception e) {
                this.logger.error((Throwable)e);
                ++failedCount;
                if (e instanceof WFBizOperationException || e instanceof KDBizException) {
                    result.append(String.format(LITERAL, task.getBillNo(), e.getMessage())).append(";");
                    continue;
                }
                if (e instanceof WFBizException) {
                    result.append(String.format(LITERAL, task.getBillNo(), e.getMessage())).append(";");
                    continue;
                }
                if (e instanceof WFObjectNotFoundException) {
                    result.append(String.format(LITERAL, task.getBillNo(), ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u5904\u7406\uff0c\u65e0\u6cd5\u518d\u6b21\u63d0\u4ea4\u3002", (String)"BatchCompleteCompositeTask_2", (String)"bos-wf-engine", (Object[])new Object[0]))).append(";");
                    continue;
                }
                result.append(String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\u3002\u5355\u636e\u7f16\u7801\u201c%1$s\u201d\uff0c\u5f02\u5e38\u539f\u56e0\uff1a%2$s\u3002", (String)"BatchCompleteCompositeTask_3", (String)"bos-wf-engine", (Object[])new Object[0]), task.getBillNo(), e.getMessage())).append(";");
            }
        }
        if (sb.length() > 0) {
            WfUtils.addOpLog("wf_task", "submit", new MultiLangEnumBridge("\u63d0\u4ea4\u5ba1\u6279\u4efb\u52a1", "BatchCompleteCompositeTask_4", "bos-wf-engine"), null, sb.toString());
        }
        if (0 != result.length()) {
            resultFinal = result.substring(0, result.toString().length() - 1);
        }
        if (0 != message.length()) {
            messageFinal = message.substring(0, message.toString().length() - 1);
        }
        if (WfUtils.isEmptyForCollection(tasks)) {
            failedCount = 1;
            messageFinal = ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u88ab\u5904\u7406\u3002", (String)"BatchCompleteCompositeTask_5", (String)"bos-wf-engine", (Object[])new Object[0]);
        }
        jsonObject.put("success", (Object)(failedCount == 0 ? 1 : 0));
        jsonObject.put("failedCount", (Object)failedCount);
        jsonObject.put("successCount", (Object)successCount);
        jsonObject.put("result", (Object)resultFinal);
        jsonObject.put("message", (Object)messageFinal);
        return jsonObject.toJSONString();
    }

    private Long getUserId() {
        return Long.valueOf(RequestContext.get().getUserId());
    }
}

