/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.BaseElement;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.DecisionOption;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.job.EventTriggerCmd;
import kd.bos.workflow.engine.impl.cmd.task.RevoteCompositeTaskIdCmd;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.VariableInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntityManager;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.SignatureUtils;
import kd.bos.workflow.engine.impl.util.TaskHelper;
import kd.bos.workflow.engine.task.Comment;
import kd.bos.workflow.engine.task.TaskCompleteEventParams;
import kd.bos.workflow.engine.task.TaskEventTypeEnum;
import kd.bos.workflow.engine.task.TaskInfo;
import kd.bos.workflow.engine.task.TaskUtils;
import kd.bos.workflow.exception.WFBizException;
import kd.bos.workflow.exception.WFBizOperationException;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFException;
import kd.bos.workflow.exception.WFObjectNotFoundException;
import kd.bos.workflow.util.WfCommonUtil;

public class BatchCompleteTask
implements Command<String> {
    public static final String DEALWITHCOMPOSITETASK = "dealWithCompositeTask";
    private Log logger = LogFactory.getLog(this.getClass());
    private Long[] taskids;
    private ILocaleString opinion;
    private boolean compensation = false;
    private Map<String, Object> variables;
    private boolean verify = false;
    private Long userId;
    private TaskEntity task;
    private Boolean asyncTodo = null;
    private static final String LITERALPOINT = "%s.%s";
    private List<TaskCompleteEventParams> taskCompleteEventParams = new ArrayList<TaskCompleteEventParams>();
    private static final String JOINNODEREJECTKEY = "lfn";

    public BatchCompleteTask(String taskIds, ILocaleString opinion, boolean verify, Map<String, Object> variables) {
        if (WfUtils.isNotEmpty(taskIds)) {
            String[] arrs = taskIds.split(",");
            this.taskids = new Long[arrs.length];
            int i = 0;
            for (String val : arrs) {
                this.taskids[i] = Long.valueOf(val);
                ++i;
            }
        }
        if (variables != null && StringUtils.isNotBlank((Object)variables.get("userId"))) {
            this.userId = (Long)variables.get("userId");
        }
        this.opinion = opinion;
        this.verify = verify;
        this.variables = variables;
    }

    public BatchCompleteTask(Long[] taskids, Long userId, boolean compensation, Map<String, Object> variables) {
        this.taskids = taskids;
        this.compensation = compensation;
        this.variables = variables;
        this.userId = userId;
    }

    public BatchCompleteTask(Long taskId, Map<String, Object> variables) {
        this.taskids = new Long[]{taskId};
        this.variables = variables;
    }

    public BatchCompleteTask(TaskEntity task, Long userId, Map<String, Object> variables, Boolean asyncTodo, boolean verify) {
        this.task = task;
        this.variables = variables;
        this.userId = userId;
        this.asyncTodo = asyncTodo;
        this.verify = verify;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String execute(CommandContext commandContext) {
        String key;
        JSONObject jsonObject = new JSONObject();
        JSONArray successIds = new JSONArray();
        int failedCount = 0;
        int successCount = 0;
        int balance = 0;
        ArrayList<String> failList = new ArrayList<String>();
        StringBuilder result = new StringBuilder();
        StringBuilder message = new StringBuilder();
        String resultFinal = "";
        String messageFinal = "";
        List<TaskEntity> tasks = null;
        TaskHelper taskHelper = commandContext.getProcessEngineConfiguration().getTaskHelper();
        IdentityLinkEntityManager identityLinkEntityManager = commandContext.getIdentityLinkEntityManager();
        if (this.compensation) {
            tasks = commandContext.getTaskEntityManager().findByTaskIds(this.taskids, false);
            if (tasks == null || tasks.size() == 0) {
                return String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u201c%s\u201d\u5df2\u5904\u7406\u3002", (String)"BatchCompleteTask_6", (String)"bos-wf-engine", (Object[])new Object[0]), this.taskids[0]);
            }
            Map<String, Object> varaibles = null;
            Long taskId = null;
            Long procinstanceId = null;
            boolean dealWithCompositeTask = this.isNeedDealWithCompositeTask();
            String auditType = (String)this.variables.get("auditType");
            ArrayList<Long> allTaskIds = new ArrayList<Long>(tasks.size());
            List<TaskEntity> compositeTaskEntities = null;
            for (TaskEntity task : tasks) {
                taskId = task.getId();
                procinstanceId = task.getProcessInstanceId();
                if (dealWithCompositeTask) {
                    if (!"reject".equalsIgnoreCase(auditType) && !"forceReject".equalsIgnoreCase(auditType)) {
                        compositeTaskEntities = this.planBatchCompensationForCompositeTask(commandContext, taskId, procinstanceId, taskHelper);
                    }
                    if (this.isRevoteCompositeTask(task, auditType, identityLinkEntityManager)) {
                        allTaskIds.add(taskId);
                    }
                }
                varaibles = this.getAuditParameters(task);
                varaibles.put("taskCompensation", true);
                varaibles.put("terminal", this.variables.get("terminal"));
                if (this.variables.isEmpty() || this.variables.get("nocomment") == null) {
                    Comment comment = taskHelper.addComment(taskId, procinstanceId, this.userId, null, varaibles);
                    taskHelper.addHiAttachment(comment, varaibles);
                }
                if (this.variables.get("terminal") != null) {
                    taskHelper.updateTaskHandleLogForTasks(commandContext, task.getId(), this.variables.get("terminal"), this.getUserId());
                }
                this.parseEventParams(task, this.variables);
                task.setTransientVariable("syncTaskComplete", true);
                taskHelper.CompleteTask(task, this.getUserId(), varaibles, true);
                task.removeTransientVariable("syncTaskComplete");
            }
            if (commandContext.getProcessEngineConfiguration().isEnableBecEventDispatcher()) {
                HashMap<String, List<TaskCompleteEventParams>> eventMap = new HashMap<String, List<TaskCompleteEventParams>>();
                Object auditMsg = null;
                if (varaibles != null) {
                    auditMsg = varaibles.get("auditMessage");
                }
                eventMap.put("auditMessage", (List<TaskCompleteEventParams>)auditMsg);
                eventMap.put("taskCompleteEventParams", this.taskCompleteEventParams);
                new EventTriggerCmd(TaskEventTypeEnum.COMPLATE_TASK_EVENT.getCode(), SerializationUtils.toJsonString(eventMap)).execute(commandContext);
            }
            if (dealWithCompositeTask && WfUtils.isNotEmptyForCollection(allTaskIds)) {
                new RevoteCompositeTaskIdCmd(allTaskIds, compositeTaskEntities).execute(commandContext);
            }
            return null;
        }
        if (null == this.taskids && this.task == null) {
            return null;
        }
        String string = key = this.task != null ? this.task.getId().toString() : WfUtils.listToString(Arrays.asList(this.taskids), ",");
        if (TaskUtils.handledRequest("BatchCompleteTask", key)) {
            this.logger.debug("return cause of handledRequest cache");
            return null;
        }
        try {
            if (this.task != null) {
                tasks = new ArrayList<TaskEntity>();
                tasks.add(this.task);
            } else {
                tasks = commandContext.getTaskEntityManager().findByTaskIds(this.taskids, true);
                int resultSize = tasks == null ? 0 : tasks.size();
                balance = this.taskids.length - resultSize;
            }
            if (this.variables == null) {
                this.variables = new HashMap<String, Object>();
            }
            this.variables.put("auditTime", commandContext.getProcessEngineConfiguration().getClock().getCurrentTime().getTime());
            if (WfUtils.isNotEmpty(this.opinion)) {
                this.variables.put("auditMessage", this.opinion);
            }
            if (this.variables.get("auditType") == null) {
                this.variables.put("auditType", "approve");
            }
            if (this.variables.get("terminal") == null) {
                this.variables.put("terminal", RequestContext.get().getClient());
            }
            if ("reject".equalsIgnoreCase((String)this.variables.get("auditType")) || "forceReject".equalsIgnoreCase((String)this.variables.get("auditType"))) {
                if (this.variables.get("allowRejectAndGoBack") == null) {
                    this.variables.put("allowRejectAndGoBack", "false");
                }
                if (this.variables.get("rejectBackToNode") == null) {
                    this.variables.put("rejectBackToNode", "false");
                }
            }
            if (WfUtils.isNotEmpty(this.userId)) {
                this.variables.put("auditUserId", this.userId);
            }
            boolean async = true;
            if (this.asyncTodo != null) {
                async = this.asyncTodo;
            } else {
                boolean bl = async = tasks.size() > 1;
            }
            if (!this.variables.isEmpty()) {
                if (this.variables.get("batchOpType") != null) {
                    if ("approve".equalsIgnoreCase((String)this.variables.get("batchOpType"))) {
                        this.variables.put("handleWay", "batchagree");
                        this.variables.put("auditName", ResManager.loadKDString((String)"\u540c\u610f", (String)"BatchCompleteTask_11", (String)"bos-wf-engine", (Object[])new Object[0]));
                    } else {
                        this.variables.put("handleWay", "batchreject");
                        this.variables.put("auditType", "reject");
                        this.variables.put("auditName", ResManager.loadKDString((String)"\u9a73\u56de", (String)"BatchCompleteTask_12", (String)"bos-wf-engine", (Object[])new Object[0]));
                    }
                } else if ("api".equals(this.variables.get("terminal"))) {
                    String auditType = (String)this.variables.get("auditType");
                    if ("approve".equalsIgnoreCase(auditType)) {
                        this.variables.put("handleWay", "agreeapi");
                    } else if ("reject".equalsIgnoreCase(auditType)) {
                        this.variables.put("handleWay", "rejectapi");
                    } else if ("terminate".equalsIgnoreCase(auditType)) {
                        this.variables.put("handleWay", "terminateapi");
                    }
                }
            }
            ArrayList<TaskEntity> ts = new ArrayList<TaskEntity>();
            StringBuilder sb = new StringBuilder();
            HashMap checkMap = new HashMap();
            HashSet<Long> needQueryTaskIds = new HashSet<Long>();
            if (WfUtils.isNotEmptyForCollection(tasks)) {
                HashMap<String, Boolean> judgeForkTaskCanRejectKeys = new HashMap(tasks.size());
                if ("reject".equalsIgnoreCase((String)this.variables.get("auditType")) || "forceReject".equalsIgnoreCase((String)this.variables.get("auditType"))) {
                    judgeForkTaskCanRejectKeys = this.getAllForkTaskCanRejectKeys(tasks);
                }
                for (TaskEntity task : tasks) {
                    boolean isForceSign = this.checkIsForceSign(task, failList, result);
                    if (isForceSign) {
                        ++failedCount;
                        continue;
                    }
                    try {
                        boolean isAuditTask = BpmnModelUtil.instanceofAuditTask(task.getCategory());
                        if (isAuditTask) {
                            boolean handle = true;
                            if (this.verify) {
                                handle = taskHelper.isValidate(task, this.variables);
                            }
                            if (handle) {
                                if (("reject".equalsIgnoreCase((String)this.variables.get("auditType")) || "forceReject".equalsIgnoreCase((String)this.variables.get("auditType"))) && this.judgeForkTaskCanReject(task, judgeForkTaskCanRejectKeys).booleanValue()) {
                                    this.logger.debug(String.format("other nodes within the current branch have been rejected, so the current node can't be rejected. taskId:%s,userId:%s", task.getId(), this.userId));
                                    throw new WFException(WFErrorCode.completedTaskError(), ResManager.loadKDString((String)"\u5f53\u524d\u8282\u70b9\u4e3a\u5206\u652f\u5185\u90e8\u8282\u70b9\uff0c\u5df2\u7ecf\u6709\u5176\u4ed6\u5206\u652f\u8282\u70b9\u9a73\u56de\uff0c\u6682\u65f6\u4e0d\u80fd\u9a73\u56de", (String)"BatchCompleteTask_15", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                                }
                                Long procInstId = task.getProcessInstanceId();
                                HashSet<Long> checkIds = (HashSet<Long>)checkMap.get(procInstId);
                                if (checkIds == null) {
                                    checkIds = new HashSet<Long>();
                                    checkMap.put(procInstId, checkIds);
                                    checkIds.add(task.getId());
                                } else {
                                    needQueryTaskIds.addAll((Collection<Long>)checkIds);
                                    needQueryTaskIds.add(task.getId());
                                }
                                if (task.isDisplay()) {
                                    task.setDisplay(false);
                                    commandContext.getTaskEntityManager().update(task);
                                }
                                ++successCount;
                                ts.add(task);
                                sb.append(task.getId()).append(",");
                                successIds.add((Object)task.getId());
                            }
                        } else {
                            String format = String.format(ResManager.loadKDString((String)"\u5355\u636e\u5b9e\u4f53\uff1a%1$s\uff0c\u5355\u636e\u7f16\u7801\uff1a%2$s\uff0c\u4e3a\u975e\u5ba1\u6279\u7c7b\u4efb\u52a1\uff0c\u65e0\u6cd5\u6279\u91cf\u5904\u7406\u3002", (String)"BatchCompleteTask_7", (String)"bos-wf-engine", (Object[])new Object[0]), task.getEntityName().getLocaleValue(), task.getBillNo());
                            failList.add(format);
                            result.append(format);
                            ++failedCount;
                        }
                        task.setTransientVariable("updateQuantitySummaryDone", Boolean.TRUE);
                    }
                    catch (Exception e) {
                        String format;
                        this.logger.error((Throwable)e);
                        ++failedCount;
                        String LITERAL = ResManager.loadKDString((String)"%1$s\uff1a\u539f\u56e0\uff1a%2$s", (String)"BatchCompleteTask_13", (String)"bos-wf-engine", (Object[])new Object[0]);
                        if (e instanceof WFBizOperationException || e instanceof KDBizException) {
                            format = String.format(LITERAL, task.getBillNo(), e.getMessage());
                            failList.add(format);
                            result.append(format).append(";");
                            continue;
                        }
                        if (e instanceof WFBizException) {
                            format = String.format(LITERAL, task.getBillNo(), e.getMessage());
                            failList.add(format);
                            result.append(format).append(";");
                            continue;
                        }
                        if (e instanceof WFObjectNotFoundException) {
                            format = String.format(LITERAL, task.getBillNo(), ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u5904\u7406\uff0c\u65e0\u6cd5\u518d\u6b21\u63d0\u4ea4\u3002", (String)"BatchCompleteTask_2", (String)"bos-wf-engine", (Object[])new Object[0]));
                            failList.add(format);
                            result.append(format).append(";");
                            continue;
                        }
                        format = String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\u3002\u5355\u636e\u7f16\u7801\u201c%1$s\u201d\uff0c\u5f02\u5e38\u539f\u56e0\uff1a%2$s\u3002", (String)"BatchCompleteTask_3", (String)"bos-wf-engine", (Object[])new Object[0]), task.getBillNo(), e.getMessage());
                        failList.add(format);
                        result.append(format).append(";");
                    }
                }
            }
            try {
                Object needFilter = WfConfigurationUtil.getConfigCenterVal("workflow.filter.conflictingTasks");
                if ("true".equals(needFilter) && "reject".equals(this.variables.get("batchOpType"))) {
                    int filterCount = this.filterConflictingTasks(commandContext, ts, needQueryTaskIds, result, successIds);
                    failedCount += filterCount;
                    successCount -= filterCount;
                }
                taskHelper.quickBatchCompleteTask(ts, this.getUserId(), async);
                taskHelper.deleteUndealCoordinateTask(commandContext, ts);
                this.variables.put("updateQuantitySummaryDone", Boolean.TRUE);
                this.variables.put("savedLogMark", "true");
                taskHelper.addOperationLogForTasks(commandContext, ts, this.variables, this.userId);
                taskHelper.planBatchCompensationTaskJob(ts, this.variables);
                taskHelper.gatherAsyncCompensationData(ts);
            }
            catch (Exception e) {
                sb.append(String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff1a%s", (String)"BatchCompleteTask_9", (String)"bos-wf-engine", (Object[])new Object[0]), e.getMessage()));
                this.logger.error(String.format("\u6279\u91cf\u5904\u7406\u4efb\u52a1\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", WfUtils.getExceptionStacktrace(e)));
            }
            this.logger.debug("sb val is:" + sb);
            if (sb.length() > 0) {
                WfUtils.addOpLog("wf_task", "submit", new MultiLangEnumBridge("\u63d0\u4ea4\u5ba1\u6279\u4efb\u52a1", "BatchCompleteTask_4", "bos-wf-engine"), null, sb.toString());
            }
        }
        catch (Exception e) {
            this.logger.error(WfUtils.getExceptionStacktrace(e));
        }
        finally {
            TaskUtils.removeHandledRequest("BatchCompleteTask", key);
        }
        if (balance > 0) {
            failedCount += balance;
            result = result.append(ResManager.loadKDString((String)"\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u88ab\u5904\u7406\u3002", (String)"BatchCompleteTask_8", (String)"bos-wf-engine", (Object[])new Object[0])).append(";");
        }
        if (0 != result.length()) {
            resultFinal = result.substring(0, result.toString().length() - 1);
        }
        if (0 != message.length()) {
            messageFinal = message.substring(0, message.toString().length() - 1);
        }
        if (WfUtils.isEmptyForCollection(tasks)) {
            failedCount = 1;
            messageFinal = ResManager.loadKDString((String)"\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u88ab\u5904\u7406\u3002", (String)"BatchCompleteTask_8", (String)"bos-wf-engine", (Object[])new Object[0]);
        }
        jsonObject.put("success", (Object)(failedCount == 0 ? 1 : 0));
        jsonObject.put("failedCount", (Object)failedCount);
        jsonObject.put("successCount", (Object)successCount);
        jsonObject.put("result", (Object)resultFinal);
        jsonObject.put("message", (Object)messageFinal);
        jsonObject.put("successIds", (Object)successIds);
        jsonObject.put("failList", failList);
        jsonObject.put("opType", this.variables.get("batchOpType"));
        return jsonObject.toJSONString();
    }

    private boolean isNeedDealWithCompositeTask() {
        Object dealWithCompositeTaskObj;
        boolean dealWithCompositeTask = true;
        if (WfUtils.isNotEmptyForMap(this.variables) && WfUtils.isNotEmptyString(dealWithCompositeTaskObj = this.variables.get(DEALWITHCOMPOSITETASK))) {
            dealWithCompositeTask = Boolean.parseBoolean(dealWithCompositeTaskObj.toString());
        }
        if (dealWithCompositeTask) {
            this.variables.put(DEALWITHCOMPOSITETASK, false);
        }
        return dealWithCompositeTask;
    }

    private boolean isRevoteCompositeTask(TaskEntity task, String auditType, IdentityLinkEntityManager identityLinkEntityManager) {
        boolean dealWithCompositeTask = false;
        if ("reject".equalsIgnoreCase(auditType) || "forceReject".equalsIgnoreCase(auditType)) {
            return !dealWithCompositeTask;
        }
        QFilter filter0 = new QFilter("processInstanceId", "=", (Object)task.getProcessInstanceId());
        QFilter filter1 = new QFilter("userId", "!=", (Object)RequestContext.get().getCurrUserId());
        QFilter filter2 = new QFilter("compositetaskid", "is not null", null);
        QFilter filter3 = new QFilter("compositetaskid", "=", (Object)task.getId());
        QFilter[] filters = new QFilter[]{filter0, filter1, filter2, filter3};
        return identityLinkEntityManager.exist(filters);
    }

    private List<TaskEntity> planBatchCompensationForCompositeTask(CommandContext commandContext, Long taskId, Long procinstanceId, TaskHelper taskHelper) {
        TaskEntityManager taskEntityManager;
        List<TaskEntity> compositeTaskEntities;
        Long tmpUser = this.userId;
        if (this.userId == null || this.userId == 0L) {
            String currentUserId = RequestContext.get().getUserId();
            tmpUser = currentUserId == null ? 0L : Long.parseLong(currentUserId);
        }
        if (WfUtils.isNotEmptyForCollection(compositeTaskEntities = (taskEntityManager = commandContext.getTaskEntityManager()).findCompositeTasksByTaskId(taskId, procinstanceId, tmpUser))) {
            for (TaskEntity task : compositeTaskEntities) {
                if (task.isDisplay()) {
                    task.setDisplay(false);
                    commandContext.getTaskEntityManager().update(task);
                }
                taskHelper.planCompensationTaskJob(task, this.variables);
            }
        }
        return compositeTaskEntities;
    }

    public Map<String, Object> getAuditParameters(TaskInfo info) {
        Long processDefinitionId = info.getProcessDefinitionId();
        Long processInstanceId = info.getProcessInstanceId();
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(processDefinitionId, processInstanceId);
        AuditTask element = (AuditTask)bpmnModel.getFlowElement(info.getTaskDefinitionKey());
        if (this.variables != null && this.variables.get("batchOpType") != null) {
            String batchOpType = (String)this.variables.get("batchOpType");
            if ("approve".equals(batchOpType) && null != element.getBatchApprove() && element.getBatchApprove().isBatchApprove()) {
                this.variables.put("auditNumber", element.getBatchApprove().getBatchApproveDec());
            }
            if ("reject".equals(batchOpType) && null != element.getBatchReject() && element.getBatchReject().isBatchReject()) {
                this.variables.put("auditNumber", element.getBatchReject().getBatchRejectDec());
                this.variables.put("dynType", "dynReject");
                this.variables.put("nextNodeId", element.getBatchReject().getBatchRejectNode());
            }
            this.variables.put("auditType", batchOpType);
        }
        String activityId = element.getId();
        List<DecisionOption> decisionOptions = element.getDecisionOptions();
        if (this.variables != null && this.variables.get("auditNumber") != null) {
            Object decisionNumber = this.variables.get("auditNumber");
            BaseElement decision = null;
            for (DecisionOption decisionOption : decisionOptions) {
                if (decisionNumber == null || !decisionOption.getNumber().equalsIgnoreCase(decisionNumber.toString())) continue;
                decision = decisionOption;
                break;
            }
            if (decision != null) {
                Object decisionName = this.variables.get("auditName");
                String decisionNameMultiKey = BpmnModelUtil.getDecisionNameMultiKey(activityId, decision.getId());
                ILocaleString decisionNameMulti = BpmnModelUtil.getMultiLangFieldValue(processInstanceId, decisionNameMultiKey, ((DecisionOption)decision).getName());
                LocaleString decisionNameLocale = null;
                if (decisionName instanceof Map) {
                    decisionNameLocale = LocaleString.fromMap((Map)((Map)decisionName));
                    if (decisionNameLocale != null && decisionNameLocale.size() <= 1) {
                        for (Lang lang : WfUtils.getSupportLangs()) {
                            String lan = lang.toString();
                            if (!WfUtils.isEmpty((String)decisionNameLocale.get((Object)lan))) continue;
                            decisionNameLocale.setItem(lan, decisionNameMulti.get((Object)lan));
                        }
                    }
                } else if (decisionName instanceof String) {
                    String multiKey = BpmnModelUtil.getDecisionNameMultiKey(activityId, (String)this.variables.get("auditNumber"));
                    decisionNameLocale = BpmnModelUtil.getMultiLangFieldValue(processInstanceId, multiKey, decisionName.toString());
                } else {
                    decisionNameLocale = decisionNameMulti;
                }
                this.variables.put("auditName", decisionNameLocale);
                BatchCompleteTask.handleApiAndBatchSignature(info, this.variables, this.getUserId());
                if (((DecisionOption)decision).isRejectToParentProcessScene()) {
                    this.variables.put("dynType", "abortByRejectToParentProcess");
                }
            }
            return this.variables;
        }
        BaseElement ret = null;
        for (DecisionOption d : decisionOptions) {
            if (!"approve".equals(d.getAuditType())) continue;
            if (ret == null) {
                ret = d;
            }
            if (!d.isDefaultDecision()) continue;
            ret = d;
            break;
        }
        HashMap<String, Object> mapParams = new HashMap<String, Object>();
        if (ret != null) {
            mapParams.put("auditNumber", ret.getNumber());
            String multiKey = BpmnModelUtil.getDecisionNameMultiKey(activityId, ret.getId());
            ILocaleString decisionName = BpmnModelUtil.getMultiLangFieldValue(processInstanceId, multiKey, ((DecisionOption)ret).getName());
            mapParams.put("auditName", decisionName);
            mapParams.put("auditType", ((DecisionOption)ret).getAuditType());
            if (null != this.variables) {
                Object message = this.variables.get("auditMessage");
                Object value = null;
                value = message instanceof Map ? LocaleString.fromMap((Map)((Map)message)) : WfUtils.getMultiLangValue(message != null ? message.toString() : "");
                if (WfUtils.isEmpty((ILocaleString)value)) {
                    ILocaleString auditMessage = WfUtils.getPromptWordLocaleString("\u540c\u610f", "BatchCompleteTask_5", "bos-wf-engine");
                    mapParams.put("auditMessage", auditMessage);
                } else {
                    mapParams.put("auditMessage", value);
                }
                mapParams.put("terminal", this.variables.get("terminal"));
                if (this.variables.get("savedLogMark") != null) {
                    mapParams.put("savedLogMark", this.variables.get("savedLogMark"));
                }
                mapParams.put("signature", this.variables.get("signature"));
                BatchCompleteTask.handleApiAndBatchSignature(info, mapParams, this.getUserId());
            }
        }
        return mapParams;
    }

    private static void handleApiAndBatchSignature(TaskInfo taskInfo, Map<String, Object> variables, long userId) {
        Object signatureObj = variables.get("signature");
        if (WfUtils.isNotEmptyString(signatureObj)) {
            return;
        }
        Object terminal = variables.get("terminal");
        Object batchOpType = variables.get("batchOpType");
        if (!Objects.equals("api", terminal) && WfUtils.isNullObject(batchOpType)) {
            return;
        }
        String signature = SignatureUtils.getDefaultSignatureIfAllow(taskInfo, userId);
        if (WfUtils.isNotEmptyString(signature)) {
            variables.put("signature", signature);
        }
    }

    private Long getUserId() {
        if (WfUtils.isEmpty(this.userId)) {
            this.userId = Long.valueOf(RequestContext.get().getUserId());
        }
        return this.userId;
    }

    private Integer filterConflictingTasks(CommandContext commandContext, List<TaskEntity> ts, Set<Long> needQueryTaskIds, StringBuilder resultStr, JSONArray successIds) {
        int ret = 0;
        if (needQueryTaskIds == null || needQueryTaskIds.isEmpty() || ts == null || ts.isEmpty()) {
            return ret;
        }
        QFilter filter = new QFilter("taskId", "in", needQueryTaskIds);
        List actInsts = commandContext.getHistoricActivityInstanceEntityManager().findByQueryFilters(new QFilter[]{filter}, "processInstanceId,taskId,forkPath,activityName", "");
        HashMap<String, Set> rt = new HashMap<String, Set>();
        HashMap keyCols = new HashMap();
        HashMap<Long, String> taskNames = new HashMap<Long, String>(0);
        for (Object i : actInsts) {
            String forkPath = i.getForkPath();
            Long taskId = i.getTaskId();
            ILocaleString lActName = i.getActivityName();
            String actName = null == lActName ? "" : i.getActivityName().getLocaleValue();
            taskNames.put(taskId, actName);
            String procInstId = String.valueOf(i.getProcessInstanceId());
            if ("#M".equals(forkPath) || WfUtils.isEmpty(forkPath) || !forkPath.contains("$")) continue;
            String markKey = forkPath.substring(forkPath.lastIndexOf("$"));
            ArrayList<String> fps = (ArrayList<String>)keyCols.get(procInstId);
            if (fps == null) {
                fps = new ArrayList<String>();
                keyCols.put(procInstId, fps);
                fps.add(markKey);
                HashSet<Long> taskCols = new HashSet<Long>();
                rt.put(String.format(LITERALPOINT, procInstId, markKey), taskCols);
                taskCols.add(taskId);
                continue;
            }
            Iterator iter = fps.iterator();
            while (iter.hasNext()) {
                String s = (String)iter.next();
                String longForkPathMark = String.format(LITERALPOINT, procInstId, s);
                Set taskCols = (Set)rt.get(longForkPathMark);
                taskCols.add(taskId);
                if (!s.contains(markKey)) continue;
                String currLongForkPathMark = String.format(LITERALPOINT, procInstId, markKey);
                Set originalTaskCols = (Set)rt.get(currLongForkPathMark);
                if (originalTaskCols != null) {
                    taskCols.addAll(originalTaskCols);
                }
                iter.remove();
                rt.remove(longForkPathMark);
                rt.put(markKey, taskCols);
            }
        }
        if (!rt.values().isEmpty()) {
            HashSet canNotRejectTasks = new HashSet();
            for (Set taskIds : rt.values()) {
                if (taskIds.size() <= 1) continue;
                canNotRejectTasks.addAll(taskIds);
            }
            for (int i = ts.size(); i > 0; --i) {
                TaskEntity t = ts.get(i - 1);
                if (!canNotRejectTasks.contains(t.getId())) continue;
                ts.remove(t);
                t.setDisplay(true);
                commandContext.getTaskEntityManager().update(t);
                successIds.remove((Object)t.getId());
                ++ret;
            }
            StringBuilder idStr = new StringBuilder();
            for (Long i : canNotRejectTasks) {
                idStr.append(",").append((String)taskNames.get(i));
            }
            if (idStr.length() > 0) {
                resultStr.append(String.format("[%s][%s]", idStr.toString().substring(1), ResManager.loadKDString((String)"\u4efb\u52a1\u4e4b\u95f4\u5b58\u5728\u51b2\u7a81\uff0c\u4e0d\u80fd\u6279\u91cf\u9a73\u56de\u3002", (String)"BatchCompleteTask_10", (String)"bos-wf-engine", (Object[])new Object[0]))).append(";");
            }
        }
        return ret;
    }

    private void parseEventParams(TaskEntity task, Map<String, Object> variables) {
        TaskCompleteEventParams taskCompleteEventParam = new TaskCompleteEventParams();
        taskCompleteEventParam.setTaskId(task.getId());
        taskCompleteEventParam.setBusinessKey(task.getBusinessKey());
        taskCompleteEventParam.setEntityNumber(task.getEntityNumber());
        taskCompleteEventParam.setAuditNumber((String)variables.get("auditNumber"));
        taskCompleteEventParam.setBillNum(task.getBillNo());
        this.taskCompleteEventParams.add(taskCompleteEventParam);
    }

    private Boolean judgeForkTaskCanReject(TaskEntity task, Map<String, Boolean> judgeForkTaskCanRejectKeys) {
        if (WfUtils.isEmpty(task.getProcessInstanceId()) || WfUtils.isEmpty(task.getTaskDefinitionKey()) || WfUtils.isEmptyString(task.getControl())) {
            return Boolean.FALSE;
        }
        Map control = (Map)SerializationUtils.fromJsonString((String)task.getControl(), Map.class);
        if (WfUtils.isNotEmptyForMap(control) && StringUtils.isNotBlank(control.get(JOINNODEREJECTKEY))) {
            String judgeForkTaskCanRejectKey = task.getProcessInstanceId() + (String)control.get(JOINNODEREJECTKEY);
            if (Boolean.TRUE.equals(judgeForkTaskCanRejectKeys.get(judgeForkTaskCanRejectKey))) {
                return Boolean.TRUE;
            }
            judgeForkTaskCanRejectKeys.put(judgeForkTaskCanRejectKey, Boolean.TRUE);
        }
        return Boolean.FALSE;
    }

    private Map<String, Boolean> getAllForkTaskCanRejectKeys(List<TaskEntity> tasks) {
        HashMap<String, Boolean> judgeForkTaskCanRejectMap = new HashMap<String, Boolean>(tasks.size());
        ArrayList<String> variableNames = new ArrayList<String>(tasks.size());
        ArrayList<Long> procInstIds = new ArrayList<Long>(tasks.size());
        tasks.forEach(task -> {
            if (WfUtils.isEmpty(task.getProcessInstanceId()) || WfUtils.isEmpty(task.getTaskDefinitionKey()) || WfUtils.isEmpty(task.getControl())) {
                return;
            }
            Map control = (Map)SerializationUtils.fromJsonString((String)task.getControl(), Map.class);
            if (WfUtils.isNotEmptyForMap(control) && WfUtils.isNotEmptyString(control.get(JOINNODEREJECTKEY))) {
                variableNames.add((String)control.get(JOINNODEREJECTKEY));
                procInstIds.add(task.getProcessInstanceId());
            }
        });
        if (variableNames.isEmpty()) {
            return judgeForkTaskCanRejectMap;
        }
        List<VariableInstanceEntity> variables = Context.getCommandContext().getVariableInstanceEntityManager().findVariableInstancesByProcessInstanceIdsAndnames(procInstIds, variableNames);
        for (VariableInstanceEntity variable : variables) {
            String key = variable.getProcessInstanceId() + variable.getName();
            judgeForkTaskCanRejectMap.put(key, Boolean.TRUE);
        }
        return judgeForkTaskCanRejectMap;
    }

    private boolean checkIsForceSign(TaskEntity task, ArrayList<String> failList, StringBuilder result) {
        Object terminal = this.variables.get("terminal");
        Object batchOpType = this.variables.get("batchOpType");
        if (Objects.equals("api", terminal) || WfUtils.isNullObject(batchOpType)) {
            return Boolean.FALSE;
        }
        String control = task.getControl();
        Map valueFromMapJson = WfCommonUtil.getValueFromMapJson((String)control);
        boolean forceSignature = WfCommonUtil.getBooleanValueFromJson((Map)valueFromMapJson, (String)"fS");
        if (!forceSignature) {
            return Boolean.FALSE;
        }
        String info = ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a{0}\u7684{1}\uff0c\u9700\u5b8c\u6210\u624b\u5199\u7b7e\u540d\uff0c\u8bf7\u5728\u5ba1\u6279\u5904\u7406\u9875\u9762\u5ba1\u6279\u3002", (String)"BatchCompleteTask_14", (String)"bos-wf-engine", (Object[])new Object[]{task.getBillNo(), task.getEntityName().getLocaleValue()});
        failList.add(info);
        result.append(info).append(",");
        return Boolean.TRUE;
    }
}

