/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.utils.CustomTaskUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntityManager;

public class BatchDeleteTasksCmd
implements Command<Map<String, Object>> {
    private Log logger = LogFactory.getLog(this.getClass());
    private List<Long> taskIds;

    public BatchDeleteTasksCmd(List<Long> taskIds) {
        this.taskIds = taskIds;
    }

    @Override
    public Map<String, Object> execute(CommandContext commandContext) {
        Map res = new HashMap();
        try {
            Map<Long, Set<Long>> taskUserIds = this.deleteTasks(commandContext);
            this.deleteChannelTodo(commandContext, taskUserIds);
            res = CustomTaskUtils.getResult((Boolean)Boolean.TRUE, (String)"deleteTasks success", (String)taskUserIds.toString());
        }
        catch (Exception e) {
            String description = String.format("deleteTasks exeception is %s", WfUtils.getExceptionStacktrace(e));
            this.logger.info(description);
            res = CustomTaskUtils.getResult((Boolean)Boolean.FALSE, (String)description);
        }
        return res;
    }

    private Map<Long, Set<Long>> deleteTasks(CommandContext commandContext) {
        TaskEntityManager taskEntityManager = commandContext.getTaskEntityManager();
        IdentityLinkEntityManager identityLinkEntityManager = commandContext.getIdentityLinkEntityManager();
        HistoricTaskInstanceEntityManager historicTaskInstanceEntityManager = commandContext.getHistoricTaskInstanceEntityManager();
        HistoricIdentityLinkEntityManager historicIdentityLinkEntityManager = commandContext.getHistoricIdentityLinkEntityManager();
        HashMap<Long, Set<Long>> taskUserIds = new HashMap<Long, Set<Long>>(this.taskIds.size());
        for (Long taskId : this.taskIds) {
            TaskEntity taskEntity = (TaskEntity)taskEntityManager.findById(taskId);
            if (taskEntity == null) continue;
            if (taskEntity.hasVariable("priority")) {
                taskEntity.removeVariable("priority");
            }
            taskEntityManager.delete(taskEntity);
            Set participants = taskEntity.getParticipants();
            identityLinkEntityManager.deleteIdentityLinksByTask(taskEntity);
            taskUserIds.put(taskId, participants);
            historicTaskInstanceEntityManager.delete(taskId);
            historicIdentityLinkEntityManager.deleteHistoricIdentityLinksByTaskId(taskId);
        }
        return taskUserIds;
    }

    private void deleteChannelTodo(CommandContext commandContext, Map<Long, Set<Long>> taskUserIds) {
        if (!taskUserIds.isEmpty()) {
            Set<Map.Entry<Long, Set<Long>>> entrySet = taskUserIds.entrySet();
            for (Map.Entry<Long, Set<Long>> entry : entrySet) {
                Long taskId = entry.getKey();
                ArrayList<Long> userIds = new ArrayList<Long>();
                userIds.addAll((Collection)entry.getValue());
                commandContext.getMessageService().deleteToDo(taskId, userIds);
            }
        }
    }
}

