/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.IWithdrawValidate;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.validate.ContinueStateWithdrawValidator;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.validate.ExecutionWithdrawValidator;
import kd.bos.workflow.engine.impl.cmd.task.withdraw.validate.WithdrawValidateRet;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.HiUserActInstEntity;

public class CanWithdrawTaskByProcessInstanceIdCmd
implements Command<Map<String, List<String>>>,
Serializable {
    private static Log logger = LogFactory.getLog(CanWithdrawTaskByProcessInstanceIdCmd.class);
    private static final long serialVersionUID = 1L;
    private Long processInstanceId;

    public CanWithdrawTaskByProcessInstanceIdCmd(Long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @Override
    public Map<String, List<String>> execute(CommandContext commandContext) {
        logger.debug("CanWithdrawTaskByProcessInstanceIdCmd is enter");
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        ExecutionEntity procInst = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(this.processInstanceId);
        ArrayList<IWithdrawValidate> validates = new ArrayList<IWithdrawValidate>();
        validates.add(new ContinueStateWithdrawValidator(procInst));
        if (procInst != null) {
            List<HiUserActInstEntity> userActInsts = commandContext.getHiUserActInstEntityManager().findCurrentUserActInsts(this.processInstanceId);
            validates.add(new ExecutionWithdrawValidator(procInst, userActInsts));
        }
        ArrayList<String> resultList = new ArrayList<String>();
        for (IWithdrawValidate validate : validates) {
            WithdrawValidateRet ret = validate.validate(commandContext);
            if (ret.isSuccess()) continue;
            resultList.add(ret.getErrorInfo());
        }
        logger.debug("CanWithdrawTaskByProcessInstanceIdCmd resultList : " + resultList.size());
        map.put("errorInfo", resultList);
        return map;
    }
}

