/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntityManager;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;

public class CanWithdrawTaskCmd
implements Command<Map<String, List<String>>>,
Serializable {
    private static Log logger = LogFactory.getLog(CanWithdrawTaskCmd.class);
    private static final long serialVersionUID = 3892395658852847628L;
    private DynamicObject[] objs;
    private static final String WFWITHDRAW = "wf.withdraw";

    public CanWithdrawTaskCmd(DynamicObject[] objs) {
        this.objs = objs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, List<String>> execute(CommandContext commandContext) {
        String entityNumber;
        HashMap<String, List<String>> ret = new HashMap<String, List<String>>(4);
        if (this.objs == null || this.objs.length == 0) {
            return ret;
        }
        ArrayList<String> allUnsubmitPks = new ArrayList<String>(this.objs.length);
        ArrayList<String> pksQuerySet = new ArrayList<String>(this.objs.length);
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        char c = '\'';
        int j = 0;
        for (int i = 0; i < this.objs.length; ++i) {
            String pkValue = this.objs[i].getPkValue().toString();
            allUnsubmitPks.add(pkValue);
            if (++j % 100 == 0) {
                sb.append(c).append(pkValue).append(c).append(')');
                pksQuerySet.add(sb.toString());
                sb = new StringBuilder();
                sb.append('(');
                continue;
            }
            sb.append(c).append(pkValue).append(c).append(',');
        }
        if (sb.length() > 1) {
            pksQuerySet.add(sb.substring(0, sb.length() - 1) + ")");
        }
        if (!ProcessDefinitionUtil.existProcessDefinitionByEntityNumber(entityNumber = this.objs[0].getDataEntityType().getName())) {
            ret.put("notInProcess", allUnsubmitPks);
            logger.debug(String.format("no process definition exists, entityNumber[%s].", entityNumber));
            return ret;
        }
        logger.debug("exist process definition, start query db.");
        HashSet<String> wfCanWithdrawPksByAbandonProcess = new HashSet<String>(16);
        HashMap<String, String> canNotWithdrawCauses = new HashMap<String, String>(16);
        HashSet<String> wfCanWithdrawPks = new HashSet<String>(16);
        HashSet<String> onlyHaveBizFlowPks = new HashSet<String>(16);
        LinkedHashSet<String> noProcessPks = new LinkedHashSet<String>(allUnsubmitPks);
        HashMap<Long, Map<String, Object>> superExeInfos = new HashMap<Long, Map<String, Object>>(16);
        if (!pksQuerySet.isEmpty()) {
            HashMap<String, Boolean> procsStatus = new HashMap<String, Boolean>();
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT ").append("b.ftext text1,").append("a.FBUSINESSKEY businessKey, a.FPROCDEFID procDefId, a.FPROCINSTID procInstId, a.fprocesstype processType, a.FSUPEREXEC superExecId, a.fsuspensionstate suspensionState ").append("FROM  ").append("t_wf_execution a ").append("LEFT JOIN t_wf_hivarinst b ON b.FPROCINSTID = a.FPROCINSTID ").append("WHERE ").append("b.FNAME = 'lastUserDealNode' ").append("AND a.FISSCOPE = '1' ").append("AND a.FBUSINESSKEY IN ");
            try (DataSet unionDs = null;){
                for (String businessKeyStr : pksQuerySet) {
                    StringBuilder tm = new StringBuilder();
                    tm.append(sql).append(businessKeyStr);
                    DataSet ds = DB.queryDataSet((String)WFWITHDRAW, (DBRoute)DBRoute.workflow, (String)tm.toString());
                    if (unionDs == null) {
                        unionDs = ds;
                        continue;
                    }
                    unionDs = unionDs.union(ds);
                }
                if (null != unionDs) {
                    for (Row r : unionDs) {
                        String businessKey = r.getString("businessKey");
                        noProcessPks.remove(businessKey);
                        String processType = r.getString("processType");
                        if (processType.equals("BizFlow")) {
                            onlyHaveBizFlowPks.add(businessKey);
                            continue;
                        }
                        onlyHaveBizFlowPks.remove(businessKey);
                        String suspensionState = r.getString("suspensionState");
                        if ("2".equals(suspensionState)) {
                            canNotWithdrawCauses.put(businessKey, String.format("%s_%s", businessKey, ResManager.loadKDString((String)"\u64a4\u56de\u5931\u8d25\u3002\u5f53\u524d\u6d41\u7a0b\u5df2\u6302\u8d77\uff0c\u4e0d\u80fd\u64a4\u56de\u3002", (String)"CanWithdrawTaskCmd_1", (String)"bos-wf-engine", (Object[])new Object[0])));
                            continue;
                        }
                        String hiVarInst = r.getString("text1");
                        Long superExeId = r.getLong("superExecId");
                        if (WfUtils.isNotEmpty(superExeId)) {
                            HashMap<String, Object> info = new HashMap<String, Object>(4);
                            superExeInfos.put(superExeId, info);
                            info.put("var", hiVarInst);
                            Long procDefId = r.getLong("procDefId");
                            Long procInstId = r.getLong("procInstId");
                            info.put("procDefId", procDefId);
                            info.put("procInstId", procInstId);
                            continue;
                        }
                        wfCanWithdrawPks.add(businessKey);
                        if (!hiVarInst.equals("start") && !hiVarInst.equals("startProcessInstance")) {
                            canNotWithdrawCauses.put(businessKey, String.format("%s_%s", businessKey, ResManager.loadKDString((String)"\u64a4\u56de\u5931\u8d25\uff1a\u5f53\u524d\u6d41\u7a0b\u5df2\u5ba1\u6279\uff0c\u4e0d\u80fd\u64a4\u56de\u3002", (String)"CanWithdrawTaskCmd_2", (String)"bos-wf-engine", (Object[])new Object[0])));
                            wfCanWithdrawPks.remove(businessKey);
                            Long procDefId = r.getLong("procDefId");
                            Long procInstId = r.getLong("procInstId");
                            this.addAbandonWitdrawBusinesskey(wfCanWithdrawPksByAbandonProcess, procsStatus, procDefId, procInstId, businessKey, canNotWithdrawCauses);
                            continue;
                        }
                        if (this.validateCanWithdraw(businessKey, commandContext, canNotWithdrawCauses)) continue;
                        wfCanWithdrawPks.remove(businessKey);
                    }
                    logger.debug("wfCanWithdrawPks filter start end:" + WfUtils.listToString(wfCanWithdrawPks, ","));
                }
            }
            this.dealSubProc(commandContext, wfCanWithdrawPksByAbandonProcess, canNotWithdrawCauses, wfCanWithdrawPks, superExeInfos, procsStatus);
            if (!noProcessPks.isEmpty()) {
                HashSet<String> currentStartProcessPks = new HashSet<String>(noProcessPks.size());
                for (String pk : noProcessPks) {
                    if (!WfCacheHelper.existCurrentStartProcessBusinessKey(entityNumber, pk)) continue;
                    currentStartProcessPks.add(pk);
                    canNotWithdrawCauses.put(pk, String.format("%s_%s", pk, ResManager.loadKDString((String)"\u64a4\u56de\u5931\u8d25\uff1a\u5f53\u524d\u6d41\u7a0b\u6b63\u5728\u542f\u52a8\u4e2d\uff0c\u6682\u65f6\u4e0d\u80fd\u64a4\u56de\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"CanWithdrawTaskCmd_4", (String)"bos-wf-engine", (Object[])new Object[0])));
                }
                noProcessPks.removeAll(currentStartProcessPks);
                this.filterExeutedTimerjobPks(noProcessPks, wfCanWithdrawPks, canNotWithdrawCauses);
                this.filterDeadletterStartjob(wfCanWithdrawPks, noProcessPks, canNotWithdrawCauses);
            }
        }
        logger.debug(String.format("notInProcess : %s", WfUtils.listToString(noProcessPks, ",")));
        logger.debug(String.format("notInProcess-onlyBizflowPks : %s", WfUtils.listToString(onlyHaveBizFlowPks, ",")));
        logger.debug(String.format("wfCanWithdrawPks : %s", WfUtils.listToString(wfCanWithdrawPks, ",")));
        logger.debug(String.format("wfCanWithdrawPksByAbandonProcess : %s", WfUtils.listToString(wfCanWithdrawPksByAbandonProcess, ",")));
        logger.debug(String.format("canNotWithdrawCauses : %s", WfUtils.listToString(canNotWithdrawCauses.values(), ",")));
        ArrayList<String> notInProcessPks = new ArrayList<String>(16);
        notInProcessPks.addAll(noProcessPks);
        notInProcessPks.addAll(onlyHaveBizFlowPks);
        ret.put("notInProcess", new ArrayList(notInProcessPks));
        ret.put("wfCanWithdraw", new ArrayList<String>(wfCanWithdrawPks));
        ret.put("wfCanWithdrawByAbandonProc", new ArrayList<String>(wfCanWithdrawPksByAbandonProcess));
        ret.put("notWithdrawCause", new ArrayList(canNotWithdrawCauses.values()));
        if (!noProcessPks.isEmpty()) {
            List<String> bizJobIds = this.findInBizJobsAndCache(noProcessPks);
            ret.put("withdrawDeleteBizJobIds", bizJobIds);
        }
        return ret;
    }

    private void dealSubProc(CommandContext commandContext, Set<String> wfCanWithdrawPksByAbandonProcess, Map<String, String> canNotWithdrawCauses, Set<String> wfCanWithdrawPks, Map<Long, Map<String, Object>> superExeInfos, Map<String, Boolean> procsStatus) {
        if (!superExeInfos.isEmpty()) {
            List<String> inProcessCanWdPksSet = WfUtils.formatInQueryParam(new ArrayList<Object>(superExeInfos.keySet()), 500, false);
            String superExeSql = "select fid, fprocdefid, fprocinstid, fprocesstype, fbusinesskey from t_wf_execution where fid in ";
            try (DataSet ds = WfUtils.batchQueryByIn(superExeSql, inProcessCanWdPksSet, "wf.superExe.wdExe", false);){
                if (ds != null) {
                    for (Row r : ds) {
                        Long procInstId;
                        Long procDefId;
                        Long superExeId = r.getLong("fid");
                        String businessKey = r.getString("fbusinesskey");
                        String processType = r.getString("fprocesstype");
                        Map<String, Object> info = superExeInfos.get(superExeId);
                        Object var = info.get("var");
                        if (processType.equals("BizFlow")) {
                            wfCanWithdrawPks.add(businessKey);
                            if (!var.equals("start") && !var.equals("startProcessInstance")) {
                                canNotWithdrawCauses.put(businessKey, String.format("%s_%s", businessKey, ResManager.loadKDString((String)"\u64a4\u56de\u5931\u8d25\uff1a\u5f53\u524d\u6d41\u7a0b\u5df2\u5ba1\u6279\uff0c\u4e0d\u80fd\u64a4\u56de\u3002", (String)"CanWithdrawTaskCmd_2", (String)"bos-wf-engine", (Object[])new Object[0])));
                                wfCanWithdrawPks.remove(businessKey);
                                procDefId = (Long)info.get("procDefId");
                                procInstId = (Long)info.get("procInstId");
                                this.addAbandonWitdrawBusinesskey(wfCanWithdrawPksByAbandonProcess, procsStatus, procDefId, procInstId, businessKey, canNotWithdrawCauses);
                                continue;
                            }
                            if (this.validateCanWithdraw(businessKey, commandContext, canNotWithdrawCauses)) continue;
                            wfCanWithdrawPks.remove(businessKey);
                            continue;
                        }
                        if (!wfCanWithdrawPks.contains(businessKey)) continue;
                        if (!var.equals("start") && !var.equals("startProcessInstance")) {
                            canNotWithdrawCauses.put(businessKey, String.format("%s_%s", businessKey, ResManager.loadKDString((String)"\u64a4\u56de\u5931\u8d25\uff1a\u5f53\u524d\u6d41\u7a0b\u5df2\u5ba1\u6279\uff0c\u4e0d\u80fd\u64a4\u56de\u3002", (String)"CanWithdrawTaskCmd_2", (String)"bos-wf-engine", (Object[])new Object[0])));
                            wfCanWithdrawPks.remove(businessKey);
                            procDefId = r.getLong("fprocdefid");
                            procInstId = r.getLong("fprocinstid");
                            this.addAbandonWitdrawBusinesskey(wfCanWithdrawPksByAbandonProcess, procsStatus, procDefId, procInstId, businessKey, canNotWithdrawCauses);
                            continue;
                        }
                        if (this.validateCanWithdraw(businessKey, commandContext, canNotWithdrawCauses)) continue;
                        wfCanWithdrawPks.remove(businessKey);
                    }
                }
            }
        }
    }

    private void filterDeadletterStartjob(Set<String> wfCanWithdrawPks, Set<String> noProcessPks, Map<String, String> canNotWithdrawCauses) {
        List<String> inProcessCanWdPksSet = WfUtils.formatInQueryParam(new ArrayList<Object>(noProcessPks), 500, true);
        String deadJobQuerySql = "select fid id,FBUSINESSKEY businesskey,FHANDLERTYPE handleType from t_wf_deadletterjob twd where fhandlertype in ('start-process-event','address-process-event') and fbusinesskey in ";
        try (DataSet ds = WfUtils.batchQueryByIn(deadJobQuerySql, inProcessCanWdPksSet, "wf.deadletter.wdExe", false);){
            if (ds != null) {
                ArrayList<String> rootJobIds = new ArrayList<String>(16);
                for (Row r : ds) {
                    String pk = r.getString("businesskey");
                    noProcessPks.remove(pk);
                    String handlerType = r.getString("handleType");
                    if ("address-process-event".equals(handlerType)) {
                        rootJobIds.add(String.valueOf(r.getLong("id")));
                        wfCanWithdrawPks.add(pk);
                        continue;
                    }
                    wfCanWithdrawPks.remove(pk);
                    canNotWithdrawCauses.put(pk, String.format("%s_%s", pk, ResManager.loadKDString((String)"\u64a4\u56de\u5931\u8d25\uff1a\u5f53\u524d\u6d41\u7a0b\u542f\u52a8\u65f6\u6302\u8d77\uff0c\u4e0d\u80fd\u64a4\u56de\u3002", (String)"CanWithdrawTaskCmd_3", (String)"bos-wf-engine", (Object[])new Object[0])));
                }
                if (!rootJobIds.isEmpty()) {
                    String entityNumber = this.objs[0].getDataEntityType().getName();
                    WfCacheHelper.putWithdrawTimerOrDeadJobRootId(entityNumber, rootJobIds.toArray(new String[0]));
                }
            }
        }
    }

    private void filterExeutedTimerjobPks(Set<String> noProcessPks, Set<String> wfCanWithdrawPks, Map<String, String> canNotWithdrawCauses) {
        ArrayList<Object> filterPks = new ArrayList<Object>(noProcessPks);
        filterPks.addAll(wfCanWithdrawPks);
        if (!filterPks.isEmpty()) {
            List<String> inProcessCanWdPksSet = WfUtils.formatInQueryParam(filterPks, 500, true);
            String timerJobQuerySql = "SELECT FBUSINESSKEY businesskey,FHANDLERTYPE handlerType,fid id FROM t_wf_timerjob WHERE FHANDLERTYPE in ('address-process-event','async-continuation','async-trigger','start-process-event','multi-async-continuation') AND FBUSINESSKEY in ";
            try (DataSet ds = WfUtils.batchQueryByIn(timerJobQuerySql, inProcessCanWdPksSet, "wf.timerjob.wdExe", false);){
                if (ds != null) {
                    ArrayList<String> rootJobIds = new ArrayList<String>(16);
                    for (Row r : ds) {
                        String pk = r.getString("businesskey");
                        noProcessPks.remove(pk);
                        String handlerType = r.getString("handlerType");
                        if ("address-process-event".equals(handlerType)) {
                            rootJobIds.add(String.valueOf(r.getLong("id")));
                            wfCanWithdrawPks.add(pk);
                            continue;
                        }
                        wfCanWithdrawPks.remove(pk);
                        canNotWithdrawCauses.put(pk, String.format("%s_%s", pk, ResManager.loadKDString((String)"\u64a4\u56de\u5931\u8d25\uff1a\u5f53\u524d\u6d41\u7a0b\u51fa\u9519\u6b63\u5728\u91cd\u8bd5\uff0c\u4e0d\u80fd\u64a4\u56de\u3002", (String)"CanWithdrawTaskCmd_5", (String)"bos-wf-engine", (Object[])new Object[0])));
                    }
                    if (!rootJobIds.isEmpty()) {
                        String entityNumber = this.objs[0].getDataEntityType().getName();
                        WfCacheHelper.putWithdrawTimerOrDeadJobRootId(entityNumber, rootJobIds.toArray(new String[0]));
                    }
                }
            }
        }
    }

    private void addAbandonWitdrawBusinesskey(Set<String> wfCanWithdrawObjsByAbandonProcess, Map<String, Boolean> procsStatus, Long procDefId, Long procInstId, String pk, Map<String, String> canNotWithdrawCauses) {
        Process proc;
        StringBuilder prcstatusb = new StringBuilder();
        prcstatusb.append(procDefId).append('_').append(procInstId);
        String procsStatusMapKey = prcstatusb.toString();
        Boolean status = procsStatus.get(procsStatusMapKey);
        if (status == null && (status = (proc = ProcessDefinitionUtil.getProcess(procDefId, procInstId)).getWithdrawProcInAuditing()) != null) {
            procsStatus.put(procsStatusMapKey, status);
        }
        if (status != null && status.booleanValue()) {
            wfCanWithdrawObjsByAbandonProcess.add(pk);
            canNotWithdrawCauses.remove(pk);
        }
    }

    private boolean validateCanWithdraw(String businessKey, CommandContext commandContext, Map<String, String> notWitdrawCauses) {
        boolean ret;
        block3: {
            ret = true;
            try {
                TaskEntityManager taskEntityManager = commandContext.getTaskEntityManager();
                List<TaskEntity> taskEntitys = taskEntityManager.findTasksByBusinessKey(businessKey);
                if (taskEntitys == null || taskEntitys.isEmpty()) break block3;
                Process process = ProcessDefinitionUtil.getProcess(taskEntitys.get(0).getProcessDefinitionId(), taskEntitys.get(0).getProcessInstanceId());
                for (TaskEntity taskEntity : taskEntitys) {
                    UserTask userTask = (UserTask)process.getFlowElement(taskEntity.getTaskDefinitionKey(), true);
                    ret = commandContext.getProcessEngineConfiguration().getListenerNotificationHelper().executeCanWithdrawListeners(userTask, taskEntity);
                    if (ret) continue;
                    notWitdrawCauses.put(businessKey, String.format("%s_%s", businessKey, ResManager.loadKDString((String)"\u64a4\u56de\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5f53\u524d\u8282\u70b9\u4e0d\u80fd\u64a4\u56de\u3002", (String)"CanWithdrawTaskCmd_0", (String)"bos-wf-engine", (Object[])new Object[0])));
                    break;
                }
            }
            catch (Exception e) {
                logger.warn("validateCanWithdraw error : " + WfUtils.getExceptionStacktrace(e));
                notWitdrawCauses.put(businessKey, String.format("%s_%s", businessKey, ResManager.loadKDString((String)"\u64a4\u56de\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5f53\u524d\u8282\u70b9\u4e0d\u80fd\u64a4\u56de\u3002", (String)"CanWithdrawTaskCmd_0", (String)"bos-wf-engine", (Object[])new Object[0])));
                ret = false;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> findInBizJobsAndCache(Collection<String> notInProcessPks) {
        ArrayList<String> bizJobIds = new ArrayList<String>(16);
        ArrayList<String> bizDBPKs = new ArrayList<String>(16);
        String dbRouteKey = this.objs[0].getDataEntityType().getDBRouteKey();
        DBRoute dbRoute = DBRoute.of((String)dbRouteKey);
        boolean existTable = DB.exitsTable((DBRoute)dbRoute, (String)"t_wf_jobrecord");
        if (existTable) {
            String queryBizJobsSql = "SELECT fid jobId,FBUSINESSKEY businesskey from t_wf_jobrecord where FBUSINESSKEY in  ";
            List<String> queryPksSet = WfUtils.formatInQueryParam(new ArrayList<Object>(notInProcessPks), 100, true);
            DataSet unionDs = null;
            try {
                for (String queryPks : queryPksSet) {
                    logger.debug("current query is " + queryBizJobsSql + queryPks);
                    DataSet ds = DB.queryDataSet((String)"wf.withdraw.queryBizJobs", (DBRoute)dbRoute, (String)(queryBizJobsSql + queryPks));
                    if (unionDs == null) {
                        unionDs = ds;
                        continue;
                    }
                    unionDs = unionDs.union(ds);
                }
                if (unionDs != null) {
                    for (Row row : unionDs) {
                        bizJobIds.add(String.valueOf(row.getLong("jobId")));
                        bizDBPKs.add(row.getString("businesskey"));
                    }
                    String entityNumber = this.objs[0].getDataEntityType().getName();
                    WfCacheHelper.putWithdrawDeleteBizJobs(entityNumber, bizJobIds.toArray(new String[0]));
                    WfCacheHelper.removeAddressPksBatch(entityNumber, bizDBPKs.toArray(new String[0]));
                }
            }
            catch (Exception e) {
                logger.warn("withdraw.queryBizJobs error : " + WfUtils.getExceptionStacktrace(e));
            }
            finally {
                if (unionDs != null) {
                    unionDs.close();
                    unionDs = null;
                    logger.debug("close DataSet!");
                }
            }
        }
        return bizJobIds;
    }
}

