/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.io.Serializable;
import java.util.List;
import kd.bos.workflow.bizflow.util.BizFlowUtil;
import kd.bos.workflow.bpmn.converter.util.CollectionUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.TaskHelper;

public class CloseTasksCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    private List<Long> taskIds;

    public CloseTasksCmd(List<Long> taskIds) {
        this.taskIds = taskIds;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        List<TaskEntity> tasks = commandContext.getTaskEntityManager().findByTaskIds(this.taskIds);
        if (CollectionUtils.isNotEmpty(tasks)) {
            for (TaskEntity task : tasks) {
                BizFlowUtil.closeUserTask(commandContext, task.getExecution(), task);
            }
        }
        TaskHelper taskHelper = commandContext.getProcessEngineConfiguration().getTaskHelper();
        taskHelper.gatherAsyncCompensationData(tasks);
        return null;
    }
}

