/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.DecisionOption;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.job.EventTriggerCmd;
import kd.bos.workflow.engine.impl.cmd.startup.EnterSensitiveFieldChangeCmd;
import kd.bos.workflow.engine.impl.cmd.task.AbstractCompleteTaskCmd;
import kd.bos.workflow.engine.impl.cmd.task.BatchCompleteTask;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.SensitiveFieldUtil;
import kd.bos.workflow.engine.impl.util.TaskHelper;
import kd.bos.workflow.engine.task.TaskCompleteEventParams;
import kd.bos.workflow.engine.task.TaskEventTypeEnum;

public class CompleteTaskCmd
extends AbstractCompleteTaskCmd {
    private Log log = LogFactory.getLog(this.getClass());
    private static final long serialVersionUID = 1L;
    protected Long userId;
    protected Map<String, Object> variables;
    protected boolean checkDecisionNumber;
    public static final String NOCOMMENT = "nocomment";
    private List<TaskCompleteEventParams> taskCompleteEventParams = new ArrayList<TaskCompleteEventParams>();

    public CompleteTaskCmd(Long taskId, Long userId, Map<String, Object> variables, boolean checkDecisionNumber) {
        super(taskId);
        this.userId = userId;
        this.variables = variables;
        this.checkDecisionNumber = checkDecisionNumber;
    }

    @Override
    protected String execute(CommandContext commandContext, TaskEntity task) {
        if (this.checkDecisionNumber && !BpmnModelUtil.instanceofUserTaskOnly(task.getCategory())) {
            String decOptionNumber = (String)this.variables.get("auditNumber");
            boolean find = false;
            if (WfUtils.isNotEmpty(decOptionNumber) && BpmnModelUtil.instanceofAuditTask(task.getCategory())) {
                Long procDefId = task.getProcessDefinitionId();
                Long processInstanceId = task.getProcessInstanceId();
                String taskDefinitionKey = task.getTaskDefinitionKey();
                BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(procDefId, processInstanceId);
                AuditTask flowElement = (AuditTask)bpmnModel.getFlowElement(taskDefinitionKey);
                List<DecisionOption> decisionOptions = flowElement.getDecisionOptions();
                for (DecisionOption decision : decisionOptions) {
                    if (!decOptionNumber.equalsIgnoreCase(decision.getNumber())) continue;
                    this.variables.put("auditNumber", decision.getNumber());
                    this.variables.put("decisionscene", decision.getDecisionScene());
                    String multiKey = BpmnModelUtil.getDecisionNameMultiKey(flowElement.getId(), decision.getId());
                    ILocaleString decisionName = BpmnModelUtil.getMultiLangFieldValue(processInstanceId, multiKey, decision.getName());
                    this.variables.put("auditName", decisionName);
                    this.variables.put("auditType", decision.getAuditType());
                    if ("terminate".equalsIgnoreCase(decision.getAuditType())) {
                        this.variables.put("dynType", "auditAbort");
                    }
                    find = true;
                    break;
                }
            }
            if (!find || WfUtils.isEmpty(decOptionNumber)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u51b3\u7b56\u9879\u7f16\u7801\u4e0e\u8282\u70b9\u51b3\u7b56\u9879\u914d\u7f6e\u7684\u7f16\u7801\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"CompleteTaskCmd_11", (String)"bos-wf-engine", (Object[])new Object[0]));
            }
        }
        if (BpmnModelUtil.instanceofUserTaskOnly(task.getCategory())) {
            String auditNumber;
            TaskHelper taskHelper = commandContext.getProcessEngineConfiguration().getTaskHelper();
            if (this.variables != null && this.variables.get("auditName") == null && WfUtils.isNotEmpty(auditNumber = (String)this.variables.get("auditNumber"))) {
                try {
                    Map operate = EntityMetadataCache.getDataEntityOperate((String)task.getEntityNumber(), (String)auditNumber);
                    LocaleString name = new LocaleString();
                    if (operate != null && !operate.isEmpty() && operate.get("name") != null) {
                        Map operateName = (Map)operate.get("name");
                        for (Map.Entry entry : operateName.entrySet()) {
                            name.setItem((String)entry.getKey(), entry.getValue());
                        }
                    }
                    this.variables.put("auditName", name);
                }
                catch (Exception e) {
                    this.log.info(String.format("cannot get operation name for [%s],exception is [%s]", auditNumber, e.getMessage()));
                }
                this.getSensitiveFieldInfos(task);
                taskHelper.wrapBackToRejectVariables(commandContext, task, this.variables);
            }
            if (this.variables != null && this.variables.get("terminal") == null) {
                this.variables.put("terminal", RequestContext.get().getClient());
            }
            if (this.variables == null || this.variables != null && this.variables.get(NOCOMMENT) == null) {
                taskHelper.addComment(this.taskId, task.getProcessInstanceId(), this.userId, null, this.variables);
            }
            this.parseEventParams(task);
            task.setTransientVariable("syncTaskComplete", true);
            taskHelper.CompleteTask(task, this.userId, this.variables, true);
            task.removeTransientVariable("syncTaskComplete");
            if (commandContext.getProcessEngineConfiguration().isEnableBecEventDispatcher()) {
                HashMap<String, Object> eventMap = new HashMap<String, Object>();
                if (this.variables != null) {
                    eventMap.put("auditMessage", this.variables.get("auditMessage"));
                }
                eventMap.put("taskCompleteEventParams", this.taskCompleteEventParams);
                new EventTriggerCmd(TaskEventTypeEnum.COMPLATE_TASK_EVENT.getCode(), SerializationUtils.toJsonString(eventMap)).execute(commandContext);
            }
            JSONObject aJsonObject = new JSONObject();
            aJsonObject.put("success", (Object)Boolean.TRUE);
            aJsonObject.put("result", (Object)ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u5ba1\u6279\u5b8c\u6210\u3002", (String)"CompleteTaskCmd_12", (String)"bos-wf-engine", (Object[])new Object[0]));
            return aJsonObject.toJSONString();
        }
        if (BpmnModelUtil.instanceofAuditTask(task.getCategory())) {
            this.getSensitiveFieldInfos(task);
        }
        return new BatchCompleteTask(task, this.userId, this.variables, Boolean.TRUE, Boolean.TRUE).execute(commandContext);
    }

    @Override
    protected String getSuspendedTaskException() {
        return ResManager.loadKDString((String)"\u6d41\u7a0b\u5df2\u6302\u8d77\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CompleteTaskCmd_13", (String)"bos-wf-engine", (Object[])new Object[0]);
    }

    private void getSensitiveFieldInfos(TaskEntity task) {
        String decOptionNumber = (String)this.variables.get("auditNumber");
        if (WfUtils.isNotEmpty(decOptionNumber)) {
            String sensitiveFieldInfosStr;
            String businessKey = task.getBusinessKey();
            String entityNumber = task.getEntityNumber();
            DynamicObject dataEntity = WfUtils.findBusinessObject(businessKey, entityNumber);
            CommandContext commandContext = Context.getCommandContext();
            Object map = new EnterSensitiveFieldChangeCmd(task.getEntityNumber(), new DynamicObject[]{dataEntity}, decOptionNumber, null, task.getCategory(), true).execute(commandContext);
            if (!map.isEmpty() && WfUtils.isNotEmpty(sensitiveFieldInfosStr = (String)map.get("sensitiveFieldInfos"))) {
                List sensitiveFieldInfos = (List)SerializationUtils.fromJsonString((String)sensitiveFieldInfosStr, List.class);
                String buildSensitiveFieldKey = SensitiveFieldUtil.buildSensitiveFieldKey(task.getBusinessKey(), task.getTaskDefinitionKey());
                this.variables.put(buildSensitiveFieldKey, SerializationUtils.toJsonString(sensitiveFieldInfos.get(0)));
            }
        }
    }

    private void parseEventParams(TaskEntity task) {
        TaskCompleteEventParams taskCompleteEventParam = new TaskCompleteEventParams();
        taskCompleteEventParam.setTaskId(task.getId());
        taskCompleteEventParam.setBusinessKey(task.getBusinessKey());
        taskCompleteEventParam.setEntityNumber(task.getEntityNumber());
        taskCompleteEventParam.setAuditNumber((String)this.variables.get("auditNumber"));
        taskCompleteEventParam.setBillNum(task.getBillNo());
        this.taskCompleteEventParams.add(taskCompleteEventParam);
    }
}

