/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.util.HashSet;
import java.util.List;
import kd.bos.orm.query.QFilter;
import kd.bos.threads.ThreadPools;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.task.thread.AddTaskToFoldThred;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskCenterNavigationEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskCenterRuleEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.taskrule.VerifyConditionUtils;

public class ExecuteFolderCmd
implements Command<Object> {
    private long userId;
    private long folderId;
    private boolean async;

    public ExecuteFolderCmd(Long userId, Long folderId, boolean async) {
        this.userId = userId;
        this.folderId = folderId;
        this.async = async;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        if (this.async) {
            ThreadPools.executeOnceIncludeRequestContext((String)"AddExistTaskToFolder", (Runnable)new AddTaskToFoldThred(this.folderId, this.userId, this.async));
            return null;
        }
        QFilter filter = new QFilter("userid", "=", (Object)this.userId);
        QFilter notNullFilter = new QFilter("taskid", "!=", (Object)0);
        QFilter[] filters = new QFilter[]{filter, notNullFilter};
        List identityLinkEntitys = commandContext.getIdentityLinkEntityManager().findByQueryFilters(filters);
        TaskCenterRuleEntity centerRule = ((TaskCenterNavigationEntity)commandContext.getTaskCenterNavigationEntityManager().findById(this.folderId)).getTaskCenterRuleEntity();
        if (centerRule != null) {
            HashSet<Long> taskIds = new HashSet<Long>();
            for (IdentityLinkEntity identityLinkEntity : identityLinkEntitys) {
                Long taskid = identityLinkEntity.getTaskId();
                if (!WfUtils.isNotEmpty(taskid)) continue;
                taskIds.add(taskid);
            }
            QFilter taskIdFilter = new QFilter("id", "in", taskIds);
            List tasks = commandContext.getTaskEntityManager().findByQueryFilters(new QFilter[]{taskIdFilter});
            for (TaskEntity t : tasks) {
                VerifyConditionUtils.verifyOneRuleAndExecute(this.userId, t.getId(), commandContext, centerRule, t);
            }
        }
        return null;
    }
}

