/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.io.Serializable;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.task.TaskInfo;
import kd.bos.workflow.engine.task.TaskUtils;

public class FindTaskByActivityInstanceIdCmd
implements Command<TaskInfo>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected Long activityId;
    protected Long taskId;
    protected boolean needCurrentTask;
    protected String businessKey;
    private Log logger = LogFactory.getLog(this.getClass());

    public FindTaskByActivityInstanceIdCmd(Long activityId) {
        this.activityId = activityId;
    }

    public FindTaskByActivityInstanceIdCmd(Long activityId, Long taskId, boolean needCurrentTask) {
        this.activityId = activityId;
        this.taskId = taskId;
        this.needCurrentTask = needCurrentTask;
    }

    public FindTaskByActivityInstanceIdCmd(Long activityId, Long taskId, boolean needCurrentTask, String businessKey) {
        this.activityId = activityId;
        this.taskId = taskId;
        this.needCurrentTask = needCurrentTask;
        this.businessKey = businessKey;
    }

    @Override
    public TaskInfo execute(CommandContext commandContext) {
        this.logger.debug(String.format("kd.bos.workflow.engine.impl.cmd.task.FindTaskByActivityInstanceIdCmd.execute(CommandContext) parameter activityId:%s, taskId:%s, needCurrentTask:%s, businessKey:%s", this.activityId, this.taskId, this.needCurrentTask, this.businessKey));
        HistoricActivityInstanceEntity activityEntity = this.getActivityEntity(commandContext);
        if (null != activityEntity) {
            return this.getTaskIfo(commandContext, activityEntity);
        }
        if (WfUtils.isEmpty(this.taskId)) {
            activityEntity = commandContext.getHistoricActivityInstanceEntityManager().findByBusinessKeyAndActivityInstId(this.businessKey, this.activityId);
            if (null == activityEntity) {
                this.logger.debug("kd.bos.workflow.engine.impl.cmd.task.FindTaskByActivityInstanceIdCmd.execute(CommandContext) activityEntity is null.");
                return null;
            }
            this.taskId = activityEntity.getTaskId();
            if (WfUtils.isEmpty(this.taskId)) {
                this.logger.debug("kd.bos.workflow.engine.impl.cmd.task.FindTaskByActivityInstanceIdCmd.execute(CommandContext) taskId is null.");
                return null;
            }
        }
        this.logger.debug("kd.bos.workflow.engine.impl.cmd.task.FindTaskByActivityInstanceIdCmd.execute(CommandContext) taskId:" + this.taskId);
        return (TaskInfo)commandContext.getHistoricTaskInstanceEntityManager().findById(this.taskId);
    }

    private TaskInfo getTaskIfo(CommandContext commandContext, HistoricActivityInstanceEntity activityEntity) {
        HistoricTaskInstanceEntity entity;
        TaskInfo taskInfo = null;
        if (this.needCurrentTask && null != (taskInfo = TaskUtils.getRealTaskInfo(activityEntity.getProcessInstanceId()))) {
            return taskInfo;
        }
        Long taskId = activityEntity.getTaskId();
        if (null == activityEntity.getEndTime()) {
            taskInfo = (TaskInfo)commandContext.getTaskEntityManager().findById(taskId);
        }
        if (null == taskInfo && null != (entity = (HistoricTaskInstanceEntity)commandContext.getHistoricTaskInstanceEntityManager().findById(taskId)) && !"task withdraw".equals(entity.getDeleteReason())) {
            taskInfo = entity;
        }
        return taskInfo;
    }

    private HistoricActivityInstanceEntity getActivityEntity(CommandContext commandContext) {
        String fields = String.format("%s,%s,%s", "endTime", "taskId", "processInstanceId");
        List activityEntities = commandContext.getHistoricActivityInstanceEntityManager().findByQueryFilters(new QFilter[]{new QFilter("id", "=", (Object)this.activityId)}, fields, null, false);
        if (null == activityEntities || activityEntities.isEmpty()) {
            return null;
        }
        return (HistoricActivityInstanceEntity)activityEntities.get(0);
    }
}

