/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.io.Serializable;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.EntityNumberConstant;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.task.TaskInfo;
import kd.bos.workflow.engine.task.TaskUtils;

public class FindTaskByIdAndTypeCmd
implements Command<TaskInfo>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected Long taskId;
    protected String type;
    protected boolean showByUrl;
    protected boolean bizTask = false;
    private Log logger = LogFactory.getLog(this.getClass());

    public FindTaskByIdAndTypeCmd(Long taskId, String type) {
        this.taskId = taskId;
        this.type = type;
    }

    public FindTaskByIdAndTypeCmd(Long taskId, String type, Object showByUrlObj) {
        this.taskId = taskId;
        this.type = type;
        this.showByUrl = null != showByUrlObj ? Boolean.parseBoolean(showByUrlObj.toString()) : false;
    }

    public FindTaskByIdAndTypeCmd(Long taskId, String type, Object showByUrlObj, boolean bizTask) {
        this.taskId = taskId;
        this.type = type;
        this.showByUrl = null != showByUrlObj ? Boolean.parseBoolean(showByUrlObj.toString()) : false;
        this.bizTask = bizTask;
    }

    @Override
    public TaskInfo execute(CommandContext commandContext) {
        return this.findTaskByIdAndType(commandContext);
    }

    private TaskInfo findTaskByIdAndType(CommandContext commandContext) {
        boolean queryTask;
        TaskInfo entity = null;
        this.logger.info("kd.bos.workflow.engine.impl.cmd.task.FindTaskByIdAndTypeCmd.findTaskByIdAndType type: " + this.type + "; taskId: " + this.taskId);
        if (this.bizTask) {
            if ("toHandle".equals(this.type)) {
                entity = (TaskInfo)commandContext.getTaskEntityManager().findById(this.taskId);
                if (entity == null) {
                    entity = (TaskInfo)commandContext.getHistoricTaskInstanceEntityManager().findById(this.taskId);
                }
            } else {
                entity = "handled".equals(this.type) ? (TaskInfo)commandContext.getHistoricTaskInstanceEntityManager().findById(this.taskId) : (TaskInfo)commandContext.getHistoricTaskInstanceEntityManager().findById(this.taskId);
            }
            return entity;
        }
        boolean bl = queryTask = "toHandle".equals(this.type) || "circulation".equals(this.type);
        if (queryTask) {
            if (!this.showByUrl) {
                entity = (TaskInfo)commandContext.getTaskEntityManager().findById(this.taskId);
            } else {
                List hiTaskEntities = commandContext.getHistoricTaskInstanceEntityManager().findByQueryFilters(new QFilter[]{new QFilter("id", "=", (Object)this.taskId), new QFilter("display", "=", (Object)"1")}, "processInstanceId", "createDate desc");
                if (null != hiTaskEntities && !hiTaskEntities.isEmpty()) {
                    entity = TaskUtils.getRealTaskInfo(((HistoricTaskInstanceEntity)hiTaskEntities.get(0)).getProcessInstanceId());
                }
            }
        }
        if ("handled".equals(this.type) || queryTask && entity == null) {
            entity = (TaskInfo)commandContext.getHistoricTaskInstanceEntityManager().findById(this.taskId);
            if (!this.showByUrl || null == entity || !WfConfigurationUtil.isOptimizeLogicForLinkMessage()) {
                return entity;
            }
            return TaskUtils.defaultHistoricTaskInstanceEntity(commandContext, entity.getProcessInstanceId());
        }
        if ("applyed".equals(this.type) || "toApply".equals(this.type)) {
            Long assignId = Long.parseLong(RequestContext.get().getUserId());
            Long processInstanceId = this.taskId;
            QFilter filterForProcInstId = new QFilter("id", "=", (Object)this.taskId);
            QFilter filterForCreateId = new QFilter("creatorid", "=", (Object)assignId);
            QFilter[] filters = new QFilter[]{filterForProcInstId, filterForCreateId};
            boolean exists = QueryServiceHelper.exists((String)EntityNumberConstant.getHiProcInstEntityNumber(), (QFilter[])filters);
            if (exists) {
                EntityQueryBuilder queryBuilder = commandContext.getHistoricTaskInstanceEntityManager().createQueryBuilder().addFilter("processInstanceId", processInstanceId).orderBy("createDate");
                List entities = commandContext.getHistoricTaskInstanceEntityManager().findByQueryBuilder(queryBuilder);
                if (null != entities && 0 != entities.size()) {
                    entity = (TaskInfo)entities.get(0);
                } else {
                    return TaskUtils.getHiTaskEntityByProcessInstanceId(commandContext, processInstanceId);
                }
            }
        }
        if (("dynApply".equals(this.type) || "dynnApply".equals(this.type)) && null == (entity = TaskUtils.getRealTaskInfo(this.taskId))) {
            return TaskUtils.defaultHistoricTaskInstanceEntity(commandContext, this.taskId);
        }
        return entity;
    }
}

