/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.util.List;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskHandleLogEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskHandleLogEntityManager;
import kd.bos.workflow.exception.WFIllegalArgumentException;

public class FindTaskHandleLogsCmd
implements Command<List<TaskHandleLogEntity>> {
    private Long taskId;
    private Long userId;
    private String[] types;

    public FindTaskHandleLogsCmd(Long taskId, String ... types) {
        this.taskId = taskId;
        this.types = types;
    }

    public FindTaskHandleLogsCmd(Long taskId, Long userId) {
        this.taskId = taskId;
        this.userId = userId;
    }

    @Override
    public List<TaskHandleLogEntity> execute(CommandContext commandContext) {
        if (this.taskId == null) {
            throw new WFIllegalArgumentException("taskId is null!");
        }
        TaskHandleLogEntityManager handleLogManager = commandContext.getTaskHandleLogEntityManager();
        if (this.userId != null) {
            return handleLogManager.getUserTaskTransferLogs(this.taskId, this.userId);
        }
        return handleLogManager.getTaskHandleLogs(this.taskId, "", this.types);
    }
}

