/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.DecisionOption;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.SelectNodesModel;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.dynprocess.freeflow.WFDecisionOption;
import kd.bos.workflow.engine.dynprocess.freeflow.WFRejectNodesModel;
import kd.bos.workflow.engine.impl.cmd.GetBpmnModelCmd;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;

public class GetApprovalDecisionOptionsCmd
implements Command<List<WFDecisionOption>>,
Serializable {
    private static final long serialVersionUID = 3654652784229663839L;
    private Long taskId;

    public GetApprovalDecisionOptionsCmd(Long taskId) {
        this.taskId = taskId;
    }

    @Override
    public List<WFDecisionOption> execute(CommandContext commandContext) {
        TaskEntity taskEntity = (TaskEntity)commandContext.getTaskEntityManager().findById(this.taskId);
        if (taskEntity == null) {
            return Collections.emptyList();
        }
        long procDefId = taskEntity.getProcessDefinitionId();
        long procInstId = taskEntity.getProcessInstanceId();
        String activityId = taskEntity.getTaskDefinitionKey();
        BpmnModel bpmnModel = new GetBpmnModelCmd(procDefId, procInstId).execute(commandContext);
        FlowElement flowElement = bpmnModel.getFlowElement(activityId);
        List decisionOptions = flowElement.getDecisionOptions();
        ArrayList<WFDecisionOption> result = new ArrayList<WFDecisionOption>(16);
        for (DecisionOption dOption : decisionOptions) {
            WFDecisionOption wfDecisionOption = this.packageDecisionOption(dOption, procInstId, commandContext);
            result.add(wfDecisionOption);
        }
        return result;
    }

    private WFDecisionOption packageDecisionOption(DecisionOption dOption, Long procInstId, CommandContext commandContext) {
        String number = dOption.getNumber();
        String name = dOption.getName();
        boolean isDefaultDecision = dOption.isDefaultDecision();
        String auditType = dOption.getAuditType();
        List<SelectNodesModel> rejectOptions = dOption.getRejectOptions();
        ArrayList<WFRejectNodesModel> wfRejectNodesModels = new ArrayList<WFRejectNodesModel>(16);
        for (SelectNodesModel selectNodesModel : rejectOptions) {
            WFRejectNodesModel rejectNodesModel = this.packageRejectNodeModel(selectNodesModel);
            wfRejectNodesModels.add(rejectNodesModel);
        }
        WFDecisionOption wOption = new WFDecisionOption();
        wOption.setNumber(number);
        wOption.setName(new LocaleString(name));
        wOption.setDefaultDecision(isDefaultDecision);
        wOption.setAuditType(auditType);
        wOption.setRejectOptions(this.filterNoThroughNodes(procInstId, wfRejectNodesModels, commandContext));
        return wOption;
    }

    private WFRejectNodesModel packageRejectNodeModel(SelectNodesModel selectNodesModel) {
        WFRejectNodesModel rejectNodesModel = new WFRejectNodesModel();
        String name = selectNodesModel.getName();
        String itemId = selectNodesModel.getItemId();
        rejectNodesModel.setName(name);
        rejectNodesModel.setItemId(itemId);
        return rejectNodesModel;
    }

    private List<WFRejectNodesModel> filterNoThroughNodes(Long procInstId, List<WFRejectNodesModel> wfRejectNodesModels, CommandContext commandContext) {
        Boolean isOpen = WfConfigurationUtil.isIgnoreNoThroughNode();
        if (!isOpen.booleanValue()) {
            return wfRejectNodesModels;
        }
        if (wfRejectNodesModels.size() == 0) {
            return wfRejectNodesModels;
        }
        List<HistoricActivityInstanceEntity> tempList = commandContext.getHistoricActivityInstanceEntityManager().findByProcessInstanceId(procInstId);
        List actIds = tempList.stream().map(r -> r.getActivityId()).collect(Collectors.toList());
        Iterator<WFRejectNodesModel> iterable = wfRejectNodesModels.iterator();
        while (iterable.hasNext()) {
            WFRejectNodesModel rejectNode = iterable.next();
            if (actIds.contains(rejectNode.getItemId())) continue;
            iterable.remove();
        }
        return wfRejectNodesModels;
    }
}

