/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.task.TaskUtils;

public class GetApprovalRecordItemsByParentTaskIdCmd
implements Command<List<Map<String, Object>>>,
Serializable {
    private static final long serialVersionUID = 4208032629262236184L;
    private Long parentTaskId;
    private static final String FRESULTNAME = "fresultname";
    private static final String FMESSAGE = "fmessage";
    private static final String MESSAGE = "message";

    public GetApprovalRecordItemsByParentTaskIdCmd(Long parentTaskId) {
        this.parentTaskId = parentTaskId;
    }

    @Override
    public List<Map<String, Object>> execute(CommandContext commandContext) {
        ArrayList<Map<String, Object>> children = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> child = null;
        String masterTableAlias = "c";
        String multiLangTableAlias = "d";
        String entityNumber = "wf_hicomment";
        String resultNameSQL = WfMultiLangUtils.getGeneralLangSQL(entityNumber, masterTableAlias, multiLangTableAlias, FRESULTNAME, FRESULTNAME, "resultname");
        String messageSQL = WfMultiLangUtils.getGeneralLangSQL(entityNumber, masterTableAlias, multiLangTableAlias, FMESSAGE, FMESSAGE, MESSAGE);
        String sql = "SELECT a.fuserid, " + resultNameSQL + "," + messageSQL + ", c.ftime from t_wf_hiparticipant a LEFT JOIN t_wf_hicomment c on c.FTASKID = a.FTASKID LEFT JOIN t_wf_hicomment_l d on d.fid = c.FID  and d.FLOCALEID = ? where a.FPARENTTASKID = ?  AND a.FTYPE = 'participant'ORDER BY c.ftime ";
        Object[] params = new Object[]{RequestContext.get().getLang().toString(), this.parentTaskId};
        String algoKey = WfUtils.createAlgoKey(this.getClass().getName());
        Map<String, Object> userInfo = null;
        try (DataSet ds = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.workflow, (String)sql, (Object[])params);){
            for (Row row : ds) {
                userInfo = TaskUtils.getUserInfo(row.getLong("fuserid"));
                child = new HashMap<String, Object>();
                child.put("avatar", userInfo.get("avatar"));
                child.put("openId", userInfo.get("openid"));
                if (WfUtils.isEmptyString(row.getDate("ftime"))) {
                    child.put("userName", String.format(ResManager.loadKDString((String)"\u7b49\u5f85\u5ba1\u6279\uff1a%s", (String)"GetApprovalRecordItemsByParentTaskIdCmd_3", (String)"bos-wf-engine", (Object[])new Object[0]), userInfo.get("username")));
                    child.put("resultName", "");
                    child.put(MESSAGE, "");
                    child.put("decisionType", "");
                    child.put("time", null);
                } else {
                    child.put("userName", userInfo.get("username"));
                    child.put("resultName", row.getString(FRESULTNAME));
                    child.put(MESSAGE, row.getString(FMESSAGE));
                    child.put("decisionType", "approve");
                    child.put("time", WfUtils.parseToUserZoneDateString(row.getDate("ftime")));
                }
                children.add(child);
            }
        }
        return children;
    }
}

