/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.workflow.bpmn.model.BillPageAttributeConfigModel;
import kd.bos.workflow.bpmn.model.BillPageAttributeConfigModelDetail;
import kd.bos.workflow.bpmn.model.BillPageAttributeConfigModelDetailFieldInfo;
import kd.bos.workflow.bpmn.model.BillSetting;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.GetBpmnModelCmd;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.BillPageAttributeConfigEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;

public class GetAuditAllowModifiedFieldsCmd
implements Command<List<Map<String, String>>>,
Serializable {
    private static final long serialVersionUID = 4784475301027144896L;
    private static final String PC = "pc";
    private static final String MOBILE = "mobile";
    private Long taskId;
    private String type;

    public GetAuditAllowModifiedFieldsCmd(Long taskId, String type) {
        this.taskId = taskId;
        this.type = type;
    }

    @Override
    public List<Map<String, String>> execute(CommandContext commandContext) {
        UserTask userTask;
        BillSetting billSetting;
        TaskEntity taskEntity = (TaskEntity)commandContext.getTaskEntityManager().findById(this.taskId);
        if (taskEntity == null) {
            return Collections.emptyList();
        }
        long procDefId = taskEntity.getProcessDefinitionId();
        long procInstId = taskEntity.getProcessInstanceId();
        String activityId = taskEntity.getTaskDefinitionKey();
        BpmnModel bpmnModel = new GetBpmnModelCmd(procDefId, procInstId).execute(commandContext);
        FlowElement flowElement = bpmnModel.getFlowElement(activityId);
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        if (flowElement instanceof UserTask && (billSetting = (userTask = (UserTask)flowElement).getBillSetting()) != null) {
            this.getCanModifiedAttrs(billSetting, result);
        }
        return result;
    }

    private void getCanModifiedAttrs(BillSetting billSetting, List<Map<String, String>> result) {
        List<BillPageAttributeConfigEntity> pageAttrConfigs = null;
        if (PC.equals(this.type)) {
            pageAttrConfigs = billSetting.getPageAttrConfig();
        } else if (MOBILE.equals(this.type)) {
            pageAttrConfigs = billSetting.getMobilePageAttrConfig();
        }
        if (pageAttrConfigs == null) {
            BillPageAttributeConfigModel newConfigs = null;
            newConfigs = PC.equals(this.type) ? billSetting.getPageAttrConfigModel() : billSetting.getMobilePageAttrConfigModel();
            this.putResultsNew(result, newConfigs);
        } else {
            this.putResults(result, pageAttrConfigs);
        }
    }

    private void putResults(List<Map<String, String>> result, List<BillPageAttributeConfigEntity> pageAttrConfigs) {
        if (WfUtils.isEmptyForCollection(pageAttrConfigs)) {
            return;
        }
        for (BillPageAttributeConfigEntity entity : pageAttrConfigs) {
            if (!entity.isModify()) continue;
            HashMap<String, String> attrMap = new HashMap<String, String>();
            attrMap.put(entity.getFieldnumber(), entity.getFieldname());
            result.add(attrMap);
        }
    }

    private void putResultsNew(List<Map<String, String>> result, BillPageAttributeConfigModel configModel) {
        String numbers;
        BillPageAttributeConfigModelDetailFieldInfo modifyConfigs;
        BillPageAttributeConfigModelDetail configs;
        if (null != configModel && null != (configs = configModel.getField()) && null != (modifyConfigs = configs.getModify()) && WfUtils.isNotEmpty(numbers = modifyConfigs.getFieldnumber())) {
            HashMap<String, String> attrMap = new HashMap<String, String>();
            attrMap.put(numbers, modifyConfigs.getFieldname());
            result.add(attrMap);
        }
    }
}

