/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.workflow.bpmn.model.AuditPoint;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.calculator.ExpressionCalculatorUtil;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;

public class GetAuditPointValueCmd
implements Command<List<String>>,
Serializable {
    private static final long serialVersionUID = 4369887833970939170L;
    private List<AuditPoint> auditPoints;
    private String businessKey;
    private String entityNumber;
    private VariableScope variableScope;

    public GetAuditPointValueCmd(List<AuditPoint> auditPoints, String businessKey, String entityNumber, VariableScope variableScope) {
        this.auditPoints = auditPoints;
        this.businessKey = businessKey;
        this.entityNumber = entityNumber;
        this.variableScope = variableScope;
    }

    @Override
    public List<String> execute(CommandContext commandContext) {
        DynamicObject dynamicObject = WfUtils.findBusinessObject(this.businessKey, this.entityNumber);
        ArrayList<String> auditPointsParsered = null;
        if (WfUtils.isNotEmptyForCollection(this.auditPoints)) {
            auditPointsParsered = new ArrayList(this.auditPoints.size());
            for (AuditPoint auditPoint : this.auditPoints) {
                String auditPointDef = auditPoint.getInstruction();
                String auditPointParsered = ExpressionCalculatorUtil.contentParser(auditPointDef, dynamicObject, this.variableScope, true);
                auditPointsParsered.add(auditPointParsered);
            }
        } else {
            auditPointsParsered = new ArrayList<String>(1);
        }
        return auditPointsParsered;
    }
}

