/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.component.approvalrecord.ApprovalAttachmentInfo;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordItem;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.task.GetCoordinatorRecordCmd;
import kd.bos.workflow.engine.impl.flowchart.TaskHandleRecordsHelper;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskHandleLogEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.component.ApprovalRecordItem;
import kd.bos.workflow.engine.impl.util.CoordinateRecordUtil;
import kd.bos.workflow.engine.impl.util.ParticipantHelper;

public class GetAutoCoordinatorRecordCmd
implements Command<List<IApprovalRecordItem>> {
    private static Log logger = LogFactory.getLog(GetCoordinatorRecordCmd.class);
    private Long groupId;
    private Map<String, String> taskIdMapAttechmentId = new HashMap<String, String>();
    private TaskHandleRecordsHelper handleRecordsHelper;
    private static final String FMESSAGE = "fmessage";
    private static final String FASSIGNEE = "fassignee";
    private static final String FCOORDINVITEOPINION = "fcoordinviteopinion";
    private static final String USERNAME = "username";
    private static final String USERNAMEFORMAT = "usernameformat";
    private static final String FUSERNAMEFORMATTER = "fusernameformatter";

    public GetAutoCoordinatorRecordCmd(Long groupId) {
        this.groupId = groupId;
        this.handleRecordsHelper = new TaskHandleRecordsHelper(groupId);
    }

    @Override
    public List<IApprovalRecordItem> execute(CommandContext cct) {
        ArrayList<IApprovalRecordItem> coordinatorRecords = new ArrayList<IApprovalRecordItem>();
        coordinatorRecords.addAll(this.getCommentData());
        coordinatorRecords.addAll(this.getCurrentRecord());
        this.formatData(coordinatorRecords, cct);
        return coordinatorRecords;
    }

    private void formatData(List<IApprovalRecordItem> coordinatorRecords, CommandContext commandContext) {
        String currentUserId = RequestContext.get().getUserId();
        HashMap<Long, Map<String, String>> userInfos = new HashMap<Long, Map<String, String>>();
        for (IApprovalRecordItem i : coordinatorRecords) {
            Long ownerId;
            Long userId;
            Map<String, String> m;
            String attachmentIds;
            if (WfUtils.isNotEmpty(i.getTaskId()) && WfUtils.isNotEmpty(i.getUserId()) && WfUtils.isNotEmpty(attachmentIds = this.taskIdMapAttechmentId.get(i.getTaskId() + i.getUserId()))) {
                i.setState(attachmentIds);
                List<ApprovalAttachmentInfo> attachments = CoordinateRecordUtil.getApprovalAttachments(attachmentIds);
                i.setAttachments(attachments);
            }
            if ((m = WfUtils.getUserInfo(userInfos, userId = i.getUserId(), i.getAssignee(), false)) != null) {
                i.setAvatar(m.get("imgsrc"));
                i.setAssignee(" " + m.get("ftruename"));
                if (!currentUserId.equals(userId.toString())) {
                    i.setOpenId(m.get("fopenid"));
                }
                String assignee = i.getAssignee();
                if (WfUtils.isEmpty(i.getTime())) {
                    if (WfUtils.isNotEmpty(assignee) && assignee.contains("|")) {
                        i.setAssignee(String.format(ResManager.loadKDString((String)"%1$s \u6b63\u5728\u534f\u529e", (String)"GetCoordinatorRecordCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]), assignee));
                    }
                    i.setAttachments(null);
                }
            }
            if ((ownerId = i.getOwnerId()) == 1L) {
                i.setOwnerName(ResManager.loadKDString((String)"\u7cfb\u7edf", (String)"GetCoordinatorRecordCmd_2", (String)"bos-wf-engine", (Object[])new Object[0]));
                continue;
            }
            DynamicObject hiparticipant = null;
            List<HistoricIdentityLinkEntity> entitys = commandContext.getHistoricIdentityLinkEntityManager().findParticipantsByTaskIdAndUserId(Long.valueOf(i.getTaskId()), ownerId, "participant", "usernameformatter,username");
            if (WfUtils.isNotEmptyForCollection(entitys)) {
                hiparticipant = entitys.get(0).getDynamicObject();
            }
            LocaleString nameFormat = new LocaleString();
            if (hiparticipant != null && WfUtils.isNotEmpty(hiparticipant.getLocaleString("usernameformatter"))) {
                nameFormat = hiparticipant.getLocaleString("usernameformatter");
            } else if (hiparticipant != null && WfUtils.isNotEmpty(hiparticipant.getLocaleString(USERNAME))) {
                nameFormat = hiparticipant.getLocaleString(USERNAME);
            }
            String name = null;
            if (WfUtils.isNotEmpty((ILocaleString)nameFormat)) {
                name = nameFormat.getLocaleValue();
            }
            i.setOwnerName(name);
        }
    }

    private List<IApprovalRecordItem> getCommentData() {
        String masterTableAlias = "a";
        String multiLangTableAlias = "b";
        String entityNumber = "wf_hicomment";
        String messageSQL = WfMultiLangUtils.getGeneralLangSQL(entityNumber, masterTableAlias, multiLangTableAlias, FMESSAGE, FMESSAGE, "message");
        String resultNameSQL = WfMultiLangUtils.getGeneralLangSQL(entityNumber, masterTableAlias, multiLangTableAlias, "fresultname", "fresultname", "resultname");
        String assigneeSQL = WfMultiLangUtils.getGeneralLangSQL(entityNumber, masterTableAlias, multiLangTableAlias, FASSIGNEE, FASSIGNEE, "assignee");
        String activityNameSQL = WfMultiLangUtils.getGeneralLangSQL(entityNumber, masterTableAlias, multiLangTableAlias, "factivityname", "factivityname", "activityname");
        String subActivityNameSQL = WfMultiLangUtils.getGeneralLangSQL(entityNumber, masterTableAlias, multiLangTableAlias, "fsubactivityname", "subactivityname", "subactivityname");
        String userNameFormatterSQL = WfMultiLangUtils.getGeneralLangSQL(entityNumber, masterTableAlias, multiLangTableAlias, FUSERNAMEFORMATTER, FUSERNAMEFORMATTER, USERNAMEFORMAT);
        ArrayList<IApprovalRecordItem> coordinatorRecords = new ArrayList<IApprovalRecordItem>();
        String sql = "select " + messageSQL + ",a.fid commentId,a.ftaskid,a.frichtextmessage,a.fsignature,a.ftype,a.fuserid," + resultNameSQL + "," + userNameFormatterSQL + ",a.fdecisiontype,a.ftime,a.fgroupid," + assigneeSQL + ",a.factivityid," + activityNameSQL + ",a.fownerid,a.fispublic,a.fterminalway,c.furlid attachmentId," + subActivityNameSQL + " from t_wf_hicomment a left join t_wf_hicomment_l b on a.fid=b.fid left join t_wf_hiattachment c on c.fcontentId = a.fid where a.fownerid=1 and a.ftype='coordinate' and a.fgroupid=? and b.flocaleId=? ORDER BY a.ftime ASC";
        Object[] params = new Object[]{String.valueOf(this.groupId), RequestContext.get().getLang().name()};
        HashSet<Long> commentIds = new HashSet<Long>();
        DataSet ds = DB.queryDataSet((String)"GetCoordinatorRecord", (DBRoute)WfUtils.WFS, (String)sql, (Object[])params);
        Object object = null;
        try {
            Long userId = null;
            String userName = null;
            Long ownerId = null;
            Long taskId = null;
            Iterator iter = ds.iterator();
            while (iter.hasNext()) {
                ApprovalRecordItem item = new ApprovalRecordItem();
                Row r = (Row)iter.next();
                Boolean ispublic = r.getBoolean("fispublic");
                ownerId = r.getLong("fownerid");
                taskId = r.getLong("fgroupid");
                userId = r.getLong("fuserid");
                String userNameFormat = r.getString(FUSERNAMEFORMATTER);
                userName = ParticipantHelper.getUserName(r.getString(FASSIGNEE), userNameFormat);
                item.setTaskId(taskId.toString());
                Long attachmentId = r.getLong("attachmentId");
                if (WfUtils.isNotEmpty(attachmentId)) {
                    String key = taskId + "" + userId;
                    String attachmentIdsStr = this.taskIdMapAttechmentId.get(key);
                    if (WfUtils.isNotEmpty(attachmentIdsStr)) {
                        attachmentIdsStr = attachmentIdsStr + "," + attachmentId;
                        this.taskIdMapAttechmentId.put(key, attachmentIdsStr);
                        continue;
                    }
                    this.taskIdMapAttechmentId.put(key, attachmentId.toString());
                    item.setState(String.valueOf(attachmentId));
                }
                Long commentId = r.getLong("commentId");
                commentIds.add(commentId);
                item.setCommentId(r.getString("commentId"));
                String richTextMessage = r.getString("frichtextmessage");
                String message = WfUtils.isEmpty(richTextMessage) ? r.getString(FMESSAGE) : richTextMessage;
                item.setMessage(message);
                item.setUserId(userId);
                item.setUserStr(String.valueOf(userId));
                item.setAssignee(userName);
                item.setOwnerId(ownerId);
                Date time = r.getDate("ftime");
                if (time != null) {
                    item.setTime(WfUtils.parseToUserZoneDateString(time));
                    item.setFormatTime(time.getTime());
                }
                item.setShowTransferRecord(this.hasTransferRecords(userId));
                item.setTerminalWay(r.getString("fterminalway"));
                String signature = r.getString("fsignature");
                if (WfUtils.isNotEmpty(signature)) {
                    item.setSignature(signature);
                }
                coordinatorRecords.add(item);
            }
        }
        catch (Throwable userId) {
            object = userId;
            throw userId;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable userId) {
                        ((Throwable)object).addSuppressed(userId);
                    }
                } else {
                    ds.close();
                }
            }
        }
        if (!commentIds.isEmpty()) {
            try {
                DynamicObject[] commentDatas = BusinessDataServiceHelper.load((String)"wf_hicomment", (String)"id, coordinviteopinion", (QFilter[])new QFilter[]{new QFilter("id", "in", commentIds)});
                if (commentDatas != null && commentDatas.length > 0) {
                    block12: for (IApprovalRecordItem coordinatorRecord : coordinatorRecords) {
                        String commentId = coordinatorRecord.getCommentId();
                        for (DynamicObject commentData : commentDatas) {
                            if (!commentId.equals(commentData.getString("id"))) continue;
                            ILocaleString coordInviteOpinion = commentData.getLocaleString("coordinviteopinion");
                            String cio = (String)coordInviteOpinion.getDefaultItem();
                            ((ApprovalRecordItem)coordinatorRecord).setCoordInviteOpinion(cio);
                            continue block12;
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.info(String.format("queryCoordinateRecord_hasError:[%s]", WfUtils.getExceptionStacktrace(e)));
            }
        }
        return coordinatorRecords;
    }

    private List<IApprovalRecordItem> getCurrentRecord() {
        ArrayList<IApprovalRecordItem> coordinatorRecords = new ArrayList<IApprovalRecordItem>();
        String userNameSQL = WfMultiLangUtils.getGeneralLangSQL("wf_participant", "c", "d", "fusername", USERNAME, USERNAME);
        String userNmaeFormatSQL = WfMultiLangUtils.getGeneralLangSQL("wf_participant", "c", "d", FUSERNAMEFORMATTER, USERNAMEFORMAT, USERNAMEFORMAT);
        String sql = "select c.fownerId ownerId,c.fuserid userId, c.fispublic ispublic,c.ftaskid taskid," + userNameSQL + " ," + userNmaeFormatSQL + " from t_wf_participant c left JOIN t_wf_participant_l d ON c.FID = d.FID  where c.ftype='coordinate' and c.fownerId=1 and (c.ftaskid=? or c.fparenttaskid=?) and d.FLocaleID =?";
        String lang = RequestContext.get().getLang().toString();
        Object[] params = new Object[]{this.groupId, this.groupId, lang};
        try (DataSet ds = DB.queryDataSet((String)"GetCoordinatorRecord", (DBRoute)DBRoute.workflow, (String)sql, (Object[])params);){
            Long userId = null;
            String userName = null;
            Long ownerId = null;
            Long taskId = null;
            Iterator iter = ds.iterator();
            while (iter.hasNext()) {
                ApprovalRecordItem item = new ApprovalRecordItem();
                Row r = (Row)iter.next();
                userId = r.getLong("userId");
                String userNameFormat = r.getString(USERNAMEFORMAT);
                userName = ParticipantHelper.getUserName(r.getString(USERNAME), userNameFormat);
                ownerId = r.getLong("ownerId");
                taskId = r.getLong("taskid");
                item.setUserId(userId);
                item.setUserStr(String.valueOf(userId));
                item.setAssignee(userName);
                item.setTaskId(taskId.toString());
                item.setOwnerId(ownerId);
                item.setShowTransferRecord(this.hasTransferRecords(userId));
                coordinatorRecords.add(item);
            }
        }
        return coordinatorRecords;
    }

    private boolean hasTransferRecords(Long userId) {
        List<TaskHandleLogEntity> result = this.handleRecordsHelper.getUserCoordinateTransferRecord(userId);
        return result != null && !result.isEmpty();
    }
}

