/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.util.ArrayList;
import java.util.List;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.YunzhijiaTask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.GetBpmnModelCmd;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;

public class GetAutoCoorinateUsersBytaskIdCmd
implements Command<List<Long>> {
    private static final String COORDINATE = "coordinate";
    private long taskId;

    public GetAutoCoorinateUsersBytaskIdCmd(long taskId) {
        this.taskId = taskId;
    }

    @Override
    public List<Long> execute(CommandContext commandContext) {
        TaskEntity taskEntity = (TaskEntity)commandContext.getTaskEntityManager().findById(this.taskId);
        FlowElement flowElement = this.getFlowElementByTask(taskEntity, commandContext);
        ArrayList<Long> result = new ArrayList<Long>(16);
        long pTaskId = flowElement instanceof YunzhijiaTask ? taskEntity.getParentTaskId() : this.taskId;
        QFilter filter1 = new QFilter("taskid", "=", (Object)pTaskId);
        QFilter filter2 = new QFilter("type", "=", (Object)COORDINATE);
        QFilter filter3 = new QFilter("ownerid", "=", (Object)1L);
        QFilter[] filters = new QFilter[]{filter1, filter2, filter3};
        List iEntities = commandContext.getIdentityLinkEntityManager().findByQueryFilters(filters);
        if (WfUtils.isEmptyForCollection(iEntities)) {
            return result;
        }
        for (IdentityLinkEntity iEntity : iEntities) {
            result.add(iEntity.getUserId());
        }
        return result;
    }

    private FlowElement getFlowElementByTask(TaskEntity taskEntity, CommandContext commandContext) {
        if (taskEntity == null) {
            return null;
        }
        long procDefId = taskEntity.getProcessDefinitionId();
        long procInstId = taskEntity.getProcessInstanceId();
        String activityId = taskEntity.getTaskDefinitionKey();
        BpmnModel bpmnModel = new GetBpmnModelCmd(procDefId, procInstId).execute(commandContext);
        if (bpmnModel == null) {
            return null;
        }
        return bpmnModel.getFlowElement(activityId);
    }
}

