/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bizflow.util.BizFlowUtil;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;

public class GetBillExecutionInBizFlowCmd
implements Command<List<ExecutionEntity>>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Long processInstanceId;

    public GetBillExecutionInBizFlowCmd(Long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @Override
    public List<ExecutionEntity> execute(CommandContext commandContext) {
        ExecutionEntity executionEntity = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(this.processInstanceId);
        if (executionEntity == null) {
            return new ArrayList<ExecutionEntity>(0);
        }
        QFilter q1 = new QFilter("biztraceno", "=", (Object)executionEntity.getBizTraceNo());
        QFilter q2 = new QFilter("active", "=", (Object)Character.valueOf('1'));
        QFilter q3 = new QFilter("scope", "!=", (Object)Character.valueOf('1'));
        QFilter q4 = new QFilter("processtype", "=", (Object)ModelType.BizFlow.name());
        List execs = commandContext.getExecutionEntityManager().findByQueryFilters(new QFilter[]{q1, q2, q3, q4});
        ArrayList<ExecutionEntity> ret = new ArrayList<ExecutionEntity>(execs == null ? 0 : execs.size());
        if (execs != null && !execs.isEmpty()) {
            for (ExecutionEntity exec : execs) {
                ExecutionEntity tmp = BizFlowUtil.findBillExecution(exec);
                if (tmp == null || ret.contains(tmp)) continue;
                ret.add(tmp);
            }
        }
        return ret;
    }
}

