/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.workflow.bpmn.model.BillPageAttributeConfigModel;
import kd.bos.workflow.bpmn.model.BillPageAttributeConfigModelDetail;
import kd.bos.workflow.bpmn.model.BillPageAttributeConfigModelDetailFieldInfo;
import kd.bos.workflow.bpmn.model.BillSetting;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.dynprocess.billpage.BillPageAttributeConfig;
import kd.bos.workflow.engine.dynprocess.billpage.BillPageAttributeConfigDetail;
import kd.bos.workflow.engine.dynprocess.billpage.BillPageAttributeConfigDetailFieldInfo;
import kd.bos.workflow.engine.impl.cmd.GetBpmnModelCmd;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.BillPageAttributeConfigEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.exception.WFException;

public class GetBillPageAttributeConfigCmd
implements Command<BillPageAttributeConfig>,
Serializable {
    private static final long serialVersionUID = 4784475301027144897L;
    private static final String PC = "pc";
    private Long taskId;
    private String type;

    public GetBillPageAttributeConfigCmd(Long taskId, String type) {
        this.taskId = taskId;
        this.type = type;
    }

    @Override
    public BillPageAttributeConfig execute(CommandContext commandContext) {
        UserTask userTask;
        BillSetting billSetting;
        BillPageAttributeConfig result = new BillPageAttributeConfig();
        TaskEntity taskEntity = (TaskEntity)commandContext.getTaskEntityManager().findById(this.taskId);
        if (taskEntity == null) {
            return result;
        }
        BpmnModel bpmnModel = new GetBpmnModelCmd(taskEntity.getProcessDefinitionId(), taskEntity.getProcessInstanceId()).execute(commandContext);
        FlowElement flowElement = bpmnModel.getFlowElement(taskEntity.getTaskDefinitionKey());
        if (flowElement instanceof UserTask && (billSetting = (userTask = (UserTask)flowElement).getBillSetting()) != null) {
            this.getAuditHideAndDisplayBtnAttrs(billSetting, result);
        }
        return result;
    }

    private void getAuditHideAndDisplayBtnAttrs(BillSetting billSetting, BillPageAttributeConfig result) {
        List<BillPageAttributeConfigEntity> pageAttrConfigs = null;
        pageAttrConfigs = PC.equals(this.type) ? billSetting.getPageAttrConfig() : billSetting.getMobilePageAttrConfig();
        if (pageAttrConfigs != null) {
            throw new WFException(ResManager.loadKDString((String)"\u65e7\u7248\u7ed3\u6784\uff0c\u8bf7\u8fdb\u5165\u5de5\u4f5c\u6d41\u8bbe\u8ba1\u5668\u91cd\u65b0\u4fdd\u5b58\u4e0b\u3002", (String)"GetBillPageAttributeConfigCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        BillPageAttributeConfigModel newConfigs = null;
        newConfigs = PC.equals(this.type) ? billSetting.getPageAttrConfigModel() : billSetting.getMobilePageAttrConfigModel();
        this.putResultsNew(result, newConfigs);
    }

    private void putResultsNew(BillPageAttributeConfig result, BillPageAttributeConfigModel configModel) {
        BillPageAttributeConfigModelDetail btnConfigs;
        if (configModel == null) {
            return;
        }
        BillPageAttributeConfigModelDetail fieldConfigs = configModel.getField();
        if (WfUtils.isNotNullObject(fieldConfigs)) {
            BillPageAttributeConfigDetail fieldDetail = new BillPageAttributeConfigDetail();
            fieldDetail.setHide(this.packageBillPageAttributeConfigDetail(fieldConfigs.getHide()));
            fieldDetail.setModify(this.packageBillPageAttributeConfigDetail(fieldConfigs.getModify()));
            fieldDetail.setMustinput(this.packageBillPageAttributeConfigDetail(fieldConfigs.getMustinput()));
            result.setField(fieldDetail);
        }
        if (WfUtils.isNotNullObject(btnConfigs = configModel.getBtn())) {
            BillPageAttributeConfigDetail btnField = new BillPageAttributeConfigDetail();
            btnField.setDisplay(this.packageBillPageAttributeConfigDetail(btnConfigs.getDisplay()));
            btnField.setHide(this.packageBillPageAttributeConfigDetail(btnConfigs.getHide()));
            result.setBtn(btnField);
        }
    }

    private List<BillPageAttributeConfigDetailFieldInfo> packageBillPageAttributeConfigDetail(BillPageAttributeConfigModelDetailFieldInfo configs) {
        if (configs == null) {
            return Collections.emptyList();
        }
        String fieldNumbers = configs.getFieldnumber();
        if (WfUtils.isEmpty(fieldNumbers)) {
            return Collections.emptyList();
        }
        String[] numbers = fieldNumbers.split(",");
        String[] fieldNames = configs.getFieldname().split(",");
        ArrayList<BillPageAttributeConfigDetailFieldInfo> detailFieldInfoList = new ArrayList<BillPageAttributeConfigDetailFieldInfo>(numbers.length);
        for (int i = 0; i < numbers.length; ++i) {
            BillPageAttributeConfigDetailFieldInfo detailFieldInfo = new BillPageAttributeConfigDetailFieldInfo();
            detailFieldInfo.setFieldnumber(numbers[i]);
            detailFieldInfo.setFieldname(fieldNames[i]);
            detailFieldInfoList.add(detailFieldInfo);
        }
        return detailFieldInfoList;
    }
}

