/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;

public class GetBizIdentifyKeyByEntityNumberCmd
implements Command<Collection<Map<String, String>>> {
    private String entityNumber;

    public GetBizIdentifyKeyByEntityNumberCmd(String entityNumber) {
        this.entityNumber = entityNumber;
    }

    @Override
    public Collection<Map<String, String>> execute(CommandContext commandContext) {
        StringBuilder sql = new StringBuilder("SELECT ").append("b.FCONTENT content ").append("FROM ").append("t_wf_procdef a ").append("LEFT JOIN t_wf_gebytearray b ON a.FRESOURCEID = b.FID ").append("WHERE ").append("a.FENTRABILL = ? ").append("AND a.FENABLE = 'enable'");
        try (DataSet ds = DB.queryDataSet((String)"wf.wf_task.GetBizIdentifyKeyByEntityNumber", (DBRoute)DBRoute.workflow, (String)sql.toString(), (Object[])new Object[]{this.entityNumber});){
            Iterator iter = ds.iterator();
            HashMap bizIdentifyKeys = new HashMap();
            while (iter.hasNext()) {
                Row r = (Row)iter.next();
                String modelJson = r.getString("content");
                BpmnModel model = ProcessDefinitionUtil.getBpmnModel(modelJson);
                List<FlowElement> elements = model.getMainProcess().getFlowElementList();
                for (FlowElement e : elements) {
                    UserTask userTask;
                    String bizKey;
                    if (!(e instanceof UserTask) || !WfUtils.isNotEmpty(bizKey = (userTask = (UserTask)e).getBizIdentifyKey()) || bizIdentifyKeys.get(bizKey) != null) continue;
                    HashMap<String, String> bkey = new HashMap<String, String>();
                    bkey.put("bizIdentifyKey", bizKey);
                    bkey.put("activityName", userTask.getName());
                    bizIdentifyKeys.put(bizKey, bkey);
                }
            }
            Collection<Map<String, String>> collection = bizIdentifyKeys.values();
            return collection;
        }
    }
}

