/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.converter.util.CollectionUtils;
import kd.bos.workflow.bpmn.converter.util.ModelConfigUtil;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.DecisionOption;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.bpmn.model.StartEvent;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.extitf.ExtItfCallerType;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;
import kd.bos.workflow.engine.impl.cmd.procinst.CalculateProcInstCycleCmd;
import kd.bos.workflow.engine.impl.cmd.task.GetCommentForPrintCmd;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;

public class GetCommentForPrintByTypeCmd
implements Command<Collection<Map<String, String>>> {
    private Log logger = LogFactory.getLog(this.getClass());
    private static final String INCLUDEUSERTASK = "includeUserTask";
    private static final String INCLUDESSCIMAGEUPLOAD = "includeSSCImageUpload";
    private static final String INCLUDECALLACTIVITY = "includeCallActivity";
    private static final String ORDER = "order";
    private static final String ACTIVITYID = "activityId";
    private static final String ENTITYNUMBER = "entityNumber";
    private static final String PRINT_TYPE_ALL_CONTAINHICOMMENT = "allContainHiComment";
    private String businessKey;
    private String type;
    private String order;
    private Boolean includeUserTask = Boolean.TRUE;
    private Boolean includeSSCImageUpload = Boolean.TRUE;
    private Boolean includeCallActivity = Boolean.TRUE;
    private String entityNumber;

    public GetCommentForPrintByTypeCmd(String businessKey, String type) {
        this.businessKey = businessKey;
        this.type = type;
    }

    public GetCommentForPrintByTypeCmd(String businessKey, String type, Map<String, Object> printParam) {
        this.businessKey = businessKey;
        this.type = type;
        if (printParam != null) {
            this.order = (String)printParam.get(ORDER);
            String string = this.entityNumber = printParam.get(ENTITYNUMBER) == null || printParam.get(ENTITYNUMBER) == "" ? "" : (String)printParam.get(ENTITYNUMBER);
            if (printParam.get(INCLUDEUSERTASK) != null) {
                this.includeUserTask = (Boolean)printParam.get(INCLUDEUSERTASK);
            }
            if (printParam.get(INCLUDESSCIMAGEUPLOAD) != null) {
                this.includeSSCImageUpload = (Boolean)printParam.get(INCLUDESSCIMAGEUPLOAD);
            }
            if (printParam.get(INCLUDECALLACTIVITY) != null) {
                this.includeCallActivity = (Boolean)printParam.get(INCLUDECALLACTIVITY);
            }
            this.logger.debug(String.format("\u3010print-comment-param\u3011 businessKey is [%s],type is [%s],printParam is [%s]", businessKey, type, WfUtils.mapToString(printParam)));
        }
    }

    @Override
    public Collection<Map<String, String>> execute(CommandContext commandContext) {
        Collection<Map<String, String>> comments = new ArrayList<Map<String, String>>();
        switch (this.type) {
            case "all": {
                comments = this.getAllComments(commandContext);
                break;
            }
            case "allConsent": {
                comments = this.getAllConsentComments(commandContext);
                break;
            }
            case "lastedConsent": {
                comments = this.getLastestConsentComments(commandContext);
                break;
            }
            case "allContainHiComment": {
                comments = this.getAllContainHiComment();
                break;
            }
        }
        return this.getFormatTrdRecord(comments);
    }

    private Collection<Map<String, String>> getFormatTrdRecord(Collection<Map<String, String>> comments) {
        boolean isContainSSCApprove = Boolean.FALSE;
        if (CollectionUtils.isNotEmpty(comments)) {
            for (Map<String, String> comment : comments) {
                String elementType = comment.get("elementType");
                if (!"SSCApprove".equals(elementType)) continue;
                isContainSSCApprove = Boolean.TRUE;
                break;
            }
        }
        if (isContainSSCApprove) {
            try {
                String trdPrintRecordFormatter = ModelConfigUtil.getModelConfigFormatter("SSCApprove", "trdPrintRecordFormatter");
                if (WfUtils.isNotEmpty(trdPrintRecordFormatter)) {
                    return (Collection)ExternalInterfaceUtil.executeExtItf(ExtItfCallerType.TRDPRINTFORMATRECORDS, trdPrintRecordFormatter, comments);
                }
            }
            catch (KDException e2) {
                this.logger.info(e2.getStackTraceMessage());
            }
        }
        return comments;
    }

    public Collection<Map<String, String>> getAllComments(CommandContext commandContext) {
        return this.getConsentComments("all");
    }

    public Collection<Map<String, String>> getAllConsentComments(CommandContext commandContext) {
        return this.getConsentComments("allConsent");
    }

    private List<Map<String, String>> getConsentComments(String printType) {
        List<Map<String, String>> consentComments = new ArrayList<Map<String, String>>();
        Boolean isDesc = Boolean.FALSE;
        if (this.order != null) {
            if ("desc".equals(this.order)) {
                isDesc = Boolean.TRUE;
            } else if ("default".equals(this.order) && "lastedConsent".equals(printType)) {
                isDesc = Boolean.TRUE;
            }
        } else if ("all".equals(printType)) {
            isDesc = Boolean.FALSE;
        } else if ("allConsent".equals(printType)) {
            isDesc = Boolean.FALSE;
        } else if ("lastedConsent".equals(printType)) {
            isDesc = Boolean.TRUE;
        }
        if ("all".equals(printType)) {
            consentComments = GetCommentForPrintCmd.getPrintCommentByType(this.businessKey, true, false, isDesc, this.includeUserTask, this.includeSSCImageUpload, this.includeCallActivity, this.entityNumber, false);
        } else if ("allConsent".equals(printType)) {
            consentComments = GetCommentForPrintCmd.getPrintCommentByType(this.businessKey, false, false, isDesc, this.includeUserTask, this.includeSSCImageUpload, this.includeCallActivity, this.entityNumber, false);
        } else if ("lastedConsent".equals(printType)) {
            consentComments = GetCommentForPrintCmd.getPrintCommentByType(this.businessKey, false, true, isDesc, this.includeUserTask, this.includeSSCImageUpload, this.includeCallActivity, this.entityNumber, false);
        }
        return consentComments;
    }

    public Collection<Map<String, String>> getLastestConsentComments(CommandContext commandContext) {
        List<ExecutionEntity> executions = commandContext.getExecutionEntityManager().findActiveExecutionsByBusinessKey(this.businessKey);
        ArrayList<Map<String, String>> lastestConsentComments = new ArrayList();
        if (!executions.isEmpty()) {
            HashSet<String> preNodeIds;
            HashSet<String> currentActIds;
            block11: {
                currentActIds = new HashSet<String>();
                for (ExecutionEntity e : executions) {
                    if (e.isScope() || !WfUtils.isNotEmpty(e.getCurrentActivityId())) continue;
                    currentActIds.add(e.getCurrentActivityId());
                }
                Process process = ProcessDefinitionUtil.getProcess(executions.get(0).getProcessDefinitionId(), executions.get(0).getProcessInstanceId());
                preNodeIds = new HashSet<String>();
                try {
                    List<HistoricProcessInstanceEntity> processInsts = commandContext.getHistoricProcessInstanceEntityManager().findLatestHistoricProcessInstanceByBusinessKeyWithSubPro(this.businessKey, this.includeCallActivity);
                    if (!CollectionUtils.isNotEmpty(processInsts)) break block11;
                    for (int i = 0; i < processInsts.size(); ++i) {
                        Object actInsts = new CalculateProcInstCycleCmd(processInsts.get(i).getId()).execute(commandContext);
                        if (actInsts.isEmpty()) continue;
                        Iterator iterator = actInsts.iterator();
                        while (iterator.hasNext()) {
                            HistoricActivityInstanceEntity j = (HistoricActivityInstanceEntity)iterator.next();
                            String executionType = j.getExecutionType();
                            String activityType = j.getActivityType();
                            if (("skip".equals(executionType) || "jump".equals(executionType)) && (activityType == null || !"UserTask".equalsIgnoreCase(activityType))) continue;
                            preNodeIds.add(j.getActivityId());
                        }
                    }
                }
                catch (Exception exe) {
                    for (String i : currentActIds) {
                        FlowNode node = (FlowNode)process.getFlowElement(i);
                        this.getPreNodes(node, preNodeIds, process);
                    }
                }
            }
            preNodeIds.removeAll(currentActIds);
            if (!preNodeIds.isEmpty()) {
                String preNodeIdsStr = preNodeIds.stream().collect(Collectors.joining(","));
                this.logger.debug("preNodeIdsStr:" + preNodeIdsStr);
                this.logger.debug("preNodeIds:" + preNodeIds.size());
                List<Map<String, String>> allConsetComments = this.getConsentComments("lastedConsent");
                if (allConsetComments != null && allConsetComments.size() > 0) {
                    for (Map<String, String> comments : allConsetComments) {
                        if (!WfUtils.isNotEmpty(comments.get(ACTIVITYID)) || !preNodeIds.contains(comments.get(ACTIVITYID))) continue;
                        lastestConsentComments.add(comments);
                    }
                }
            }
        } else {
            lastestConsentComments = this.getConsentComments("lastedConsent");
        }
        return lastestConsentComments;
    }

    public void getPreNodes(FlowNode node, Set<String> preNodeIds, Process process) {
        while (node != null && !(node instanceof StartEvent)) {
            if (preNodeIds.contains(node.getId())) {
                return;
            }
            preNodeIds.add(node.getId());
            for (SequenceFlow flow : node.getIncomingFlows()) {
                if (flow.isDynamic()) continue;
                boolean isRejectFlow = false;
                if (flow.getConditionalRule() != null && flow.getConditionalRule().getEntryentity() != null) {
                    block2: for (ConditionalEntity i : flow.getConditionalRule().getEntryentity()) {
                        String expression = i.getParamnumber();
                        if (!WfUtils.isNotEmpty(expression) || !expression.startsWith("proc.") || !expression.endsWith("AuditNumber") || !WfUtils.isNotEmpty(i.getValue())) continue;
                        String nodeId = expression.split("AuditNumber")[0];
                        nodeId = nodeId.split("\\.")[1];
                        AuditTask auditTask = (AuditTask)process.getFlowElement(nodeId);
                        List<DecisionOption> decisionOptions = auditTask.getDecisionOptions();
                        for (DecisionOption d : decisionOptions) {
                            if (!d.getNumber().equals(i.getValue()) || !d.getAuditType().equals("reject")) continue;
                            isRejectFlow = true;
                            continue block2;
                        }
                    }
                }
                if (isRejectFlow) continue;
                node = (FlowNode)flow.getSourceFlowElement();
                this.getPreNodes(node, preNodeIds, process);
            }
        }
    }

    private Collection<Map<String, String>> getAllContainHiComment() {
        this.logger.debug("get all comment contain history");
        Boolean isDesc = false;
        if (this.order != null && "desc".equals(this.order)) {
            isDesc = Boolean.TRUE;
        }
        List<Map<String, String>> allContainHiComment = GetCommentForPrintCmd.getPrintCommentByType(this.businessKey, true, false, isDesc, this.includeUserTask, this.includeSSCImageUpload, this.includeCallActivity, this.entityNumber, true);
        return allContainHiComment;
    }
}

