/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.Task;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.bpmn.model.YunzhijiaTask;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.task.TaskDelegateUtil;

public class GetCommentForPrintCmd
implements Command<List<Map<String, String>>>,
Serializable {
    private static final long serialVersionUID = 7010199708964686839L;
    private String businessKey;
    private static final String COMMENTID = "commentId";
    private static final String ASSIGNEE = "assignee";
    private static final String ACTIVITYNAME = "activityName";
    private static final String MESSAGE = "message";
    private static final String SIGNATURE = "signature";
    private static final String RESULTNAME = "resultName";
    private static final String ACTIVITYID = "activityId";
    private static final String TASKID = "taskId";
    private static final String GROUPID = "groupId";
    private static final String FTRUSTNAME = "ftrustname";
    private static final String ASSIGNORNAME = "assignorname";
    private static final String DELEGATE = "delegate";
    private static final String DECISIONTYPE = "decisionType";
    private static final String HICOMMENT = "T_WF_HICOMMENT";
    private static final String HICOMMENTMULTI = "T_WF_HICOMMENT_L";
    private static final String TRDHICOMMENT = "T_WF_TRDHICOMMENT";
    private static final String TRDHICOMMENTMULTI = "T_WF_TRDHICOMMENT_L";
    private static final String TIME = "time";
    private static final String PROCINSTID = "procinstId";
    private static final String PROINSTIDLOWER = "proinstid";
    private static final String SUPERPROCINSTID = "superProcInstId";
    private static final String USERNAMEFORMATTER = "userNameFormatter";
    private static final String BIZIDENTIFYKEY = "bizIdentifyKey";
    private static final String PRODEFID = "prodefid";
    private static final String PROCESS = "process";
    private static final String THROUGHRULE = "throughRule";
    private static final String OWNERID = "ownerId";
    private static final String COORDINATE = "coordinate";
    private static final String APPROVALTIME = "approvalTime";
    private static final String TRANSFER = "transfer";
    private static final String AUDITPROPNUMBER = "auditPropNumber";
    private static final String AUDITPROPNAME = "auditPropName";
    private static final String COMMENT = "comment";
    private static final String TYPE = "type";
    private static final String STEP = "step";
    public static final String ELEMENTTYPE = "elementType";
    private static final String SOURCESYSTEM = "sourcesystem";
    private static final Log logger = LogFactory.getLog(GetCommentForPrintCmd.class);

    public GetCommentForPrintCmd(String businessKey) {
        this.businessKey = businessKey;
    }

    @Override
    public List<Map<String, String>> execute(CommandContext commandContext) {
        return GetCommentForPrintCmd.getPrintCommentByType(this.businessKey, false, false);
    }

    public static String getPrintCommentSql(Boolean isDesc, String table, String multiTable, Map<Long, BpmnModel> results, String source) {
        String masterTableAlias = "a";
        String multiLangTableAlias = "b";
        String entityNumber = "wf_hicomment";
        String assigneeSQL = WfMultiLangUtils.getGeneralLangSQL(entityNumber, masterTableAlias, multiLangTableAlias, "FASSIGNEE", ASSIGNEE, ASSIGNEE);
        String activityNameSQL = WfMultiLangUtils.getGeneralLangSQL(entityNumber, masterTableAlias, multiLangTableAlias, "FACTIVITYNAME", ACTIVITYNAME, ACTIVITYNAME);
        String messageSQL = WfMultiLangUtils.getGeneralLangSQL(entityNumber, masterTableAlias, multiLangTableAlias, "FMESSAGE", MESSAGE, MESSAGE);
        String resultNameSQL = WfMultiLangUtils.getGeneralLangSQL(entityNumber, masterTableAlias, multiLangTableAlias, "FRESULTNAME", RESULTNAME, "resultname");
        String assignorNameSQL = WfMultiLangUtils.getGeneralLangSQL(entityNumber, masterTableAlias, multiLangTableAlias, FTRUSTNAME, ASSIGNORNAME, ASSIGNORNAME);
        String subActivitiNameSQL = WfMultiLangUtils.getGeneralLangSQL(entityNumber, masterTableAlias, multiLangTableAlias, "fsubactivityname", "subactivityname", "subactivityname");
        String sourceSystem = "";
        if ("thirdComment".equals(source)) {
            sourceSystem = "a.fsourcesystem sourcesystem, ";
        }
        String sql = "SELECT a.FID commentid,a.FPROCINSTID procinstid,a.FACTIVITYID activityId,a.FSTEP step, a.FTYPE type,a.FOWNERID ownerId," + sourceSystem + "a.FTASKID taskId, a.FGROUPID groupId, a.FTIME approvalTime, a.FRESULTNUMBER resultNumber, a.FBIZIDENTIFYKEY bizIdentifyKey, " + assigneeSQL + ", a.FDECISIONTYPE decisionType, a.fusernameformatter userNameFormatter, " + activityNameSQL + ", " + subActivitiNameSQL + ", " + messageSQL + ", a.fsignature signature, " + resultNameSQL + "," + assignorNameSQL + ",c.fsuperprocinstid superprocinstid FROM " + table + " a LEFT JOIN " + multiTable + " b ON a.FID = b.FID and b.flocaleid = ? LEFT JOIN t_wf_hiprocinst c ON a.fprocinstid = c.fid WHERE a.FBUSINESSKEY = ? and ftype != '" + "forceReject" + "'";
        if (results.size() > 0) {
            String procinstIdsSql = GetCommentForPrintCmd.getProcinstIdsSql(results);
            sql = sql + " and a.FPROCINSTID in (" + procinstIdsSql + ")";
        }
        sql = isDesc != false ? sql + " order by a.fstep DESC,a.FTIME desc" : sql + " order by a.FTIME asc ,a.fstep asc";
        return sql;
    }

    public static String getProcinstIdsSql(Map<Long, BpmnModel> results) {
        StringBuilder procinstIdsSql = new StringBuilder();
        Object[] resultKeySet = results.keySet().toArray();
        for (int i = 0; i < resultKeySet.length; ++i) {
            procinstIdsSql.append(resultKeySet[i]);
            if (i == resultKeySet.length - 1) break;
            procinstIdsSql.append(",");
        }
        return procinstIdsSql.toString();
    }

    public static List<Map<String, String>> getPrintComment(String businessKey, Map<Long, BpmnModel> results, boolean hasReject, boolean isLastConstant, Boolean isDesc, Boolean includeUserTask, Boolean includeSSCImageUpload, List<Map<String, String>> comments, SimpleDateFormat sdf, String table, String multiTable, String source) {
        String lang = RequestContext.get().getLang().toString();
        ArrayList<String> actIds = new ArrayList<String>();
        HashMap<Long, String> yzjIdGroup = new HashMap<Long, String>();
        HashMap<String, Integer> yzjActivityNum = new HashMap<String, Integer>();
        Object[] params = new Object[]{lang, businessKey};
        String sql = GetCommentForPrintCmd.getPrintCommentSql(isDesc, table, multiTable, results, source);
        try (DataSet ds = DB.queryDataSet((String)"wf_task.getCommnet", (DBRoute)DBRoute.workflow, (String)sql, (Object[])params);){
            Iterator iter = ds.iterator();
            ArrayList<Long> removeyzjPTaskId = new ArrayList<Long>();
            HashMap<Long, List<Map<String, String>>> yzjs = new HashMap<Long, List<Map<String, String>>>();
            String assignee = null;
            String userNameFormatter = null;
            while (iter.hasNext()) {
                Row r = (Row)iter.next();
                HashMap<String, String> c = new HashMap<String, String>();
                c.put(COMMENTID, r.getString(COMMENTID));
                assignee = r.getString(ASSIGNEE);
                Long processInstanceId = Long.valueOf(r.getString(PROCINSTID));
                Long ownerId = r.getLong(OWNERID);
                String assignorName = r.getString(ASSIGNORNAME);
                StringBuilder auditPropNumberSB = new StringBuilder();
                StringBuilder auditPropNameSB = new StringBuilder();
                if (!WfUtils.isEmpty(ownerId) && !WfUtils.isEmpty(assignorName)) {
                    assignee = TaskDelegateUtil.getDelegateAssigneeName(assignorName, assignee, "replace");
                    auditPropNumberSB.append(DELEGATE).append(",");
                    auditPropNameSB.append(ResManager.loadKDString((String)"\u59d4\u6258", (String)"GetCommentForPrintCmd_4", (String)"bos-wf-engine", (Object[])new Object[0])).append(",");
                }
                userNameFormatter = r.getString(USERNAMEFORMATTER);
                c.put(ASSIGNEE, assignee);
                String activityId = r.getString(ACTIVITYID);
                String activitiName = r.getString(ACTIVITYNAME);
                Task element = null;
                if (WfUtils.isNotEmpty(activityId) && WfUtils.isNotEmpty(processInstanceId) && results.get(processInstanceId) != null) {
                    String subActivityName;
                    element = results.get(processInstanceId).getMainProcess().findFlowElementsOfTypeAndId(Task.class, activityId, false);
                    if ("RPATask".equals(element.getType())) continue;
                    if ("SSCApprove".equals(element.getType()) && StringUtils.isNotBlank((CharSequence)(subActivityName = r.getString("subactivityname")))) {
                        activitiName = activitiName + '-' + subActivityName;
                    }
                    c.put(ELEMENTTYPE, element.getType());
                }
                c.put(TASKID, r.getString(TASKID));
                c.put("source", source);
                if ("thirdComment".equals(source)) {
                    c.put("SOURCESYSTEM", r.getString(SOURCESYSTEM));
                }
                c.put(ACTIVITYNAME, activitiName);
                c.put(ACTIVITYID, r.getString(ACTIVITYID));
                c.put(RESULTNAME, r.getString(RESULTNAME));
                String message = r.getString(MESSAGE);
                message = WfUtils.isEmpty(message) ? null : message.replace("<br>", "\r\n");
                c.put(MESSAGE, message);
                c.put(SIGNATURE, r.getString(SIGNATURE));
                c.put(STEP, r.getString(STEP));
                c.put(BIZIDENTIFYKEY, r.getString(BIZIDENTIFYKEY));
                c.put(TIME, sdf.format(r.getDate(APPROVALTIME)));
                c.put(USERNAMEFORMATTER, WfUtils.isEmpty(userNameFormatter) ? assignee : userNameFormatter);
                String type = r.getString(TYPE);
                if (COORDINATE.equals(type)) {
                    auditPropNumberSB.append(COORDINATE).append(',');
                    auditPropNameSB.append(WfConfigurationUtil.getCoordinateName()).append(',');
                }
                if (COMMENT.equals(type) && !WfUtils.isEmpty(ownerId) && WfUtils.isEmpty(assignorName)) {
                    auditPropNumberSB.append(TRANSFER).append(',');
                    auditPropNameSB.append(WfConfigurationUtil.getTransferName()).append(',');
                }
                String auditPropNumber = auditPropNumberSB.toString();
                String auditPropName = auditPropNameSB.toString();
                if (WfUtils.isNotEmpty(auditPropNumber) && WfUtils.isNotEmpty(auditPropName)) {
                    c.put(AUDITPROPNUMBER, auditPropNumber.substring(0, auditPropNumber.length() - 1));
                    c.put(AUDITPROPNAME, auditPropName.substring(0, auditPropName.length() - 1));
                }
                if (element != null && "YunzhijiaTask".equals(element.getType()) && WfUtils.isNotEmpty(processInstanceId)) {
                    if (isDesc.booleanValue()) {
                        GetCommentForPrintCmd.filterDescYzjComment(processInstanceId, hasReject, isLastConstant, comments, actIds, removeyzjPTaskId, yzjs, r, c, activityId, element);
                        continue;
                    }
                    GetCommentForPrintCmd.filterAscYzjComment(processInstanceId, hasReject, isLastConstant, comments, actIds, removeyzjPTaskId, yzjs, r, c, activityId, element, yzjIdGroup, yzjActivityNum);
                    continue;
                }
                if (element != null) {
                    String elementType = element.getType();
                    UserTask firstUserTask = BpmnModelUtil.getFirstUserTask(results.get(processInstanceId).getMainProcess());
                    if (firstUserTask != null) {
                        String string = firstUserTask.getNumber();
                        String currentElementNumber = element.getNumber();
                        if (!includeUserTask.booleanValue() && "UserTask".equals(elementType) || includeUserTask.booleanValue() && r.getLong("superprocinstid") != 0L && string.equals(currentElementNumber) || !includeSSCImageUpload.booleanValue() && ("SSCImageUpload".equals(elementType) || "SSCImageUploadNew".equals(elementType))) continue;
                    }
                }
                if (!hasReject && ("reject".equalsIgnoreCase(r.getString(DECISIONTYPE)) || "terminate".equalsIgnoreCase(r.getString(DECISIONTYPE)))) continue;
                if (isLastConstant) {
                    if ("thirdComment".equals(source)) {
                        boolean include = false;
                        for (Map map : comments) {
                            String taskId = r.getString(TASKID);
                            if (activityId == null || !activityId.equals(map.get(ACTIVITYID)) || taskId == null || !taskId.equals(map.get(TASKID))) continue;
                            include = true;
                            break;
                        }
                        if (!include) continue;
                        comments.add(c);
                        continue;
                    }
                    if (isDesc.booleanValue()) {
                        if (actIds.contains(activityId)) continue;
                        comments.add(c);
                        actIds.add(activityId);
                        continue;
                    }
                    for (Map<String, String> comment : comments) {
                        if (activityId == null || !activityId.equals(comment.get(ACTIVITYID))) continue;
                        comments.remove(comment);
                        break;
                    }
                    comments.add(c);
                    continue;
                }
                comments.add(c);
            }
            for (List l : yzjs.values()) {
                comments.addAll(l);
            }
            List<Map<String, String>> list = comments;
            return list;
        }
    }

    private static void filterAscYzjComment(Long proinstId, boolean hasReject, boolean isLastConstant, List<Map<String, String>> comments, List<String> actIds, List<Long> removeyzjPTaskId, Map<Long, List<Map<String, String>>> yzjs, Row r, Map<String, String> c, String activityId, Task element, Map<Long, String> yzjIdGroup, Map<String, Integer> yzjActivityNum) {
        if (r.getLong(TASKID).longValue() == r.getLong(GROUPID).longValue()) {
            if (isLastConstant && yzjActivityNum.get(activityId) != null && yzjActivityNum.get(activityId) > 1) {
                for (Map.Entry<Long, String> entry : yzjIdGroup.entrySet()) {
                    Long groupId = entry.getKey();
                    if (entry.getValue() == null || !entry.getValue().equals(activityId) || groupId == null || groupId.equals(r.getLong(GROUPID))) continue;
                    yzjs.remove(groupId);
                }
            }
        } else {
            c.put(THROUGHRULE, BpmnModelUtil.getYunzhijiaThroughRules((YunzhijiaTask)element, proinstId));
            if (yzjs.get(r.getLong(GROUPID)) == null) {
                ArrayList yzjcs = new ArrayList();
                yzjs.put(r.getLong(GROUPID), yzjcs);
                actIds.add(activityId);
                yzjIdGroup.put(r.getLong(GROUPID), activityId);
                int size = yzjActivityNum.get(activityId) == null ? 0 : yzjActivityNum.get(activityId);
                yzjActivityNum.put(activityId, ++size);
            }
            if (isLastConstant) {
                if (!"reject".equalsIgnoreCase(r.getString(DECISIONTYPE))) {
                    yzjs.get(r.getLong(GROUPID)).add(c);
                }
            } else if (hasReject || !"reject".equalsIgnoreCase(r.getString(DECISIONTYPE))) {
                yzjs.get(r.getLong(GROUPID)).add(c);
            }
        }
    }

    private static void filterDescYzjComment(Long proinstId, boolean hasReject, boolean isLastConstant, List<Map<String, String>> comments, List<String> actIds, List<Long> removeyzjPTaskId, Map<Long, List<Map<String, String>>> yzjs, Row r, Map<String, String> c, String activityId, Task element) {
        if (r.getLong(TASKID).longValue() == r.getLong(GROUPID).longValue()) {
            if (isLastConstant) {
                if (!"reject".equalsIgnoreCase(r.getString(DECISIONTYPE))) {
                    if (!actIds.contains(activityId)) {
                        ArrayList yzjcs = new ArrayList();
                        yzjs.put(r.getLong(GROUPID), yzjcs);
                        actIds.add(activityId);
                    } else {
                        removeyzjPTaskId.add(r.getLong(GROUPID));
                        yzjs.remove(r.getLong(GROUPID));
                    }
                } else {
                    removeyzjPTaskId.add(r.getLong(GROUPID));
                    yzjs.remove(r.getLong(GROUPID));
                }
            } else {
                if (yzjs.get(r.getLong(TASKID)) != null && (!"reject".equalsIgnoreCase(r.getString(DECISIONTYPE)) || hasReject)) {
                    comments.addAll((Collection<Map<String, String>>)yzjs.get(r.getLong(TASKID)));
                }
                yzjs.remove(r.getLong(TASKID));
            }
        } else {
            c.put(THROUGHRULE, BpmnModelUtil.getYunzhijiaThroughRules((YunzhijiaTask)element, proinstId));
            if (yzjs.get(r.getLong(GROUPID)) == null) {
                if (!isLastConstant) {
                    if (hasReject || !"reject".equalsIgnoreCase(r.getString(DECISIONTYPE))) {
                        ArrayList<Map<String, String>> yzjcs = new ArrayList<Map<String, String>>();
                        yzjcs.add(c);
                        yzjs.put(r.getLong(GROUPID), yzjcs);
                    }
                } else if (!removeyzjPTaskId.contains(r.getLong(GROUPID))) {
                    ArrayList<Map<String, String>> yzjcs = new ArrayList<Map<String, String>>();
                    yzjcs.add(c);
                    yzjs.put(r.getLong(GROUPID), yzjcs);
                    actIds.add(activityId);
                }
            } else if (hasReject || !"reject".equalsIgnoreCase(r.getString(DECISIONTYPE))) {
                yzjs.get(r.getLong(GROUPID)).add(c);
            }
        }
    }

    public static List<Map<String, String>> getPrintCommentByType(String businessKey, boolean hasReject, boolean isLastConstant, Boolean isDesc, Boolean includeUserTask, Boolean includeSSCImageUpload, Boolean includeSubPro, String entityNumber, Boolean isAllComments) {
        Boolean printTrdApprovalRecord;
        ArrayList<Map<String, String>> comments = new ArrayList<Map<String, String>>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Map<Long, BpmnModel> results = GetCommentForPrintCmd.getProcess(businessKey, includeSubPro, entityNumber, isAllComments);
        if (results.size() > 0) {
            GetCommentForPrintCmd.getPrintComment(businessKey, results, hasReject, isLastConstant, isDesc, includeUserTask, includeSSCImageUpload, comments, sdf, HICOMMENT, HICOMMENTMULTI, COMMENT);
        }
        if ((printTrdApprovalRecord = Boolean.valueOf(WfConfigurationUtil.printTrdApprovalRecord())).booleanValue()) {
            GetCommentForPrintCmd.getPrintComment(businessKey, results, hasReject, isLastConstant, isDesc, includeUserTask, includeSSCImageUpload, comments, sdf, TRDHICOMMENT, TRDHICOMMENTMULTI, "thirdComment");
        }
        if (isDesc.booleanValue()) {
            GetCommentForPrintCmd.sortComment(comments, sdf, "desc");
        } else {
            GetCommentForPrintCmd.sortComment(comments, sdf, "asc");
        }
        return comments;
    }

    @Deprecated
    public static List<Map<String, String>> getPrintCommentByType(String businessKey, boolean hasReject, boolean isLastConstant, Boolean isDesc, Boolean includeUserTask, Boolean includeSSCImageUpload, Boolean includeSubPro) {
        Boolean printTrdApprovalRecord;
        ArrayList<Map<String, String>> comments = new ArrayList<Map<String, String>>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Map<Long, BpmnModel> results = GetCommentForPrintCmd.getProcess(businessKey, includeSubPro, null, false);
        if (results.size() > 0) {
            GetCommentForPrintCmd.getPrintComment(businessKey, results, hasReject, isLastConstant, isDesc, includeUserTask, includeSSCImageUpload, comments, sdf, HICOMMENT, HICOMMENTMULTI, COMMENT);
        }
        if ((printTrdApprovalRecord = Boolean.valueOf(WfConfigurationUtil.printTrdApprovalRecord())).booleanValue()) {
            GetCommentForPrintCmd.getPrintComment(businessKey, results, hasReject, isLastConstant, isDesc, includeUserTask, includeSSCImageUpload, comments, sdf, TRDHICOMMENT, TRDHICOMMENTMULTI, "thirdComment");
        }
        if (isDesc.booleanValue()) {
            GetCommentForPrintCmd.sortComment(comments, sdf, "desc");
        } else {
            GetCommentForPrintCmd.sortComment(comments, sdf, "asc");
        }
        return comments;
    }

    private static int compareWithFiled(String order, int descValue, int otherValue) {
        if ("desc".equals(order)) {
            return descValue;
        }
        return otherValue;
    }

    private static void sortComment(List<Map<String, String>> comments, final SimpleDateFormat sdf, final String order) {
        comments.sort(new Comparator<Map<String, String>>(){
            private Log logger = LogFactory.getLog(this.getClass());

            @Override
            public int compare(Map<String, String> o1, Map<String, String> o2) {
                try {
                    long o1Time = sdf.parse(o1.get(GetCommentForPrintCmd.TIME)).getTime();
                    long o2Time = sdf.parse(o2.get(GetCommentForPrintCmd.TIME)).getTime();
                    if (o1Time > o2Time) {
                        return GetCommentForPrintCmd.compareWithFiled(order, -1, 1);
                    }
                    if (o1Time == o2Time) {
                        Integer o1Step = Integer.valueOf(o1.get(GetCommentForPrintCmd.STEP));
                        Integer o2Step = Integer.valueOf(o2.get(GetCommentForPrintCmd.STEP));
                        if (o1Step > o2Step) {
                            return GetCommentForPrintCmd.compareWithFiled(order, -1, 1);
                        }
                        return GetCommentForPrintCmd.compareWithFiled(order, 1, -1);
                    }
                    return GetCommentForPrintCmd.compareWithFiled(order, 1, -1);
                }
                catch (ParseException e) {
                    this.logger.error(WfUtils.getExceptionStacktrace(e));
                    return 0;
                }
            }
        });
    }

    public static List<Map<String, String>> getPrintCommentByType(String businessKey, boolean hasReject, boolean order) {
        return GetCommentForPrintCmd.getPrintCommentByType(businessKey, hasReject, order, Boolean.FALSE, Boolean.FALSE, Boolean.TRUE, Boolean.FALSE, "", Boolean.FALSE);
    }

    public static Map<Long, BpmnModel> getProcess(String businessKey, Boolean includeSubPro, String entityNumber, Boolean isAllComments) {
        logger.debug(String.format("\u3010get-process-instance\u3011 [%s],[%s],[%s],[%s]", businessKey, includeSubPro, entityNumber, isAllComments));
        HashMap<Long, BpmnModel> result = new HashMap<Long, BpmnModel>();
        if (WfUtils.isNotEmpty(businessKey)) {
            ArrayList<String> paramsList = new ArrayList<String>(8);
            StringBuilder sql = new StringBuilder("select a.FPROCINSTID proinstid,a.FPROCDEFID prodefid,a.FSUPERPROCINSTID superprocinstid,a.fprocesstype processtype from t_wf_hiprocinst a ");
            sql.append(" where a.FBUSINESSKEY = ? ");
            paramsList.add(businessKey);
            if (isAllComments.booleanValue() && WfUtils.isNotEmpty(entityNumber)) {
                sql.append("   and a.fentitynumber=?  ");
                paramsList.add(entityNumber);
            } else {
                sql.append("  and a.fendtype<> ? ");
                paramsList.add("20");
                if (WfUtils.isNotEmpty(entityNumber)) {
                    sql.append(" and a.fentitynumber=?  ");
                    paramsList.add(entityNumber);
                }
            }
            sql.append(" order by a.fcreatedate desc");
            LinkedHashMap<Long, DynamicObject> hiProIns = new LinkedHashMap<Long, DynamicObject>();
            try (DataSet ds = DB.queryDataSet((String)"ApprovalRecord.t_wf_execution.queryExecutionInfo", (DBRoute)DBRoute.workflow, (String)sql.toString(), (Object[])paramsList.toArray());){
                DynamicObjectCollection dynamicObjects = ORM.create().toPlainDynamicObjectCollection(ds);
                if (dynamicObjects == null) {
                    HashMap<Long, BpmnModel> hashMap = result;
                    return hashMap;
                }
                for (DynamicObject dyn : dynamicObjects) {
                    hiProIns.put(dyn.getLong(PROINSTIDLOWER), dyn);
                }
            }
            for (Map.Entry entry : hiProIns.entrySet()) {
                BpmnModel bpmnModel;
                DynamicObject dynamicObject = (DynamicObject)entry.getValue();
                String processType = dynamicObject.getString("processtype");
                if ("BizFlow".equals(processType)) continue;
                Long procinstDefId = dynamicObject.getLong(PRODEFID);
                Long procinstId = dynamicObject.getLong(PROINSTIDLOWER);
                Long superProcessInsId = dynamicObject.getLong("superprocinstid");
                if (includeSubPro.booleanValue()) {
                    bpmnModel = ProcessDefinitionUtil.getBpmnModel(procinstDefId, procinstId);
                    result.put(procinstId, bpmnModel);
                    if (isAllComments.booleanValue() && superProcessInsId == 0L || superProcessInsId != 0L) continue;
                    break;
                }
                if (superProcessInsId == 0L) {
                    bpmnModel = ProcessDefinitionUtil.getBpmnModel(procinstDefId, procinstId);
                    result.put(procinstId, bpmnModel);
                    if (!isAllComments.booleanValue()) break;
                    continue;
                }
                if (hiProIns.get(superProcessInsId) == null || !"BizFlow".equals(((DynamicObject)hiProIns.get(superProcessInsId)).getString("processtype"))) continue;
                bpmnModel = ProcessDefinitionUtil.getBpmnModel(procinstDefId, procinstId);
                result.put(procinstId, bpmnModel);
            }
        }
        return result;
    }

    @Deprecated
    private static boolean ignoreCoordinateRecordForSpecialScene(Task element, Long procInstId, Iterator<Row> iter) {
        boolean flag = false;
        ArrayList tempDataList = new ArrayList(2);
        try {
            while (iter.hasNext()) {
                Row r = iter.next();
                if (element == null || !"YunzhijiaTask".equals(element.getType()) || !WfUtils.isNotEmpty(procInstId)) continue;
                HashMap<String, Object> map = new HashMap<String, Object>(12);
                map.put(STEP, r.getString(STEP));
                map.put(ACTIVITYNAME, r.getString(ACTIVITYNAME));
                map.put(ACTIVITYID, r.getString(ACTIVITYID));
                map.put(BIZIDENTIFYKEY, r.getString(BIZIDENTIFYKEY));
                map.put(OWNERID, r.getLong(OWNERID));
                map.put(TASKID, r.getLong(TASKID));
                map.put(COMMENTID, r.getString(COMMENTID));
                map.put(ASSIGNEE, r.getString(ASSIGNEE));
                map.put(RESULTNAME, r.getString(RESULTNAME));
                map.put(TYPE, r.getString(TYPE));
                map.put(GROUPID, r.get(GROUPID));
                map.put(DECISIONTYPE, r.getString(DECISIONTYPE));
                tempDataList.add(map);
            }
            String requestOwner = "";
            String requestAssignee = "";
            String rejectAssignee = "";
            String allAssignee = "";
            if (tempDataList.size() > 0) {
                for (Map map : tempDataList) {
                    String type = String.valueOf(map.get(TYPE));
                    Long taskId = Long.parseLong(String.valueOf(map.get(TASKID)));
                    Long groupId = map.get(GROUPID) == null || map.get(GROUPID) == "" ? 0L : Long.parseLong(String.valueOf(map.get(GROUPID)));
                    if (COORDINATE.equals(type) && Long.parseLong(String.valueOf(map.get(OWNERID))) != 0L) {
                        Long requestOwenId = Long.parseLong(String.valueOf(map.get(OWNERID)));
                        requestOwner = GetCommentForPrintCmd.getOwnerName(requestOwenId);
                        requestAssignee = (String)map.get(ASSIGNEE);
                    }
                    if (!"reject".equalsIgnoreCase(String.valueOf(map.get(DECISIONTYPE)))) continue;
                    if (groupId.longValue() == taskId.longValue()) {
                        allAssignee = (String)map.get(ASSIGNEE);
                        continue;
                    }
                    rejectAssignee = (String)map.get(ASSIGNEE);
                }
            }
            if (WfUtils.isNotEmpty(allAssignee) && !allAssignee.contains(requestOwner) && WfUtils.isNotEmpty(rejectAssignee) && !rejectAssignee.contains(requestAssignee)) {
                flag = true;
            }
        }
        catch (Exception e) {
            logger.error("invoke method ignoreCoordinateRecordForSpecialScene occurred exception:" + WfUtils.getExceptionStacktrace(e));
        }
        return flag;
    }

    @Deprecated
    private static String getOwnerName(Long owenId) {
        String owner = "";
        StringBuilder sql = new StringBuilder(" select ftruename  from  t_sec_user_l  where fid= ").append(owenId);
        sql.append(" and  flocaleid=").append("'").append(RequestContext.get().getLang().name()).append("'");
        try (DataSet ds = DB.queryDataSet((String)"wf_task.getIsRequestCoordinate", (DBRoute)DBRoute.basedata, (String)sql.toString(), null);){
            Iterator iter = ds.iterator();
            if (iter.hasNext()) {
                owner = ((Row)iter.next()).getString("ftruename");
            }
        }
        return owner;
    }
}

