/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntity;

public class GetCoordinateCommentsCmd
implements Command<List<CommentEntity>>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Date endDate;
    private Date startDate;
    private String orderBy;
    private int limitSize;
    private boolean hasBillno = true;

    public GetCoordinateCommentsCmd(Date startTime, Date endTime, String orderby, int limitSize, boolean hasBillno) {
        this.startDate = startTime;
        this.endDate = endTime;
        this.orderBy = orderby;
        this.limitSize = limitSize;
        this.hasBillno = hasBillno;
    }

    @Override
    public List<CommentEntity> execute(CommandContext commandContext) {
        if (this.endDate == null || this.startDate == null) {
            return new ArrayList<CommentEntity>();
        }
        EntityQueryBuilder eqb = commandContext.getCommentEntityManager().createQueryBuilder();
        eqb.addFilter("time", "<=", this.endDate);
        eqb.addFilter("time", ">=", this.startDate);
        eqb.addFilter("type", "=", "coordinate");
        eqb.addFilter("taskid", "!=", 0L);
        if (this.hasBillno) {
            eqb.addFilter("billno", "is null", null);
        }
        if (WfUtils.isNotEmpty(this.orderBy)) {
            eqb.orderBy(this.orderBy);
        }
        if (this.limitSize != 0) {
            eqb.setLimit(this.limitSize);
        }
        return commandContext.getCommentEntityManager().findByQueryBuilder(eqb);
    }
}

