/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.task.FeedbackEntity;

public class GetFeedbackInfosByProcessInstanceIdCmd
implements Command<List<Map<String, Object>>>,
Serializable {
    private static final long serialVersionUID = -1177564029400475819L;
    private String processInstanceId;

    public GetFeedbackInfosByProcessInstanceIdCmd(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @Override
    public List<Map<String, Object>> execute(CommandContext commandContext) {
        List<Map<String, Object>> feedbackInfos = new ArrayList<Map<String, Object>>();
        List<FeedbackEntity> feedbacks = commandContext.getFeedbackEntityManager().findFeedbacksByProcessInstanceId(this.processInstanceId);
        if (null != feedbacks && 0 != feedbacks.size()) {
            ArrayList<Long> userIds = null;
            if (WfUtils.isNotEmptyForCollection(feedbacks)) {
                userIds = new ArrayList(feedbacks.size());
                for (FeedbackEntity entity : feedbacks) {
                    userIds.add(entity.getCreatorId());
                }
            } else {
                userIds = new ArrayList<Long>(1);
            }
            List userInfos = UserServiceHelper.get(userIds);
            feedbackInfos = this.getFeedbackInfos(feedbacks, userInfos);
        }
        return feedbackInfos;
    }

    private List<Map<String, Object>> getFeedbackInfos(List<FeedbackEntity> feedbacks, List<Map<String, Object>> userInfos) {
        ArrayList<Map<String, Object>> feedbackInfos = null;
        if (WfUtils.isNotEmptyForCollection(feedbacks)) {
            feedbackInfos = new ArrayList(feedbacks.size());
            HashMap<String, Object> feedbackInfo = null;
            Long userId = null;
            String userName = null;
            String userAvatar = null;
            for (FeedbackEntity entity : feedbacks) {
                userId = entity.getCreatorId();
                for (Map<String, Object> map : userInfos) {
                    userName = null;
                    userAvatar = null;
                    if (!userId.equals(map.get("id"))) continue;
                    userName = ((ILocaleString)map.get("name")).toString();
                    userAvatar = WfUtils.getAbsAvatarPath(map.get("picturefield"));
                    break;
                }
                feedbackInfo = new HashMap<String, Object>();
                feedbackInfo.put("avatar", userAvatar);
                feedbackInfo.put("username", userName);
                feedbackInfo.put("feedbackmsg", entity.getFeedbackMsg());
                feedbackInfo.put("createdate", entity.getCreateDate());
                feedbackInfo.put("id", entity.getId());
                feedbackInfo.put("creatorid", userId);
                feedbackInfos.add(feedbackInfo);
            }
        } else {
            feedbackInfos = new ArrayList<Map<String, Object>>(1);
        }
        return feedbackInfos;
    }
}

