/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.io.Serializable;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFIllegalArgumentException;

public class GetIdentityLinksByParentTaskIdCmd
implements Command<List<IdentityLinkEntity>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected Long parentTaskId;

    public GetIdentityLinksByParentTaskIdCmd(Long parentTaskId) {
        if (parentTaskId == null) {
            throw new WFIllegalArgumentException("parentTaskId is required");
        }
        this.parentTaskId = parentTaskId;
    }

    @Override
    public List<IdentityLinkEntity> execute(CommandContext commandContext) {
        List<TaskEntity> tasks = commandContext.getTaskEntityManager().findTasksByParentTaskId(this.parentTaskId);
        if (tasks == null || tasks.isEmpty()) {
            throw new KDException(WFErrorCode.illegAlargumentException(), new Object[]{String.format(ResManager.loadKDString((String)"\u672a\u80fd\u627e\u5230\u7236\u4efb\u52a1\u4e3a\u201c%1$s\u201d\u7684\u5b50\u4efb\u52a1\u3002", (String)"GetIdentityLinksByParentTaskIdCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]), this.parentTaskId)});
        }
        Long[] taskIds = new Long[tasks.size()];
        for (int i = 0; i < tasks.size(); ++i) {
            taskIds[i] = tasks.get(i).getId();
        }
        IdentityLinkEntityManager identityLinkEntityManager = Context.getProcessEngineConfiguration().getIdentityLinkEntityManager();
        List<IdentityLinkEntity> identityLinks = identityLinkEntityManager.findIdentityLinksByTaskIds(taskIds);
        return identityLinks;
    }
}

