/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.task.Comment;

public class GetLastNodesCommentsByBusinesskeyCmd
implements Command<List<Comment>>,
Serializable {
    private static final long serialVersionUID = 4450198647946942993L;
    private String businessKey;

    public GetLastNodesCommentsByBusinesskeyCmd(String businessKey) {
        this.businessKey = businessKey;
    }

    @Override
    public List<Comment> execute(CommandContext commandContext) {
        ArrayList<CommentEntity> comments = new ArrayList<CommentEntity>();
        EntityQueryBuilder eb = commandContext.getTaskEntityManager().createQueryBuilder();
        eb.addFilter("businessKey", this.businessKey);
        List taskEntitys = commandContext.getTaskEntityManager().findByQueryBuilder(eb);
        HistoricActivityInstanceEntityManager hisActivityManager = commandContext.getHistoricActivityInstanceEntityManager();
        CommentEntityManager commentMgr = commandContext.getCommentEntityManager();
        for (TaskEntity taskEntity : taskEntitys) {
            HistoricActivityInstanceEntity currActInst = hisActivityManager.findActivityByTaskId(taskEntity.getId());
            List<HistoricActivityInstanceEntity> hiActInstList = GetLastNodesCommentsByBusinesskeyCmd.getHistoricActivitysByCurActInstId(commandContext, currActInst.getId());
            for (HistoricActivityInstanceEntity hiActInst : hiActInstList) {
                if (hiActInst.getActivityType().equals("YunzhijiaTask")) {
                    comments.addAll(commentMgr.findCommentsByTaskId(hiActInst.getParentTaskId()));
                    continue;
                }
                comments.addAll(commentMgr.findCommentsByTaskId(hiActInst.getTaskId()));
            }
        }
        TreeSet<CommentEntity> set = new TreeSet<CommentEntity>((entity1, entity2) -> entity1.getId().compareTo(entity2.getId()));
        set.addAll(comments);
        return new ArrayList<Comment>(set);
    }

    public static List<HistoricActivityInstanceEntity> getHistoricActivitysByCurActInstId(CommandContext commandContext, Long currentActInstId) {
        HistoricActivityInstanceEntity curHisActInst;
        ArrayList<HistoricActivityInstanceEntity> hiActInstList = new ArrayList<HistoricActivityInstanceEntity>();
        HistoricActivityInstanceEntityManager hisActivityManager = commandContext.getHistoricActivityInstanceEntityManager();
        List<HistoricActivityInstanceEntity> seqNodes = hisActivityManager.findByTargetId((curHisActInst = (HistoricActivityInstanceEntity)hisActivityManager.findById(currentActInstId)).getProcessInstanceId(), curHisActInst.getId());
        if (seqNodes == null || seqNodes.isEmpty()) {
            return hiActInstList;
        }
        block12: for (HistoricActivityInstanceEntity seqInst : seqNodes) {
            List<HistoricActivityInstanceEntity> preNodes = hisActivityManager.findByTargetId(curHisActInst.getProcessInstanceId(), seqInst.getId());
            if (preNodes.size() <= 0) continue;
            HistoricActivityInstanceEntity nodeInst = preNodes.get(0);
            switch (nodeInst.getActivityType()) {
                case "UserTask": {
                    hiActInstList.add(nodeInst);
                    continue block12;
                }
                case "AuditTask": {
                    if (nodeInst.getExecutionType().equals("byAuto")) {
                        hiActInstList.addAll(GetLastNodesCommentsByBusinesskeyCmd.getHistoricActivitysByCurActInstId(commandContext, nodeInst.getId()));
                        continue block12;
                    }
                    if (nodeInst.getExecutionType().equals("skip")) {
                        hiActInstList.addAll(GetLastNodesCommentsByBusinesskeyCmd.getHistoricActivitysByCurActInstId(commandContext, nodeInst.getId()));
                        continue block12;
                    }
                    hiActInstList.add(nodeInst);
                    continue block12;
                }
                case "YunzhijiaTask": {
                    hiActInstList.add(nodeInst);
                    continue block12;
                }
                case "AutoTask": {
                    hiActInstList.addAll(GetLastNodesCommentsByBusinesskeyCmd.getHistoricActivitysByCurActInstId(commandContext, nodeInst.getId()));
                    continue block12;
                }
            }
            return hiActInstList;
        }
        return hiActInstList;
    }
}

