/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntity;
import kd.bos.workflow.engine.task.Comment;

public class GetLastNodesCommentsByBusinesskeysCmd
implements Command<Map<String, List<Comment>>> {
    protected static Log logger = LogFactory.getLog(GetLastNodesCommentsByBusinesskeysCmd.class);
    private List<String> businessKeys = new ArrayList<String>();

    public GetLastNodesCommentsByBusinesskeysCmd(List<String> businessKeys) {
        this.businessKeys = businessKeys;
    }

    @Override
    public Map<String, List<Comment>> execute(CommandContext commandContext) {
        HashSet<Long> commentIds = new HashSet<Long>();
        String queryNodeMapperSql = "SELECT flastnodecid lasetNodeCid FROM t_wf_hiuseractinst WHERE fbusinesskey in ? AND fendtime is null AND FLASTUSERNODEACTID !='start'";
        int keySize = this.businessKeys.size();
        int j = keySize % 100 != 0 ? keySize / 100 + 1 : keySize / 100;
        DataSet unionDs = null;
        for (int x = 0; x < j; ++x) {
            int end = (x + 1) * 100 > keySize ? keySize : (x + 1) * 100;
            List<String> subList = this.businessKeys.subList(x * 100, end);
            String businessKeys = this.getBusinessKeys(subList);
            if (WfUtils.isEmpty(businessKeys)) continue;
            String sql = queryNodeMapperSql.replace("?", businessKeys);
            Object[] params = new Object[]{};
            try (DataSet ds = DB.queryDataSet((String)"wf.engine.GetLastNodesCommentsByBusinesskeys", (DBRoute)DBRoute.workflow, (String)sql, (Object[])params);){
                unionDs = unionDs == null ? ds : unionDs.union(ds);
                if (unionDs == null) continue;
                for (Row r : unionDs) {
                    Long cid = r.getLong("lasetNodeCid");
                    if (!WfUtils.isNotEmpty(cid)) continue;
                    commentIds.add(cid);
                }
                continue;
            }
        }
        if (commentIds.isEmpty()) {
            return Collections.emptyMap();
        }
        QFilter f = new QFilter("id", "in", commentIds);
        List comments = commandContext.getCommentEntityManager().findByQueryFilters(new QFilter[]{f});
        HashMap<String, List<Comment>> result = new HashMap<String, List<Comment>>();
        HashMap<String, ILocaleString> cidMapAssign = new HashMap<String, ILocaleString>();
        for (CommentEntity c : comments) {
            ILocaleString assignee;
            String bsnk = c.getBusinessKey();
            ArrayList<CommentEntity> cs = (ArrayList<CommentEntity>)result.get(bsnk);
            if (cs == null) {
                cs = new ArrayList<CommentEntity>();
            }
            if (WfUtils.isNotEmpty(c.getGroupId()) && !c.getGroupId().equals(c.getTaskId().toString())) {
                String cid = String.valueOf(c.getGroupId());
                ILocaleString assignee2 = c.getTaskAssignee();
                ILocaleString temp = (ILocaleString)cidMapAssign.get(cid);
                if (temp == null) {
                    temp = new LocaleString();
                    cidMapAssign.put(cid, temp);
                }
                for (String key : assignee2.keySet()) {
                    String value = (String)temp.get((Object)key);
                    StringBuilder sb = new StringBuilder();
                    if (value != null) {
                        sb.append(value);
                    }
                    sb.append((String)assignee2.get((Object)key)).append(',');
                    temp.put((Object)key, (Object)sb.toString());
                }
            }
            if (cs.contains(c) || !WfUtils.isEmpty(c.getGroupId()) && !c.getGroupId().equals(c.getTaskId().toString())) continue;
            cs.add(c);
            if (WfUtils.isEmpty(c.getAssignee()) && WfUtils.isNotEmpty((ILocaleString)cidMapAssign.get(String.valueOf(c.getId()))) && (assignee = (ILocaleString)cidMapAssign.get(String.valueOf(c.getId()))) != null && !WfUtils.isEmpty(assignee.toString())) {
                c.setAssignee(assignee);
            }
            result.put(bsnk, cs);
        }
        return result;
    }

    private String getBusinessKeys(List<String> subList) {
        String businessKeys = "";
        char c = '\'';
        if (subList == null || subList.isEmpty()) {
            return businessKeys;
        }
        StringBuilder businesskeysSB = new StringBuilder();
        businesskeysSB.append('(');
        for (String s : subList) {
            businesskeysSB.append(c).append(s).append(c).append(',');
        }
        if (businesskeysSB.length() > 1) {
            businessKeys = businesskeysSB.substring(0, businesskeysSB.length() - 1) + ")";
        }
        return businessKeys;
    }
}

