/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.io.Serializable;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntity;

public class GetLatestHiTaskIdByBusinessKeyAndUserIdCmd
implements Command<Long>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String businessKey;
    protected Long userId;

    public GetLatestHiTaskIdByBusinessKeyAndUserIdCmd(String businessKey, Long userId) {
        this.businessKey = businessKey;
        this.userId = userId;
    }

    @Override
    public Long execute(CommandContext commandContext) {
        if (WfUtils.isEmpty(this.userId)) {
            this.userId = RequestContext.get().getCurrUserId();
        }
        EntityQueryBuilder queryBuilder = commandContext.getCommentEntityManager().createQueryBuilder();
        QFilter[] qFilters = new QFilter[]{new QFilter("userId", "=", (Object)this.userId), new QFilter("type", "=", (Object)"comment"), new QFilter("businessKey", "=", (Object)this.businessKey)};
        queryBuilder.setSelectFields("taskId,time").addFilters(qFilters).orderBy("time desc").setLimit(1);
        List comments = commandContext.getCommentEntityManager().findByQueryBuilder(queryBuilder);
        if (null == comments || comments.isEmpty()) {
            return null;
        }
        return ((CommentEntity)comments.get(0)).getTaskId();
    }
}

