/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.channel.cache.MsgServiceCacheHelper;
import kd.bos.message.menuconfig.MenuConfigUtil;
import kd.bos.message.menuconfig.MessageMenuConfigObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskCenterNavigationEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskCenterNavigationEntityImpl;
import kd.bos.workflow.engine.msg.MessageServiceUtil;
import kd.bos.workflow.engine.msg.quantitysum.MessageQuantitySummaryServcie;
import kd.bos.workflow.engine.msg.quantitysum.QuantitySummaryInfo;
import kd.bos.workflow.engine.task.center.util.NavigationTreeNode;
import kd.bos.workflow.util.WfComMultiLangUtil;
import org.apache.commons.collections.CollectionUtils;

public class GetMCNavigationDataCmd
implements Command<HashMap<String, List<TaskCenterNavigationEntity>>>,
Serializable {
    private static Log logger = LogFactory.getLog(GetMCNavigationDataCmd.class);
    private static final long serialVersionUID = 1L;
    private Log log = LogFactory.getLog(this.getClass());
    private static final String TASK = "task";
    private static final String MESSAGE = "message";
    private static final String METADATACACHE = "metadataCache";
    private long userId;
    private static final String NUMBER = "number";
    private static final String ZH_CN = "zh_CN";
    private static final String SOURCESYSTEM = "sourceSystem";
    private static final String SOURCEBIZ = "sourceBiz";
    private static final String[] messaeTypeArrays = new String[]{"alarm", "message", "warning", "notice", "activity"};

    public GetMCNavigationDataCmd(long userId) {
        this.userId = userId;
    }

    @Override
    public HashMap<String, List<TaskCenterNavigationEntity>> execute(CommandContext commandContext) {
        List<QuantitySummaryInfo> quantitySummaryInfos = this.getQuantitySummaryInfos();
        Map<String, Map<String, String>> menuNameImapping = this.getMenuNameImapping(quantitySummaryInfos);
        List<TaskCenterNavigationEntity> generalNavigationNodes = this.getGeneralNavigationNodes(quantitySummaryInfos, menuNameImapping);
        List<TaskCenterNavigationEntity> transferNavigationNodes = this.getTransferNavigationNodes(quantitySummaryInfos);
        List<TaskCenterNavigationEntity> delegateNavigationNodes = this.getDelegateNavigationNodes(quantitySummaryInfos);
        List<TaskCenterNavigationEntity> customNavigationNodes = this.getCustomNavigationNodes(commandContext, quantitySummaryInfos, this.userId);
        List<TaskCenterNavigationEntity> msgNavigationNodes = this.getMsgNavigationNodes(quantitySummaryInfos);
        HashMap<String, List<TaskCenterNavigationEntity>> resultData = new HashMap<String, List<TaskCenterNavigationEntity>>();
        resultData.put(TASK, generalNavigationNodes);
        resultData.put("transfer", transferNavigationNodes);
        resultData.put("delegate", delegateNavigationNodes);
        resultData.put("custom", customNavigationNodes);
        resultData.put(MESSAGE, msgNavigationNodes);
        return resultData;
    }

    private List<QuantitySummaryInfo> getQuantitySummaryInfos() {
        MessageQuantitySummaryServcie service = MessageServiceUtil.getMessageQuantitySummaryService();
        List<QuantitySummaryInfo> quantitySummaryInfos = service.getMsgQuantitySummary(this.userId);
        this.calculateCompensationData(service, quantitySummaryInfos);
        return quantitySummaryInfos;
    }

    private void calculateCompensationData(MessageQuantitySummaryServcie service, List<QuantitySummaryInfo> quantitySummaryInfos) {
        List<QuantitySummaryInfo> compensationData = service.calculateCompensationData(this.userId);
        if (!compensationData.isEmpty()) {
            logger.debug(String.format("GetMCNavigationDataCmd compensationdata is : %s", compensationData.toString()));
            for (QuantitySummaryInfo quantitySummaryInfo : compensationData) {
                boolean isExist = false;
                String dataType = quantitySummaryInfo.getDataType();
                String billType = quantitySummaryInfo.getBillType();
                int quantitysum = quantitySummaryInfo.getQuantitysum();
                for (QuantitySummaryInfo qs : quantitySummaryInfos) {
                    if (!qs.getDataType().equals(dataType) || !qs.getBillType().equals(billType)) continue;
                    qs.setQuantitysum(qs.getQuantitysum() + quantitysum);
                    isExist = true;
                    break;
                }
                if (isExist) continue;
                quantitySummaryInfos.add(quantitySummaryInfo);
            }
        }
    }

    private Map<String, Map<String, String>> getMenuNameImapping(List<QuantitySummaryInfo> quantitySummaryInfos) {
        Map<String, Map<String, String>> currentMenuNames;
        Set<String> noCacheBillTypes;
        Set<String> billTypes = quantitySummaryInfos.stream().filter(qsInfo -> WfUtils.isNotEmpty(qsInfo.getBillType())).map(item -> item.getBillType()).collect(Collectors.toSet());
        HashMap<String, Map<String, String>> menuNameImappings = new HashMap();
        String nameCache = MsgServiceCacheHelper.getMCEntityNameCache();
        if (WfUtils.isNotEmpty(nameCache)) {
            menuNameImappings = (Map)SerializationUtils.fromJsonString((String)nameCache, Map.class);
            Set keys = menuNameImappings.keySet();
            noCacheBillTypes = billTypes.stream().filter(billType -> !keys.contains(billType)).collect(Collectors.toSet());
        } else {
            noCacheBillTypes = billTypes;
        }
        if (noCacheBillTypes != null && !noCacheBillTypes.isEmpty() && (currentMenuNames = this.getMenuNamesByBillTypes(noCacheBillTypes)) != null && !currentMenuNames.isEmpty()) {
            menuNameImappings.putAll(currentMenuNames);
            MsgServiceCacheHelper.putMCEntityNameCache((String)SerializationUtils.toJsonString(menuNameImappings));
        }
        return menuNameImappings;
    }

    private Map<String, Map<String, String>> getMenuNamesByBillTypes(Set<String> billTypes) {
        Map<String, Map<String, String>> sourceNameImmapping;
        Set<String> sources;
        HashMap<String, Map<String, String>> menuNamesImmapping = new HashMap<String, Map<String, String>>();
        Set<String> commonTaskBillTypes = billTypes.stream().filter(item -> item.startsWith("1&")).collect(Collectors.toSet());
        Set<String> outerNoEntityTaskBillTypes = billTypes.stream().filter(item -> item.startsWith("3&")).collect(Collectors.toSet());
        Set<String> outerEntityTaskBillTypes = billTypes.stream().filter(item -> item.startsWith("4&")).collect(Collectors.toSet());
        Set<String> cosmicEntityTaskBillTypes = billTypes.stream().filter(item -> !commonTaskBillTypes.contains(item) && !outerEntityTaskBillTypes.contains(item) && !outerNoEntityTaskBillTypes.contains(item)).collect(Collectors.toSet());
        if (!commonTaskBillTypes.isEmpty()) {
            Set<String> bizTypes = commonTaskBillTypes.stream().map(item -> item.split("&")[1]).collect(Collectors.toSet());
            Map<String, Map<String, String>> bizTypeNameImmapping = this.getSourceNameImmapping(bizTypes, SOURCEBIZ);
            menuNamesImmapping.putAll(this.joinMenuNameImmapping(commonTaskBillTypes, null, bizTypeNameImmapping));
        }
        if (!cosmicEntityTaskBillTypes.isEmpty()) {
            Set<String> entitys = cosmicEntityTaskBillTypes.stream().collect(Collectors.toSet());
            Map<String, Map<String, String>> entityNameImmapping = this.getEntityNameImmapping(entitys);
            menuNamesImmapping.putAll(this.joinMenuNameImmappingWithCosmicEntity(cosmicEntityTaskBillTypes, entityNameImmapping));
        }
        if (!outerNoEntityTaskBillTypes.isEmpty()) {
            sources = outerNoEntityTaskBillTypes.stream().map(item -> item.split("&")[1]).collect(Collectors.toSet());
            sourceNameImmapping = this.getSourceNameImmapping(sources, SOURCESYSTEM);
            Set<String> bizTypes = outerNoEntityTaskBillTypes.stream().map(item -> item.split("&")[2]).collect(Collectors.toSet());
            Map<String, Map<String, String>> bizTypeNameImmapping = this.getSourceNameImmapping(bizTypes, SOURCEBIZ);
            menuNamesImmapping.putAll(this.joinMenuNameImmapping(outerNoEntityTaskBillTypes, sourceNameImmapping, bizTypeNameImmapping));
        }
        if (!outerEntityTaskBillTypes.isEmpty()) {
            sources = outerEntityTaskBillTypes.stream().map(item -> item.split("&")[1]).collect(Collectors.toSet());
            sourceNameImmapping = this.getSourceNameImmapping(sources, SOURCESYSTEM);
            Set<String> entitys = outerEntityTaskBillTypes.stream().map(item -> item.split("&")[2]).collect(Collectors.toSet());
            Map<String, Map<String, String>> entityNameImapping = this.getEntityNameImmapping(entitys);
            menuNamesImmapping.putAll(this.joinMenuNameImmapping(outerEntityTaskBillTypes, sourceNameImmapping, entityNameImapping));
        }
        return menuNamesImmapping;
    }

    private Map<String, Map<String, String>> getSourceNameImmapping(Set<String> sources, String type) {
        HashMap<String, Map<String, String>> sourceNameImmapping = new HashMap<String, Map<String, String>>();
        String number = SOURCESYSTEM.equals(type) ? "sysnumber" : "biznumber";
        String name = SOURCESYSTEM.equals(type) ? "sysname" : "bizname";
        QFilter[] filters = new QFilter[]{new QFilter(number, "in", sources)};
        DynamicObject[] sourceSystems = BusinessDataServiceHelper.load((String)"wf_taskthirdsource", (String)(number + "," + name), (QFilter[])filters);
        if (sourceSystems != null && sourceSystems.length > 0) {
            for (DynamicObject sourceSystem : sourceSystems) {
                String numberValue = sourceSystem.getString(number);
                if (sourceNameImmapping.containsKey(numberValue)) continue;
                ILocaleString sourceSystemNames = sourceSystem.getLocaleString(name);
                Set entries = sourceSystemNames.entrySet();
                HashMap nameImmapping = new HashMap(entries.size());
                for (Map.Entry entry : entries) {
                    nameImmapping.put(entry.getKey(), entry.getValue());
                }
                sourceNameImmapping.put(numberValue, nameImmapping);
            }
        }
        return sourceNameImmapping;
    }

    private Map<String, Map<String, String>> getEntityNameImmapping(Set<String> billTypes) {
        HashMap<String, Map<String, String>> entityNameMapping = new HashMap<String, Map<String, String>>(billTypes.size());
        String navigationMenuNameType = this.getNavigationMenuNameType();
        try {
            if (METADATACACHE.equalsIgnoreCase(navigationMenuNameType)) {
                QFilter[] filters = new QFilter[]{new QFilter(NUMBER, "in", (Object)billTypes.toArray())};
                DynamicObject[] formmetaObjects = BusinessDataServiceHelper.load((String)"bos_formmeta", (String)"id, number", (QFilter[])filters);
                if (formmetaObjects != null && formmetaObjects.length > 0) {
                    ArrayList<String> entityMetas = new ArrayList<String>(formmetaObjects.length);
                    for (DynamicObject formmeta : formmetaObjects) {
                        entityMetas.add(formmeta.getString(NUMBER));
                    }
                    for (String number : entityMetas) {
                        try {
                            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)number);
                            this.wrapNameMapping(null, dataEntityType, number, entityNameMapping);
                            billTypes.remove(number);
                        }
                        catch (Exception e) {
                            this.log.info(String.format("getEntityName-exception and number=%s", number));
                        }
                    }
                }
            } else {
                HashMap<String, DynamicObject[]> idNumbers = new HashMap<String, DynamicObject[]>();
                QFilter[] filters = new QFilter[]{new QFilter(NUMBER, "in", (Object)billTypes.toArray())};
                DynamicObject[] formmetas = BusinessDataServiceHelper.load((String)"bos_formmeta", (String)"id, number, name", (QFilter[])filters);
                if (formmetas != null && formmetas.length > 0) {
                    for (DynamicObject formmeta : formmetas) {
                        DynamicObject[] number = formmeta.getString(NUMBER);
                        String id = formmeta.getString("id");
                        this.wrapNameMapping(formmeta, null, (String)number, entityNameMapping);
                        idNumbers.put(id, number);
                        billTypes.remove(number);
                    }
                    Set ids = idNumbers.keySet();
                    QFilter[] filter1 = new QFilter[]{new QFilter("masterid", "in", ids)};
                    DynamicObject[] extendFormmetas = BusinessDataServiceHelper.load((String)"bos_formmeta", (String)"id, number, masterid, inheritpath, name", (QFilter[])filter1, (String)"createdate desc");
                    if (extendFormmetas != null && extendFormmetas.length > 0) {
                        HashMap<String, DynamicObject> extendFormmetaMapping = new HashMap<String, DynamicObject>();
                        for (DynamicObject extendFormmeta : extendFormmetas) {
                            String masterId = extendFormmeta.getString("masterid");
                            if (!extendFormmetaMapping.containsKey(masterId)) {
                                extendFormmetaMapping.put(masterId, extendFormmeta);
                                continue;
                            }
                            String[] inheritpaths = extendFormmeta.getString("inheritpath").split(",");
                            if (inheritpaths.length <= ((DynamicObject)extendFormmetaMapping.get(masterId)).getString("inheritpath").split(",").length) continue;
                            extendFormmetaMapping.put(masterId, extendFormmeta);
                        }
                        Set entries = extendFormmetaMapping.entrySet();
                        for (Map.Entry entry : entries) {
                            String number = (String)idNumbers.get(entry.getKey());
                            DynamicObject targetExtendFormat = (DynamicObject)entry.getValue();
                            this.wrapNameMapping(targetExtendFormat, null, number, entityNameMapping);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            this.log.info(String.format("getEntityName-exception: %s", WfUtils.getExceptionStacktrace(e)));
        }
        if (billTypes.isEmpty()) {
            return entityNameMapping;
        }
        QFilter[] filters2 = new QFilter[]{new QFilter(NUMBER, "in", (Object)billTypes.toArray())};
        DynamicObject[] billTypeObjects = BusinessDataServiceHelper.load((String)"bos_billtype", (String)"number, billformid, name", (QFilter[])filters2);
        for (DynamicObject billTypeObject : billTypeObjects) {
            String number = billTypeObject.getString(NUMBER);
            this.wrapNameMapping(billTypeObject, null, number, entityNameMapping);
            billTypes.remove(number);
        }
        if (billTypes.isEmpty()) {
            return entityNameMapping;
        }
        for (String billType : billTypes) {
            HashMap<String, String> names = new HashMap<String, String>();
            names.put(RequestContext.get().getLang().toString(), billType);
            entityNameMapping.put(billType, names);
        }
        return entityNameMapping;
    }

    private Map<String, String> wrapNameMapping(DynamicObject entityObject, MainEntityType dataEntityType, String number, Map<String, Map<String, String>> entityNameMapping) {
        HashMap<String, String> names = new HashMap<String, String>();
        Object entityName = null;
        entityName = entityObject != null ? entityObject.getLocaleString("name") : dataEntityType.getDisplayName();
        if (entityName != null) {
            Set nameLangs = entityName.keySet();
            for (String lang : nameLangs) {
                String nameItem = (String)entityName.getItem(lang);
                if (WfUtils.isNotEmpty(nameItem)) {
                    names.put(lang, nameItem);
                    continue;
                }
                String defaultName = (String)entityName.getDefaultItem();
                if (WfUtils.isNotEmpty(defaultName)) {
                    names.put(lang, defaultName);
                    continue;
                }
                names.put(lang, number);
            }
            entityNameMapping.put(number, names);
        }
        return names;
    }

    private Map<String, Map<String, String>> joinMenuNameImmapping(Set<String> billTypes, Map<String, Map<String, String>> sourceNameImmapping, Map<String, Map<String, String>> bizTypeNameImmapping) {
        HashMap<String, Map<String, String>> menuNameImapping = new HashMap<String, Map<String, String>>(billTypes.size());
        Lang[] supportLangs = WfComMultiLangUtil.getSupportLangs();
        for (String billType : billTypes) {
            String[] split = billType.split("&");
            if (sourceNameImmapping != null && split.length < 3) {
                logger.error(String.format("joinMenuName is error and skip, billType[%s]", billType));
                continue;
            }
            String source = null;
            Map<String, String> sourceName = null;
            String bizType = null;
            Map<String, String> bizTypeName = null;
            if (sourceNameImmapping != null) {
                source = split[1];
                sourceName = sourceNameImmapping.get(source);
                bizType = split[2];
                bizTypeName = bizTypeNameImmapping.get(bizType);
            } else {
                bizType = split[split.length - 1];
                bizTypeName = bizTypeNameImmapping.get(bizType);
            }
            if (WfUtils.isEmptyForMap(bizTypeName) || sourceNameImmapping != null && WfUtils.isEmptyForMap(sourceName)) {
                logger.error(String.format("joinMenuName is source or biztypeName empty and skip, billType[%s]", billType));
                continue;
            }
            HashMap<String, String> menuName = new HashMap<String, String>();
            for (Lang lang : supportLangs) {
                String btName;
                String langTag = lang.name();
                String sName = "";
                if (sourceName != null && WfUtils.isEmpty(sName = sourceName.get(langTag))) {
                    sName = WfUtils.isNotEmpty(sourceName.get("GLang")) ? sourceName.get("GLang") : source;
                }
                if (WfUtils.isEmpty(btName = bizTypeName.get(langTag))) {
                    btName = WfUtils.isNotEmpty(bizTypeName.get("GLang")) ? bizTypeName.get("GLang") : bizType;
                }
                menuName.put(langTag, sourceName != null ? sName + "_" + btName : btName);
            }
            menuNameImapping.put(billType, menuName);
        }
        return menuNameImapping;
    }

    private Map<String, Map<String, String>> joinMenuNameImmappingWithCosmicEntity(Set<String> billTypes, Map<String, Map<String, String>> bizTypeNameImmapping) {
        HashMap<String, Map<String, String>> menuNameImapping = new HashMap<String, Map<String, String>>(billTypes.size());
        Lang[] supportLangs = WfComMultiLangUtil.getSupportLangs();
        for (String billType : billTypes) {
            String bizType = billType;
            Map<String, String> bizTypeName = bizTypeNameImmapping.get(bizType);
            if (WfUtils.isEmptyForMap(bizTypeName)) {
                logger.error(String.format("joinMenuName is source or biztypeName empty and skip, billType[%s]", billType));
                continue;
            }
            HashMap<String, String> menuName = new HashMap<String, String>(8);
            for (Lang lang : supportLangs) {
                String langTag = lang.name();
                String btName = bizTypeName.get(langTag);
                if (WfUtils.isEmpty(btName)) {
                    btName = WfUtils.isNotEmpty(bizTypeName.get("GLang")) ? bizTypeName.get("GLang") : bizType;
                }
                menuName.put(langTag, btName);
            }
            menuNameImapping.put(billType, menuName);
        }
        return menuNameImapping;
    }

    private void wrapTaskCenterNavigationEntityNames(TaskCenterNavigationEntity children, Map<String, Map<String, String>> menuNameImapping) {
        String name;
        String lang = RequestContext.get().getLang().toString();
        String billType = children.getNumber();
        String[] billTypeItem = billType.split("&");
        String namePrefix = billTypeItem[0].equals("3") || billTypeItem[0].equals("4") ? "3&" : "1&";
        Map<String, String> nameImapping = menuNameImapping.get(billType);
        if (nameImapping == null || nameImapping.isEmpty()) {
            logger.error(String.format("second child menu[%s] no name", billType));
            name = billType;
        } else {
            name = nameImapping.containsKey(lang) ? nameImapping.get(lang) : this.getBackUpName(nameImapping);
            if (WfUtils.isEmpty(name)) {
                name = billType;
            }
        }
        String sortName = namePrefix + name;
        children.setName((ILocaleString)new LocaleString(name));
        children.setSortName(sortName);
    }

    private String getBackUpName(Map<String, String> nameImapping) {
        String name = null;
        if (nameImapping.containsKey("GLang")) {
            name = nameImapping.get("GLang");
        } else if (nameImapping.containsKey(ZH_CN)) {
            name = nameImapping.get(ZH_CN);
        }
        return name;
    }

    private void sortGeneralNavigationNodes(List<TaskCenterNavigationEntity> generalNavigationNodes) {
        for (TaskCenterNavigationEntity generalNavigationNode : generalNavigationNodes) {
            List<TaskCenterNavigationEntity> chaildNavigationNodes = generalNavigationNode.getChildren();
            if (chaildNavigationNodes == null || chaildNavigationNodes.isEmpty()) continue;
            Collections.sort(chaildNavigationNodes, new Comparator<TaskCenterNavigationEntity>(){

                @Override
                public int compare(TaskCenterNavigationEntity t1, TaskCenterNavigationEntity t2) {
                    String sortName1 = t1.getSortName();
                    String sortName2 = t2.getSortName();
                    if (WfUtils.isEmpty(sortName1) || WfUtils.isEmpty(sortName2)) {
                        logger.info("mcenter menuSort [%s-%s][%s-%s]", new Object[]{t1.getNumber(), t1.getName(), t2.getNumber(), t2.getName()});
                        return -10;
                    }
                    return sortName1.compareTo(sortName2);
                }
            });
        }
    }

    private int getQuantitySummary(List<QuantitySummaryInfo> quantitySummaryInfos, String dataType, String billType) {
        MessageQuantitySummaryServcie service = MessageServiceUtil.getMessageQuantitySummaryService();
        return service.getQuantitySummaryCount(quantitySummaryInfos, dataType, billType);
    }

    private boolean checkCustomType(String typeNumber) {
        boolean isCustomType = Boolean.TRUE;
        if (WfUtils.isNotEmpty(typeNumber)) {
            for (String messageType : messaeTypeArrays) {
                if (!messageType.equalsIgnoreCase(typeNumber) || "activity".equalsIgnoreCase(typeNumber)) continue;
                isCustomType = Boolean.FALSE;
                break;
            }
        }
        return isCustomType;
    }

    private List<TaskCenterNavigationEntity> getGeneralNavigationNodes(List<QuantitySummaryInfo> quantitySummaryInfos, Map<String, Map<String, String>> menuNameImapping) {
        ArrayList<TaskCenterNavigationEntity> taskCenterNavigationEntities = new ArrayList<TaskCenterNavigationEntity>();
        TaskCenterNavigationEntityImpl toHandleNode = new TaskCenterNavigationEntityImpl();
        toHandleNode.setName((ILocaleString)new LocaleString(ResManager.loadKDString((String)"\u5f85\u529e\u4efb\u52a1", (String)"GetMCNavigationDataCmd_1", (String)"bos-wf-engine", (Object[])new Object[0])));
        toHandleNode.setCategory(NavigationTreeNode.NavigationMenuCategory.GENERAL.getNumber());
        toHandleNode.setNumber("wf_task");
        toHandleNode.setMenuSvg(MCNavigationItemSvg.TOHANDLE.getSvgValue());
        toHandleNode.setImgSrc("private/wf/navigation/toHandle.png");
        toHandleNode.setHoverImgSrc("private/wf/navigation/toHandle_L.png");
        toHandleNode.setChildren(this.getGeneralChildren(quantitySummaryInfos, "tohandle", menuNameImapping));
        taskCenterNavigationEntities.add(toHandleNode);
        TaskCenterNavigationEntityImpl handledNode = new TaskCenterNavigationEntityImpl();
        handledNode.setName((ILocaleString)new LocaleString(ResManager.loadKDString((String)"\u5df2\u529e\u4efb\u52a1", (String)"GetMCNavigationDataCmd_2", (String)"bos-wf-engine", (Object[])new Object[0])));
        handledNode.setCategory(NavigationTreeNode.NavigationMenuCategory.GENERAL.getNumber());
        handledNode.setNumber("wf_hitaskinst");
        handledNode.setMenuSvg(MCNavigationItemSvg.HANDLED.getSvgValue());
        handledNode.setImgSrc("private/wf/navigation/handled11.png");
        handledNode.setHoverImgSrc("private/wf/navigation/handled_L.png");
        handledNode.setChildren(this.getGeneralChildren(quantitySummaryInfos, "handled", menuNameImapping));
        taskCenterNavigationEntities.add(handledNode);
        TaskCenterNavigationEntityImpl toApplyNode = new TaskCenterNavigationEntityImpl();
        toApplyNode.setName((ILocaleString)new LocaleString(ResManager.loadKDString((String)"\u5728\u529e\u7533\u8bf7", (String)"GetMCNavigationDataCmd_3", (String)"bos-wf-engine", (Object[])new Object[0])));
        toApplyNode.setCategory(NavigationTreeNode.NavigationMenuCategory.GENERAL.getNumber());
        toApplyNode.setNumber("wf_execution");
        toApplyNode.setMenuSvg(MCNavigationItemSvg.TOAPPLY.getSvgValue());
        toApplyNode.setImgSrc("private/wf/navigation/toApply.png");
        toApplyNode.setHoverImgSrc("private/wf/navigation/toApply_L.png");
        toApplyNode.setChildren(this.getGeneralChildren(quantitySummaryInfos, "toapply", menuNameImapping));
        taskCenterNavigationEntities.add(toApplyNode);
        TaskCenterNavigationEntityImpl applyedNode = new TaskCenterNavigationEntityImpl();
        applyedNode.setName((ILocaleString)new LocaleString(ResManager.loadKDString((String)"\u5df2\u529e\u7533\u8bf7", (String)"GetMCNavigationDataCmd_4", (String)"bos-wf-engine", (Object[])new Object[0])));
        applyedNode.setCategory(NavigationTreeNode.NavigationMenuCategory.GENERAL.getNumber());
        applyedNode.setNumber("wf_hiprocinst");
        applyedNode.setMenuSvg(MCNavigationItemSvg.APPLYED.getSvgValue());
        applyedNode.setImgSrc("private/wf/navigation/applyed.png");
        applyedNode.setHoverImgSrc("private/wf/navigation/applyed_L.png");
        applyedNode.setChildren(this.getGeneralChildren(quantitySummaryInfos, "applyed", menuNameImapping));
        taskCenterNavigationEntities.add(applyedNode);
        this.sortGeneralNavigationNodes(taskCenterNavigationEntities);
        return taskCenterNavigationEntities;
    }

    private List<TaskCenterNavigationEntity> getGeneralChildren(List<QuantitySummaryInfo> quantitySummaryInfos, String dataType, Map<String, Map<String, String>> menuNameImapping) {
        ArrayList<TaskCenterNavigationEntity> navigationChildren = new ArrayList<TaskCenterNavigationEntity>();
        for (int i = 0; i < quantitySummaryInfos.size(); ++i) {
            QuantitySummaryInfo qsInfo = quantitySummaryInfos.get(i);
            if (!dataType.equalsIgnoreCase(qsInfo.getDataType())) continue;
            int quantitysum = qsInfo.getQuantitysum();
            String billType = qsInfo.getBillType();
            if (quantitysum <= 0 || !WfUtils.isNotEmpty(billType)) continue;
            TaskCenterNavigationEntityImpl child = new TaskCenterNavigationEntityImpl();
            child.setParentid((long)dataType.hashCode() + 0L);
            child.setNumber(billType);
            child.setCount(quantitysum);
            this.wrapTaskCenterNavigationEntityNames(child, menuNameImapping);
            navigationChildren.add(child);
        }
        return navigationChildren;
    }

    private List<TaskCenterNavigationEntity> getDelegateNavigationNodes(List<QuantitySummaryInfo> quantitySummaryInfos) {
        ArrayList<TaskCenterNavigationEntity> delegateNodes = new ArrayList<TaskCenterNavigationEntity>();
        TaskCenterNavigationEntityImpl delegateNode = new TaskCenterNavigationEntityImpl();
        delegateNode.setName(WfUtils.getPromptWordLocaleString("\u6211\u7684\u59d4\u6258", "GetMCNavigationDataCmd_6", "bos-wf-engine"));
        delegateNode.setNumber("delegate");
        delegateNode.setMenuSvg(MCNavigationItemSvg.DELEGATE.getSvgValue());
        delegateNode.setCategory(NavigationTreeNode.NavigationMenuCategory.DELEGATE.getNumber());
        int delegateCount = 0;
        for (int i = 0; i < quantitySummaryInfos.size(); ++i) {
            QuantitySummaryInfo qsInfo = quantitySummaryInfos.get(i);
            if (!"delegate".equals(qsInfo.getDataType())) continue;
            delegateCount = qsInfo.getQuantitysum();
            break;
        }
        delegateCount = delegateCount < 0 ? 0 : delegateCount;
        delegateNode.setCount(delegateCount);
        delegateNode.setImgSrc("private/wf/navigation/wdwt.png");
        delegateNode.setHoverImgSrc("private/wf/navigation/wdwt_hover.png");
        delegateNodes.add(delegateNode);
        return delegateNodes;
    }

    private List<TaskCenterNavigationEntity> getTransferNavigationNodes(List<QuantitySummaryInfo> quantitySummaryInfos) {
        ArrayList<TaskCenterNavigationEntity> transferNodes = new ArrayList<TaskCenterNavigationEntity>();
        TaskCenterNavigationEntityImpl transferNode = new TaskCenterNavigationEntityImpl();
        transferNode.setName((ILocaleString)ResManager.getLocaleString((String)"\u6211\u7684\u8f6c\u4ea4", (String)"GetMCNavigationDataCmd_5", (String)"bos-wf-engine"));
        transferNode.setNumber("transfer");
        transferNode.setMenuSvg(MCNavigationItemSvg.TRANSFER.getSvgValue());
        transferNode.setCategory(NavigationTreeNode.NavigationMenuCategory.TRANSFER.getNumber());
        int transferCount = 0;
        for (int i = 0; i < quantitySummaryInfos.size(); ++i) {
            QuantitySummaryInfo qsInfo = quantitySummaryInfos.get(i);
            if (!"transfer".equals(qsInfo.getDataType())) continue;
            transferCount = qsInfo.getQuantitysum();
            break;
        }
        transferCount = transferCount < 0 ? 0 : transferCount;
        transferNode.setCount(transferCount);
        transferNodes.add(transferNode);
        return transferNodes;
    }

    private List<TaskCenterNavigationEntity> getCustomNavigationNodes(CommandContext commandContext, List<QuantitySummaryInfo> quantitySummaryInfos, Long userId) {
        List<TaskCenterNavigationEntity> customNodes = commandContext.getTaskCenterNavigationEntityManager().getNavigationByUserid(userId);
        if (WfUtils.isNotEmptyForCollection(customNodes)) {
            for (TaskCenterNavigationEntity customNode : customNodes) {
                customNode.setMenuSvg(MCNavigationItemSvg.CUSTOM.getSvgValue());
                customNode.setCategory(NavigationTreeNode.NavigationMenuCategory.CUSTOM.getNumber());
                String ruleId = customNode.getId().toString();
                int cutomCount = 0;
                for (int i = 0; i < quantitySummaryInfos.size(); ++i) {
                    QuantitySummaryInfo qsInfo = quantitySummaryInfos.get(i);
                    if (!"custom".equals(qsInfo.getDataType()) || !ruleId.equals(qsInfo.getBillType())) continue;
                    cutomCount = qsInfo.getQuantitysum();
                    break;
                }
                cutomCount = cutomCount < 0 ? 0 : cutomCount;
                customNode.setCount(cutomCount);
            }
        }
        Collections.reverse(customNodes);
        customNodes = this.serializationTaskCenterNavigationEntitys(customNodes);
        return customNodes;
    }

    private List<TaskCenterNavigationEntity> getMsgNavigationNodes(List<QuantitySummaryInfo> quantitySummaryInfos) {
        ArrayList<TaskCenterNavigationEntity> msgNodes = new ArrayList<TaskCenterNavigationEntity>();
        List menuConfigObjects = MenuConfigUtil.getMessageMenuConfig();
        if (menuConfigObjects.size() > 0) {
            for (MessageMenuConfigObject msgType : menuConfigObjects) {
                TaskCenterNavigationEntityImpl msgNode = new TaskCenterNavigationEntityImpl();
                msgNode.setId(msgType.getMsgtypeid());
                msgNode.setNumber(msgType.getNumber());
                msgNode.setName((ILocaleString)msgType.getName());
                msgNode.setCategory(NavigationTreeNode.NavigationMenuCategory.MESSAGE.getNumber());
                msgNode.setParentid(1L);
                String number = msgNode.getNumber();
                msgNode.setCount(this.getQuantitySummary(quantitySummaryInfos, "msg", number));
                String ImgNumber = this.checkCustomType(number) ? "customtype" : number;
                msgNode.setImgSrc("private/wf/navigation/" + ImgNumber + ".png");
                msgNode.setHoverImgSrc("private/wf/navigation/" + ImgNumber + "_hover.png");
                msgNode.setMenuSvg(MCNavigationItemSvg.getSvgByMsgType(number));
                msgNodes.add(msgNode);
            }
        }
        Collections.sort(msgNodes, new Comparator<TaskCenterNavigationEntity>(){

            @Override
            public int compare(TaskCenterNavigationEntity node1, TaskCenterNavigationEntity node2) {
                Long nodeId1 = node1.getId();
                Long nodeId2 = node2.getId();
                if (nodeId1 < nodeId2) {
                    return -1;
                }
                if (nodeId1 > nodeId2) {
                    return 1;
                }
                return 0;
            }
        });
        return msgNodes;
    }

    private List<TaskCenterNavigationEntity> serializationTaskCenterNavigationEntitys(List<TaskCenterNavigationEntity> allNodes) {
        if (allNodes == null || allNodes.isEmpty()) {
            return allNodes;
        }
        List<TaskCenterNavigationEntity> roots = allNodes.stream().filter(item -> 0L == item.getParentid()).collect(Collectors.toList());
        List notRoots = (List)CollectionUtils.subtract(allNodes, roots);
        for (TaskCenterNavigationEntity root : roots) {
            root.setChildren(this.findChildren(root, notRoots));
        }
        return roots;
    }

    private List<TaskCenterNavigationEntity> findChildren(TaskCenterNavigationEntity root, List<TaskCenterNavigationEntity> notRoots) {
        ArrayList<TaskCenterNavigationEntity> children = new ArrayList<TaskCenterNavigationEntity>();
        for (TaskCenterNavigationEntity node : notRoots) {
            if (!node.getParentid().equals(root.getId())) continue;
            children.add(node);
        }
        List notChildren = (List)CollectionUtils.subtract(notRoots, children);
        for (TaskCenterNavigationEntity child : children) {
            List<TaskCenterNavigationEntity> tmpChildren = this.findChildren(child, notChildren);
            child.setChildren(tmpChildren);
        }
        return children;
    }

    private String getNavigationMenuNameType() {
        String entityMetaNameType = "metadataTable";
        try {
            QFilter qs = new QFilter("key", "=", (Object)"msg.mcNavigationMenuNameType");
            DynamicObject ret = BusinessDataServiceHelper.loadSingleFromCache((String)"wf_confcenter", (String)"value", (QFilter[])new QFilter[]{qs});
            if (ret != null) {
                entityMetaNameType = ret.getString("value");
            }
        }
        catch (Exception e) {
            logger.info("getNavigationMenuNameType function has exception:" + WfUtils.getExceptionStacktrace(e));
        }
        return entityMetaNameType;
    }

    public static enum MCNavigationItemSvg {
        TOHANDLE("tohandle", "kdfont-daiban"),
        HANDLED("handled", "kdfont-renwu"),
        TOAPPLY("toApply", "kdfont-zaiban"),
        APPLYED("applyed", "kdfont-yibanshenqing"),
        TRANSFER("transfer", "kdfont-hebingtiaozhengchongxiao"),
        DELEGATE("delegate", "kdfont-weituojiaoyi"),
        CUSTOM("custom", "kdfont-wenjianjia2"),
        ALARM("alarm", "kdfont-yujing4"),
        WARNING("warning", "kdfont-yujing"),
        MESSAGE("message", "kdfont-tongzhi"),
        NOTICE("notice", "kdfont-zhaobiaogonggao"),
        ACTIVITY("activity", "kdfont-xiaoxi6"),
        EXTENDTYPE("extendType", " kdfont-xiaoxi6");

        private String number;
        private String svgValue;

        private MCNavigationItemSvg(String number, String svgValue) {
            this.number = number;
            this.svgValue = svgValue;
        }

        public String getNumber() {
            return this.number;
        }

        public String getSvgValue() {
            return this.svgValue;
        }

        public static String getSvgByMsgType(String msgType) {
            MCNavigationItemSvg target = null;
            MCNavigationItemSvg[] values = MCNavigationItemSvg.values();
            for (int i = 0; i < values.length; ++i) {
                if (!values[i].getNumber().equalsIgnoreCase(msgType)) continue;
                target = values[i];
                break;
            }
            if (target == null) {
                target = EXTENDTYPE;
            }
            return target.getSvgValue();
        }
    }
}

