/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.precomputation.PreComputorHelper;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.precomputor.IPreComputorRecord;
import kd.bos.workflow.engine.precomputor.IPreComputorRecordItem;
import kd.bos.workflow.exception.ExceptionUtil;
import kd.bos.workflow.exception.WFErrorCode;

public class GetNextMandatoryNodesCmd
implements Command<List<Map<String, Object>>> {
    protected static final Log logger = LogFactory.getLog(GetNextMandatoryNodesCmd.class);
    protected Long taskId;

    public GetNextMandatoryNodesCmd(Long taskId) {
        this.taskId = taskId;
    }

    @Override
    public List<Map<String, Object>> execute(CommandContext commandContext) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(0);
        logger.debug("Start execute GetNextMandatoryNodesCmd: param taskId:" + this.taskId);
        if (WfUtils.isEmpty(this.taskId)) {
            throw ExceptionUtil.createWFMessageServiceException(null, null, WFErrorCode.taskNotFound(), new Object[0]);
        }
        TaskEntity task = (TaskEntity)commandContext.getTaskEntityManager().findById(this.taskId);
        if (null == task) {
            throw ExceptionUtil.createWFMessageServiceException(null, null, WFErrorCode.taskNotFound(), new Object[0]);
        }
        Long procInstId = task.getProcessInstanceId();
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(task.getProcessDefinitionId(), procInstId);
        String currentNodeId = task.getTaskDefinitionKey();
        ArrayList<String> currentNodeIds = new ArrayList<String>();
        currentNodeIds.add(task.getTaskDefinitionKey());
        logger.debug("execute GetNextMandatoryNodesCmd: param currentNodeId:" + currentNodeId);
        IPreComputorRecord record = PreComputorHelper.getPreComputorRecordByImmediateCalc(procInstId);
        List data = record.getPcrData();
        for (IPreComputorRecordItem node : data) {
            String nodeId = node.getNodeId();
            Boolean normal = node.getIsNormal();
            if (normal.booleanValue() && currentNodeIds.contains(nodeId)) {
                FlowNode flowNode = (FlowNode)bpmnModel.getFlowElement(nodeId);
                currentNodeIds.addAll(node.getNextNodeId());
                if (flowNode.getFork() != null && flowNode.getFork().booleanValue() || flowNode.getJoin() != null && flowNode.getJoin().booleanValue()) break;
                if (currentNodeId.equals(nodeId)) continue;
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("nodeId", node.getNodeId());
                map.put("nodeName", node.getNodeName());
                map.put("nodeType", node.getNodeType());
                map.put("assingee", node.getAssignee());
                map.put("assingeeName", node.getAssigneeName());
                if (flowNode instanceof UserTask) {
                    map.put("extAttrGroup", BpmnModelUtil.extendAttributeGroupConverterToWF(flowNode));
                }
                result.add(map);
                if (flowNode.getControlIntensity() != null && flowNode.getControlIntensity().isMandatory()) {
                    map.put("isMandatory", Boolean.TRUE);
                    break;
                }
                map.put("isMandatory", Boolean.FALSE);
                continue;
            }
            logger.debug(String.format("normal:%s nodeId:%s", normal, nodeId));
            if (normal.booleanValue()) continue;
            logger.debug(node.getExceptionMsg());
        }
        return result;
    }
}

