/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.impl.cmd.task.GetNextUseableUserTaskNodeCmd;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandConfig;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.CommandExecutor;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.task.TaskInfo;

public class GetNextNodeByBusinesskeyCmd
implements Command<List<Map<String, Object>>>,
Serializable {
    private static final long serialVersionUID = -8439229734984154192L;
    private Log logger = LogFactory.getLog(this.getClass());
    private String businesskey;

    public GetNextNodeByBusinesskeyCmd(String businesskey) {
        this.businesskey = businesskey;
    }

    @Override
    public List<Map<String, Object>> execute(CommandContext commandContext) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        List<TaskEntity> tasks = commandContext.getTaskEntityManager().findTasksByBusinessKey(this.businesskey);
        this.logger.debug("GetNextNodeByBusinesskeyCmd : tasks\u6570\u91cf\uff1a" + tasks.size());
        CommandExecutor commandExecutor = commandContext.getProcessEngineConfiguration().getCommandExecutor();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("isPreAssign", Boolean.TRUE);
        variables.put("auditType", "approve");
        variables.put("auditNumber", "Consent");
        for (TaskEntity t : tasks) {
            CommandConfig commandConfig = commandExecutor.getDefaultConfig().transactionRequiresNew();
            result.addAll((Collection<Map<String, Object>>)commandExecutor.execute(commandConfig, new GetNextUseableUserTaskNodeCmd(this.businesskey, (TaskInfo)t, variables)));
        }
        return result;
    }
}

