/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.AutoTask;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.bpmn.model.EndEvent;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.Gateway;
import kd.bos.workflow.bpmn.model.NotifyTask;
import kd.bos.workflow.bpmn.model.ParticipatantModel;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.SelectNodesModel;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.bpmn.model.StartEvent;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.bpmn.model.YunzhijiaTask;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.bpmn.behavior.TaskBehaviorUtil;
import kd.bos.workflow.engine.impl.bpmn.behavior.UserTaskActivityBehavior;
import kd.bos.workflow.engine.impl.bpmn.behavior.WarpGatewayActivityBehavior;
import kd.bos.workflow.engine.impl.bpmn.behavior.YunzhijiaNotifyActivityBehavior;
import kd.bos.workflow.engine.impl.bpmn.behavior.YunzhijiaParallelMultiInstanceBehavior;
import kd.bos.workflow.engine.impl.bpmn.behavior.YunzhijiaSequentialMultiInstanceBehavior;
import kd.bos.workflow.engine.impl.calculator.ParticipantCalculator;
import kd.bos.workflow.engine.impl.cmd.model.GetParticipantDisplayValue;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.monitor.worktransfer.WorksTransferLogEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.PreComputatorExecutionEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ParticipantHelper;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.condition.ConditionUtil;

public class GetNextNodeWhenRejectToParentProcessCmd
implements Command<List<Map<String, Object>>>,
Serializable {
    private static final long serialVersionUID = -178911304515869637L;
    private final Log logger = LogFactory.getLog(this.getClass());
    private ExecutionEntity superExecution;
    private ExecutionEntity execution;
    private CallActivity callActivity;
    private Process process;
    private BpmnModel bpmnModel;
    private String decisionScene;
    private Map<String, Object> variables = new HashMap<String, Object>();
    private Map<String, TaskEntity> taskEntityMap = new HashMap<String, TaskEntity>();
    private static final String TYPE = "type";
    private static final String REASON_TYPE_HASNOTREJECTNODE = "hasNotRejectNode";
    private static final String REASON_TYPE_NOPERSION = "noPersion";
    private static final String REASON_TYPE_SKIPNODE = "skipNode";
    private static final String REASON_TYPE_AUTOAUDITNODE = "autoAuditNode";
    private static final String REASON = "reason";
    private static final String NEXTNODEID = "nextNodeId";
    private static final String NEXTNODE = "nextNode";
    private static final String THROWEXCEPTION = "throwException";
    private static final String BOS_USER = "bos_user";
    private static final String SSCAPPROVE = "SSCApprove";
    private static final String ISREJECTTOPARENTPROCESS = "isRejectToParentProcess";
    private static final String PARENTPROCESSINSTANCEID = "parentProcessInstanceId";

    public GetNextNodeWhenRejectToParentProcessCmd(ExecutionEntity superExecution, String decisionScene, Map<String, Object> variables) {
        this.superExecution = superExecution;
        this.decisionScene = decisionScene;
        this.variables = variables;
    }

    @Override
    public List<Map<String, Object>> execute(CommandContext commandContext) {
        List<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        if (this.superExecution == null || StringUtils.isEmpty((CharSequence)this.decisionScene)) {
            this.logger.debug("\u6ca1\u6709\u627e\u5230\u53ef\u7528\u6267\u884c\u5b9e\u4f8b\u6216\u6ca1\u6709\u627e\u5230\u5b50\u6d41\u7a0b\u5b9e\u4f8b\u4e2d\u9a73\u56de\u81f3\u7236\u6d41\u7a0b\u7684\u51b3\u7b56\u9879");
            return result;
        }
        commandContext.setGetNextNodeCmd(true);
        this.initData(commandContext);
        List<SelectNodesModel> rejectOptions = this.getRejectOptionsByDecisionScene(commandContext);
        ArrayList<FlowNode> usableUserTaskNodes = new ArrayList<FlowNode>(rejectOptions.size());
        HashMap<String, Object> unusableTypeAndReason = new HashMap<String, Object>(rejectOptions.size());
        this.getUsableUserTaskNodesResult(commandContext, rejectOptions, usableUserTaskNodes, unusableTypeAndReason);
        if (usableUserTaskNodes.isEmpty()) {
            this.setRejectToParentProcessVariables(unusableTypeAndReason);
            result.add(unusableTypeAndReason);
            return result;
        }
        result = this.getUsersAndFormatData(commandContext, usableUserTaskNodes);
        return result;
    }

    private void setRejectToParentProcessVariables(Map<String, Object> unusableTypeAndReason) {
        unusableTypeAndReason.put(ISREJECTTOPARENTPROCESS, Boolean.TRUE);
        unusableTypeAndReason.put(PARENTPROCESSINSTANCEID, this.superExecution.getProcessInstanceId());
    }

    private void getUsableUserTaskNodesResult(CommandContext commandContext, List<SelectNodesModel> rejectOptions, List<FlowNode> usableUserTaskNodes, Map<String, Object> unusableTypeAndReason) {
        if (WfUtils.isEmptyForCollection(rejectOptions)) {
            unusableTypeAndReason.put(TYPE, REASON_TYPE_HASNOTREJECTNODE);
            unusableTypeAndReason.put(REASON, ResManager.loadKDString((String)"\u6ca1\u6709\u8ba1\u7b97\u51fa\u53ef\u9a73\u56de\u81f3\u7236\u6d41\u7a0b\u7684\u8282\u70b9\u3002", (String)"GetNextNodeWhenRejectToParentProcessCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]));
            this.logger.debug("\u6ca1\u6709\u8ba1\u7b97\u51fa\u53ef\u9a73\u56de\u81f3\u7236\u6d41\u7a0b\u7684\u8282\u70b9\u3002");
            return;
        }
        for (int i = rejectOptions.size() - 1; i >= 0; --i) {
            String type;
            Object reason;
            SelectNodesModel rejectOption = rejectOptions.get(i);
            FlowNode nextFlowNode = this.process.findFlowElementsOfTypeAndId(FlowNode.class, rejectOption.getItemId(), false);
            if (nextFlowNode == null || usableUserTaskNodes.contains(nextFlowNode)) continue;
            if (nextFlowNode instanceof AutoTask) {
                usableUserTaskNodes.add(0, nextFlowNode);
                continue;
            }
            if (nextFlowNode instanceof CallActivity) {
                CallActivity nextCallActivity = (CallActivity)nextFlowNode;
                this.execution.setCurrentFlowElement(nextCallActivity);
                this.rejectToCallActivity(usableUserTaskNodes, unusableTypeAndReason, nextCallActivity);
                continue;
            }
            this.getNodeTask(nextFlowNode);
            this.execution.setCurrentFlowElement(nextFlowNode);
            if (this.isSkipNodeWithoutPart(commandContext, nextFlowNode)) {
                reason = unusableTypeAndReason.get(REASON);
                reason = reason == null ? String.format(ResManager.loadKDString((String)"%1$s\uff08\u65e0\u53c2\u4e0e\u4eba)", (String)"GetNextUseableUserTaskNodeCmd_3", (String)"bos-wf-engine", (Object[])new Object[0]), nextFlowNode.getName()) : String.format(ResManager.loadKDString((String)"%1$s%2$s\uff08\u65e0\u53c2\u4e0e\u4eba\uff09", (String)"GetNextUseableUserTaskNodeCmd_4", (String)"bos-wf-engine", (Object[])new Object[0]), reason, nextFlowNode.getName());
                unusableTypeAndReason.put(TYPE, REASON_TYPE_NOPERSION);
                unusableTypeAndReason.put(REASON, reason);
                unusableTypeAndReason.put(NEXTNODEID, nextFlowNode.getId());
                continue;
            }
            if (nextFlowNode instanceof UserTask && this.isSkipTask((UserTask)nextFlowNode)) {
                reason = unusableTypeAndReason.get(REASON);
                type = (String)unusableTypeAndReason.get(TYPE);
                if (reason == null) {
                    type = REASON_TYPE_SKIPNODE;
                    reason = String.format(ResManager.loadKDString((String)"%1$s\uff08\u8df3\u8fc7\uff09", (String)"GetNextUseableUserTaskNodeCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]), nextFlowNode.getName());
                } else {
                    type = type + "," + REASON_TYPE_SKIPNODE;
                    reason = String.format(ResManager.loadKDString((String)"%1$s%2$s\uff08\u8df3\u8fc7\uff09", (String)"GetNextUseableUserTaskNodeCmd_11", (String)"bos-wf-engine", (Object[])new Object[0]), reason, nextFlowNode.getName());
                }
                unusableTypeAndReason.put(REASON, reason);
                unusableTypeAndReason.put(TYPE, type);
                unusableTypeAndReason.put(NEXTNODEID, nextFlowNode.getId());
                continue;
            }
            if (nextFlowNode instanceof AuditTask && this.isAutoAuditTask((AuditTask)nextFlowNode)) {
                reason = unusableTypeAndReason.get(REASON);
                type = (String)unusableTypeAndReason.get(TYPE);
                if (reason == null) {
                    type = REASON_TYPE_AUTOAUDITNODE;
                    reason = String.format(ResManager.loadKDString((String)"%1$s\uff08\u81ea\u52a8\u5ba1\u6279\uff09", (String)"GetNextUseableUserTaskNodeCmd_2", (String)"bos-wf-engine", (Object[])new Object[0]), nextFlowNode.getName());
                } else {
                    type = type + "," + REASON_TYPE_AUTOAUDITNODE;
                    reason = String.format(ResManager.loadKDString((String)"%1$s%2$s\uff08\u81ea\u52a8\u5ba1\u6279\uff09", (String)"GetNextUseableUserTaskNodeCmd_12", (String)"bos-wf-engine", (Object[])new Object[0]), reason, nextFlowNode.getName());
                }
                unusableTypeAndReason.put(TYPE, type);
                unusableTypeAndReason.put(REASON, reason);
                unusableTypeAndReason.put(NEXTNODEID, nextFlowNode.getId());
                continue;
            }
            usableUserTaskNodes.add(0, nextFlowNode);
        }
    }

    private void rejectToCallActivity(List<FlowNode> finalUserTaskNodes, Map<String, Object> unusableTypeAndReason, CallActivity nextCallActivity) {
        if (nextCallActivity == null) {
            return;
        }
        if (this.isSkipTaskForCallActivity(nextCallActivity, this.execution)) {
            Object reason = unusableTypeAndReason.get(REASON);
            String type = (String)unusableTypeAndReason.get(TYPE);
            if (reason == null) {
                type = REASON_TYPE_SKIPNODE;
                reason = String.format(ResManager.loadKDString((String)"%1$s\uff08\u8df3\u8fc7\uff09", (String)"GetNextUseableUserTaskNodeCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]), nextCallActivity.getName());
            } else {
                type = type + "," + REASON_TYPE_SKIPNODE;
                reason = String.format(ResManager.loadKDString((String)"%1$s%2$s\uff08\u8df3\u8fc7\uff09", (String)"GetNextUseableUserTaskNodeCmd_11", (String)"bos-wf-engine", (Object[])new Object[0]), reason, nextCallActivity.getName());
            }
            unusableTypeAndReason.put(REASON, reason);
            unusableTypeAndReason.put(TYPE, type);
            unusableTypeAndReason.put(NEXTNODEID, nextCallActivity.getId());
        } else {
            finalUserTaskNodes.add(0, nextCallActivity);
        }
    }

    private boolean isSkipTaskForCallActivity(CallActivity nextCallActivity, ExecutionEntity execution) {
        String key = String.format("%s_%s", this.callActivity.getId(), "rejectToForkInnerAndSkip");
        String rejectInnerInfo = (String)execution.getProcessInstance().getVariable(key);
        if (WfUtils.isNotEmpty(rejectInnerInfo)) {
            String[] nodes = rejectInnerInfo.split("\\-");
            if (!nextCallActivity.getId().equals(nodes[1])) {
                return true;
            }
        }
        if (ConditionUtil.isConditionAvailable(nextCallActivity.getSkipCondition())) {
            if (WfUtils.isNotEmpty(nextCallActivity.getSkipCondition().getPlugin())) {
                return ConditionUtil.hasTrueCondition(nextCallActivity.getSkipCondition(), (VariableScope)execution, "");
            }
            return ConditionUtil.hasTrueCondition(nextCallActivity.getSkipCondition().getExpression(), (VariableScope)execution, null);
        }
        return false;
    }

    private TaskEntity getNodeTask(FlowNode flowNode) {
        if (this.taskEntityMap.containsKey(flowNode.getId())) {
            return this.taskEntityMap.get(flowNode.getId());
        }
        Object behavior = flowNode.getBehavior();
        if (behavior instanceof WarpGatewayActivityBehavior || behavior instanceof YunzhijiaNotifyActivityBehavior) {
            return null;
        }
        UserTask userTask = null;
        if (behavior instanceof UserTaskActivityBehavior) {
            userTask = (UserTask)flowNode;
        } else if (behavior instanceof YunzhijiaParallelMultiInstanceBehavior || behavior instanceof YunzhijiaSequentialMultiInstanceBehavior) {
            userTask = (YunzhijiaTask)flowNode;
        }
        if (userTask == null) {
            return null;
        }
        this.execution.setTransientVariable(THROWEXCEPTION, this.variables.get(THROWEXCEPTION));
        TaskEntity task = TaskBehaviorUtil.buildTaskEntityWithParticipant(this.execution, userTask, Collections.emptyMap(), Collections.emptyMap(), "", Collections.emptyMap());
        this.taskEntityMap.put(flowNode.getId(), task);
        task.setExecution(this.execution);
        String uid = (String)task.getTransientVariable("currentParticipant");
        if (WfUtils.isNotEmpty(uid)) {
            ArrayList<Long> userIds = new ArrayList<Long>();
            for (String u : uid.split("\\,")) {
                if (!WfUtils.isNotEmpty(u)) continue;
                userIds.add(Long.valueOf(u));
            }
            this.execution.setVariable("currentApprover", userIds);
        } else {
            this.execution.setVariable("currentApprover", new ArrayList());
        }
        return task;
    }

    private boolean isSkipNodeWithoutPart(CommandContext commandContext, FlowNode flowNode) {
        UserTask userTask;
        if (flowNode instanceof UserTask && (userTask = (UserTask)flowNode).getParticipant() != null && userTask.getParticipant().isSkipNodeWithoutPart()) {
            List<Long> userIds = this.getNodeParticipants(commandContext, userTask.getId());
            return userIds.isEmpty();
        }
        return false;
    }

    private List<Long> getNodeParticipants(CommandContext commandContext, String nodeId) {
        List<Long> userIds = new ArrayList<Long>();
        TaskEntity nextTask = this.taskEntityMap.get(nodeId);
        if (nextTask == null) {
            ParticipantCalculator participantCalculator = commandContext.getProcessEngineConfiguration().getParticipantCalculator();
            userIds = participantCalculator.getNextTaskUsers(this.execution.getProcessDefinitionId(), this.execution.getProcessInstanceId(), nodeId, this.execution.getBusinessKey(), this.execution, Collections.emptyMap(), Collections.emptyMap(), "", Collections.emptyMap());
        } else {
            String currentParticipants = (String)nextTask.getTransientVariable("currentParticipant");
            if (StringUtils.isNotEmpty((CharSequence)currentParticipants)) {
                Collection<Long> col = WfUtils.stringToCollection(currentParticipants, "\\,");
                userIds.addAll(col);
            }
        }
        return userIds;
    }

    private boolean isSkipTask(UserTask userTask) {
        String key = String.format("%s_%s", this.callActivity.getId(), "rejectToForkInnerAndSkip");
        String rejectInnerInfo = (String)this.execution.getProcessInstance().getVariable(key);
        if (WfUtils.isNotEmpty(rejectInnerInfo)) {
            String[] nodes = rejectInnerInfo.split("\\-");
            if (!(userTask.getId().equals(nodes[1]) || this.variables != null && "reject".equals(this.variables.get("auditType")))) {
                return true;
            }
        }
        if (ConditionUtil.isConditionAvailable(userTask.getSkipCondition())) {
            TaskEntity task = this.getNodeTask(userTask);
            if (task == null) {
                return false;
            }
            if (WfUtils.isNotEmpty(userTask.getSkipCondition().getPlugin())) {
                return ConditionUtil.hasTrueCondition(userTask.getSkipCondition(), (VariableScope)task, "");
            }
            return ConditionUtil.hasTrueCondition(userTask.getSkipCondition().getExpression(), (VariableScope)task, null);
        }
        return false;
    }

    private boolean isAutoAuditTask(AuditTask auditTask) {
        TaskEntity task = this.getNodeTask(auditTask);
        if (auditTask.getAutoAudit() != null && auditTask.getAutoAudit().isAutoAuditWhenMatch() && auditTask.getAutoAudit().getAutoAuditCondition() != null && WfUtils.isNotEmpty(auditTask.getAutoAudit().getAutoAuditCondition().getExpression()) && WfUtils.isNotEmpty(auditTask.getAutoAudit().getAutoDecisionWhenMatch())) {
            if (task == null) {
                return false;
            }
            if (ConditionUtil.hasTrueCondition(auditTask.getAutoAudit().getAutoAuditCondition().getExpression(), (VariableScope)task, null)) {
                return true;
            }
        }
        if (auditTask.getAutoAudit() != null && auditTask.getAutoAudit().isAutoAuditWhenMatch() && auditTask.getAutoAudit().getAutoAuditCondition() != null && WfUtils.isNotEmpty(auditTask.getAutoAudit().getAutoAuditCondition().getPlugin())) {
            return ConditionUtil.hasTrueCondition(auditTask.getAutoAudit().getAutoAuditCondition(), (VariableScope)task, "");
        }
        return false;
    }

    private List<Map<String, Object>> getUsersAndFormatData(CommandContext commandContext, List<FlowNode> usableUserTaskNodes) {
        ArrayList<Map<String, Object>> formatResult = new ArrayList<Map<String, Object>>();
        for (FlowNode flowNode : usableUserTaskNodes) {
            if (flowNode instanceof EndEvent || flowNode instanceof AutoTask || flowNode instanceof NotifyTask || flowNode instanceof Gateway || flowNode instanceof CallActivity) {
                HashMap<String, FlowNode> map = new HashMap<String, FlowNode>(1);
                map.put(NEXTNODE, flowNode);
                formatResult.add(map);
                continue;
            }
            if (!(flowNode instanceof UserTask)) continue;
            UserTask userTask = (UserTask)flowNode;
            List<Object> userIds = new ArrayList(2);
            ArrayList<Long> userIdsForHis = new ArrayList<Long>(2);
            List<Long> userIdsForNow = this.getNodeParticipants(commandContext, userTask.getId());
            List<HistoricActivityInstanceEntity> historicActivityInstanceEntities = ParticipantHelper.getHisActForParticipantFromHiActivity(commandContext, this.execution.getProcessInstanceId(), flowNode.getId());
            HistoricActivityInstanceEntity hiActivity = ParticipantHelper.getUserIdsAndTaskIdsForParticipantFromHiActivity(historicActivityInstanceEntities);
            if (hiActivity != null) {
                userIdsForHis.add(hiActivity.getAssigneeId());
            }
            if (userIdsForHis.isEmpty() || "YunzhijiaTask".equals(flowNode.getType())) {
                userIds = userIdsForNow;
            } else if (userIdsForNow.isEmpty()) {
                userIds = userIdsForHis;
            } else if (hiActivity != null) {
                boolean isOperationChangeHisNodeAssignee = commandContext.getTaskHandleLogEntityManager().isOperationChangeHisNodeAssignee(hiActivity.getTaskId(), hiActivity.getAssigneeId());
                userIds = userIdsForNow.containsAll(userIdsForHis) || isOperationChangeHisNodeAssignee ? userIdsForHis : userIdsForNow;
            }
            this.judgeTransferUser(commandContext, flowNode, userIds);
            DynamicObjectCollection users = this.queryUser(userIds);
            HashMap<String, Object> map = new HashMap<String, Object>(userIds.size() + 2);
            map.put(NEXTNODE, userTask);
            if (!SSCAPPROVE.equals(flowNode.getType())) {
                map.put("users", users);
            }
            String entityNumber = userTask.getEntityNumber();
            String displayInfoStr = "";
            ParticipatantModel participant = userTask.getParticipant();
            if (participant != null) {
                displayInfoStr = participant.getDisplayInfo();
            }
            DynamicObject[] userArray = BusinessDataServiceHelper.load((String)BOS_USER, (String)"id,name,entryentity.position,entryentity.dpt,simplepinyin,fullpinyin,number,usertype,phone,email", (QFilter[])new QFilter[]{new QFilter("id", "in", userIds)});
            DynamicObjectCollection userCollection = new DynamicObjectCollection();
            for (DynamicObject user : userArray) {
                userCollection.add((Object)user);
            }
            if (WfConfigurationUtil.disablePreComputeParticipantPosition()) {
                if (WfUtils.isNotEmptyForCollection((Collection)users)) {
                    for (DynamicObject user : users) {
                        map.put(String.valueOf(user.getLong("id")), user.get("name"));
                    }
                }
            } else {
                LocaleString displayInfo = new LocaleString();
                if (WfUtils.isNotEmpty(displayInfoStr)) {
                    displayInfo = BpmnModelUtil.getMultiLangFieldValue(this.execution.getProcessInstanceId(), String.format("%s.participant.displayInfo", flowNode.getId()), displayInfoStr);
                }
                Object formatMap = new GetParticipantDisplayValue(userCollection, this.execution, (ILocaleString)displayInfo, entityNumber, this.execution.getBusinessKey()).execute(commandContext);
                for (Map.Entry format : formatMap.entrySet()) {
                    map.put(String.valueOf(format.getKey()), format.getValue());
                }
            }
            formatResult.add(map);
        }
        formatResult.forEach(this::setRejectToParentProcessVariables);
        this.logger.debug("getNextNodeWhenRejectToParentProcessCmd format Result:" + formatResult);
        return formatResult;
    }

    private void judgeTransferUser(CommandContext commandContext, FlowNode flowNode, List<Long> userIds) {
        try {
            if (this.isFirstNodeByModel(flowNode) && "UserTask".equalsIgnoreCase(flowNode.getType())) {
                Long processInstanceId = this.execution.getRootProcessInstanceId();
                List<WorksTransferLogEntity> entities = commandContext.getWorksTransferLogEntityManager().getWorksTransferLog(processInstanceId);
                if (WfUtils.isEmptyForCollection(entities)) {
                    return;
                }
                if (userIds.isEmpty()) {
                    userIds.remove(entities.get(0).getOrigAuditorId());
                    userIds.add(Long.parseLong(entities.get(0).getNewAuditorId()));
                } else {
                    ArrayList<Long> userIdsClone = new ArrayList<Long>(userIds.size());
                    userIdsClone.addAll(userIds);
                    block2: for (Long userId : userIdsClone) {
                        for (WorksTransferLogEntity entity : entities) {
                            if (!userId.equals(entity.getOrigAuditorId())) continue;
                            userIds.remove(userId);
                            userIds.add(Long.parseLong(entities.get(0).getNewAuditorId()));
                            continue block2;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error("GetNextNodeWhenRejectToParentProcessCmd.judgeTransferUser is error,errorInfo is :" + WfUtils.getExceptionStacktrace(e));
        }
    }

    private boolean isFirstNodeByModel(FlowNode flowNode) {
        boolean first = false;
        if (flowNode.getIncomingFlows() != null) {
            List<SequenceFlow> tmp = flowNode.getIncomingFlows();
            for (SequenceFlow seq : tmp) {
                if (seq == null || seq.isDynamic()) continue;
                if (seq.getSourceFlowElement() instanceof StartEvent) {
                    first = true;
                    continue;
                }
                first = false;
                break;
            }
        }
        return first;
    }

    private DynamicObjectCollection queryUser(List<Long> userIds) {
        ORM orm = ORM.create();
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", userIds)};
        DynamicObjectCollection resultDisorders = orm.query(BOS_USER, "id,name", qFilters);
        DynamicObjectCollection resultOrderlys = new DynamicObjectCollection();
        block0: for (Long userId : userIds) {
            for (DynamicObject resultDisorder : resultDisorders) {
                if (!userId.equals(resultDisorder.getLong("id"))) continue;
                resultOrderlys.add((Object)resultDisorder);
                continue block0;
            }
        }
        return resultOrderlys;
    }

    private void initData(CommandContext commandContext) {
        if (this.superExecution.getCurrentFlowElement() instanceof CallActivity) {
            this.callActivity = (CallActivity)this.superExecution.getCurrentFlowElement();
        }
        Long processDefinitionId = this.superExecution.getProcessDefinitionId();
        Long processInstanceId = this.superExecution.getProcessInstanceId();
        this.bpmnModel = ProcessDefinitionUtil.getBpmnModel(processDefinitionId, processInstanceId);
        if (this.bpmnModel != null) {
            this.process = this.bpmnModel.getMainProcess();
        }
        this.execution = this.superExecution instanceof ExecutionEntityImpl ? new PreComputatorExecutionEntityImpl((ExecutionEntityImpl)this.superExecution) : new PreComputatorExecutionEntityImpl((PreComputatorExecutionEntityImpl)this.superExecution);
        this.execution.setTransientVariable("isPreComputator", true);
        Object billInfo = this.variables.get("billInfo");
        if (billInfo instanceof DynamicObject) {
            ((PreComputatorExecutionEntityImpl)this.execution).setTransientBill((DynamicObject)billInfo);
        }
        this.execution.setTransientVariable("scene", "getNextNode");
    }

    private List<SelectNodesModel> getRejectOptionsByDecisionScene(CommandContext commandContext) {
        ArrayList<SelectNodesModel> rejectOptions = new ArrayList<SelectNodesModel>();
        if ("rejectToParentProcEditNode".equals(this.decisionScene)) {
            UserTask userTask = BpmnModelUtil.getFirstUserTask(this.process);
            if (userTask != null) {
                SelectNodesModel selectNodesModel = this.createOneSelectNodesModel(userTask.getId(), userTask.getName());
                rejectOptions.add(selectNodesModel);
            }
        } else if ("rejectToParentProcPreNode".equals(this.decisionScene)) {
            List<Object> nodes = new ArrayList();
            try {
                nodes = BpmnModelUtil.getRejectNodes(this.bpmnModel, this.callActivity.getId());
                nodes = this.filterOptionalNodes(nodes);
            }
            catch (Exception e) {
                this.logger.debug("get reject nodes from bpmnModel failed!" + WfUtils.getExceptionStacktrace(e));
            }
            nodes.forEach(flowElement -> rejectOptions.add(this.createOneSelectNodesModel(flowElement.getId(), flowElement.getName())));
        }
        return rejectOptions;
    }

    private SelectNodesModel createOneSelectNodesModel(String id, String name) {
        SelectNodesModel selectNodesModel = new SelectNodesModel();
        selectNodesModel.setItemId(id);
        selectNodesModel.setName(name);
        return selectNodesModel;
    }

    private List<FlowElement> filterOptionalNodes(List<FlowElement> nodes) {
        ArrayList<FlowElement> filterNodes = new ArrayList<FlowElement>(nodes.size());
        for (FlowElement node : nodes) {
            if (node instanceof StartEvent || node instanceof EndEvent || node instanceof NotifyTask) continue;
            filterNodes.add(node);
        }
        return filterNodes;
    }
}

