/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.util.StringUtils;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.DecisionOption;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.ParticipantRangeSettingModel;
import kd.bos.workflow.bpmn.model.ParticipatantModel;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.RuntimeService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.GetBpmnModelCmd;
import kd.bos.workflow.engine.impl.cmd.task.GetNextUseableUserTaskNodeCmd;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.ParticipantModelEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.task.TaskInfo;

public class GetNextUseableUserAndScopeCmd
implements Command<Map<String, Map<String, List<Long>>>>,
Serializable {
    private static final long serialVersionUID = -7784787607614497987L;
    private static final String USEABLE_USER = "useableUser";
    private static final String WHITE_LIST = "whiteList";
    private static final String BLACK_LIST = "blackList";
    private static final String MUST_LIST = "mustList";
    private static final String IS_PRE_ASSIGN = "isPreAssign";
    private static final String AUDIT_TYPE = "auditType";
    private static final String AUDIT_NUMBER = "auditNumber";
    private static final String USERS = "users";
    private static final String NEXT_NODE = "nextNode";
    private static final String APPROVE = "approve";
    private Long taskId;
    private String auditNumber;

    public GetNextUseableUserAndScopeCmd(Long taskId, String auditNumber) {
        this.taskId = taskId;
        this.auditNumber = auditNumber;
    }

    @Override
    public Map<String, Map<String, List<Long>>> execute(CommandContext commandContext) {
        HashMap<String, Map<String, List<Long>>> result = new HashMap<String, Map<String, List<Long>>>();
        FlowElement flowElement = this.getModelByTaskId(commandContext);
        if (!(flowElement instanceof UserTask)) {
            return result;
        }
        UserTask currNodeModel = (UserTask)flowElement;
        List<DecisionOption> decisionOptions = currNodeModel.getDecisionOptions();
        String auditType = this.getAuditType(this.auditNumber, decisionOptions);
        if (!APPROVE.equals(auditType)) {
            return result;
        }
        this.getNextNodePartInfo(commandContext, result, currNodeModel, auditType);
        return result;
    }

    private FlowElement getModelByTaskId(CommandContext commandContext) {
        TaskEntity taskEntity = (TaskEntity)commandContext.getTaskEntityManager().findById(this.taskId);
        if (taskEntity == null) {
            return null;
        }
        long procDefId = taskEntity.getProcessDefinitionId();
        long procInstId = taskEntity.getProcessInstanceId();
        String activityId = taskEntity.getTaskDefinitionKey();
        BpmnModel bpmnModel = new GetBpmnModelCmd(procDefId, procInstId).execute(commandContext);
        if (bpmnModel == null) {
            return null;
        }
        return bpmnModel.getFlowElement(activityId);
    }

    private void getNextNodePartInfo(CommandContext commandContext, Map<String, Map<String, List<Long>>> result, UserTask userTask, String auditType) {
        TaskInfo taskInfo = (TaskInfo)commandContext.getTaskEntityManager().findById(this.taskId);
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put(IS_PRE_ASSIGN, true);
        variables.put(AUDIT_TYPE, auditType);
        variables.put(AUDIT_NUMBER, this.auditNumber);
        Object nextNodeInfos = new GetNextUseableUserTaskNodeCmd(userTask, taskInfo, variables).execute(commandContext);
        if (WfUtils.isEmptyForCollection((Collection)nextNodeInfos)) {
            return;
        }
        Iterator iterator = nextNodeInfos.iterator();
        while (iterator.hasNext()) {
            Map nextNodeInfo = (Map)iterator.next();
            Object userObj = nextNodeInfo.get(USERS);
            Object nextNodeObj = nextNodeInfo.get(NEXT_NODE);
            if (!(userObj instanceof DynamicObjectCollection) || !(nextNodeObj instanceof UserTask)) continue;
            DynamicObjectCollection dCollection = (DynamicObjectCollection)userObj;
            UserTask nextNodeModel = (UserTask)nextNodeObj;
            HashMap<String, List<Long>> usersMap = new HashMap<String, List<Long>>();
            ArrayList<Long> useableUsers = new ArrayList<Long>(16);
            this.getUseableUsers(useableUsers, dCollection);
            usersMap.put(USEABLE_USER, useableUsers);
            this.getUseableScope(nextNodeModel, commandContext, usersMap);
            result.put(nextNodeModel.getId(), usersMap);
        }
    }

    private void getUseableUsers(List<Long> useableUsers, DynamicObjectCollection dCollection) {
        for (DynamicObject dObject : dCollection) {
            long userId = (Long)dObject.get("id");
            useableUsers.add(userId);
        }
    }

    private void getUseableScope(UserTask nextNodeModel, CommandContext commandContext, Map<String, List<Long>> usersMap) {
        List<ParticipantModelEntityImpl> participantBlackList;
        if (nextNodeModel == null) {
            return;
        }
        ParticipatantModel participant = nextNodeModel.getParticipant();
        if (!participant.isPersonrangeformanual()) {
            return;
        }
        ParticipantRangeSettingModel setting = nextNodeModel.getParticipantRangeSetting();
        if (setting == null) {
            return;
        }
        RuntimeService runtimeService = WfUtils.getWfService().getRuntimeService();
        TaskEntity task = (TaskEntity)commandContext.getTaskEntityManager().findById(this.taskId);
        ExecutionEntity variableScope = task.getExecution();
        List<ParticipantModelEntityImpl> participantAllow = setting.getParticipantAllow();
        if (WfUtils.isEmptyForCollection(participantAllow)) {
            return;
        }
        String businessKey = task.getBusinessKey();
        List<Long> whiteList = runtimeService.getUserIdsByCalculate(businessKey, variableScope, participantAllow);
        usersMap.put(WHITE_LIST, whiteList);
        String nodeType = nextNodeModel.getType();
        if ("YunzhijiaTask".equals(nodeType)) {
            ArrayList<ParticipantModelEntityImpl> participantAllowForRequired = new ArrayList<ParticipantModelEntityImpl>();
            for (ParticipantModelEntityImpl entity : participantAllow) {
                Boolean required = entity.getRequired();
                if (null == required || !required.booleanValue()) continue;
                participantAllowForRequired.add(entity);
            }
            if (WfUtils.isNotEmptyForCollection(participantAllowForRequired)) {
                List<Long> mustList = runtimeService.getUserIdsByCalculate(businessKey, variableScope, participantAllowForRequired);
                usersMap.put(MUST_LIST, mustList);
            }
        }
        if (WfUtils.isNotEmptyForCollection(participantBlackList = setting.getParticipantBlackList())) {
            List<Long> blackList = runtimeService.getUserIdsByCalculate(businessKey, variableScope, participantBlackList);
            usersMap.put(BLACK_LIST, blackList);
        }
    }

    private String getAuditType(String auditNumber, List<DecisionOption> decisionOptions) {
        if (WfUtils.isEmptyForCollection(decisionOptions)) {
            return StringUtils.getEmpty();
        }
        for (DecisionOption decisionOption : decisionOptions) {
            String number = decisionOption.getNumber();
            if (number == null || !number.equals(auditNumber)) continue;
            return decisionOption.getAuditType();
        }
        return StringUtils.getEmpty();
    }
}

