/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.model.Activity;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.DecisionOption;
import kd.bos.workflow.bpmn.model.EndEvent;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.ParticipatantModel;
import kd.bos.workflow.bpmn.model.SelectNodesModel;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.bpmn.model.Variable;
import kd.bos.workflow.bpmn.model.YunzhijiaTask;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.Expression;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.cmd.startup.BusinessModelVariableScope;
import kd.bos.workflow.engine.impl.cmd.task.GetNextUseableUserTaskNodeCmd;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.el.IBusinessModel;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.ParticipantModelEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.TaskHelper;
import kd.bos.workflow.engine.impl.util.condition.ConditionUtil;
import kd.bos.workflow.engine.task.TaskInfo;
import kd.bos.workflow.exception.WFErrorCode;

public class GetNextUseableUserTaskNodeForProcessStartCmd
extends GetNextUseableUserTaskNodeCmd
implements Command<List<Map<String, Object>>>,
Serializable {
    private static final long serialVersionUID = 2486837981335247483L;
    private final Log log = LogFactory.getLog(this.getClass());
    protected DynamicObject model;
    private static final String GETNEXTUSEABLEUSERTASKNODEFORPROCESSSTARTCMD_1 = "GetNextUseableUserTaskNodeForProcessStartCmd_1";

    public GetNextUseableUserTaskNodeForProcessStartCmd(UserTask userTask, Map<String, Object> variables, DynamicObject model, BpmnModel bpmnModel, TaskInfo task) {
        super(userTask, null, null, variables);
        this.taskInfo = task;
        this.model = model;
        this.bpmnModel = bpmnModel;
    }

    @Override
    public List<Map<String, Object>> execute(CommandContext commandContext) {
        UserTask ut;
        TaskEntity task;
        ArrayList<Map<String, Object>> list = new ArrayList();
        commandContext.setGetNextNodeCmd(true);
        commandContext.setParsedBusinessObject(this.model);
        this.process = this.bpmnModel.getMainProcess();
        this.participantCalculator = commandContext.getProcessEngineConfiguration().getParticipantCalculator();
        if (null != this.currentNode) {
            this.lastNodId = this.currentNode.getId();
            this.nodeIdMapExecutionType.put(this.currentNode.getId(), "byHand");
        }
        if (WfUtils.isNotEmpty(this.lastNodId)) {
            this.lastAssign = (String)this.nodeIdMapAgreePersonId.get(this.lastNodId);
        }
        List<FlowNode> finalUserTaskNodes = new ArrayList<FlowNode>();
        BusinessModelVariableScope variableScope = new BusinessModelVariableScope(this.model);
        boolean isBackRejectedActivity = false;
        if (null != this.taskInfo && "dismissed".equals((task = (TaskEntity)this.taskInfo).getHandleState()) && (ut = (UserTask)this.process.getFlowElement(task.getTaskDefinitionKey())).isBackRejectedActivity()) {
            isBackRejectedActivity = true;
            TaskHelper taskHelper = commandContext.getProcessEngineConfiguration().getTaskHelper();
            String nodeId = taskHelper.getRejectNodeId(task.getProcessInstanceId(), task.getExecution().getCurrentActInstId());
            this.addNode(finalUserTaskNodes, (FlowNode)this.process.getFlowElement(nodeId), null);
        }
        if (!isBackRejectedActivity) {
            finalUserTaskNodes = this.getNextUseableUserTaskNodes(this.currentNode, variableScope, finalUserTaskNodes);
        }
        this.log.debug("GetNextUseableUserTaskNodeForProcessStartCmd -- nodeIdMapAgreePersonId: " + this.nodeIdMapAgreePersonId);
        list = this.getUsersFormatData(finalUserTaskNodes, commandContext);
        return list;
    }

    protected List<FlowNode> getNextUseableUserTaskNodes(FlowNode flowNode, VariableScope variableScope, List<FlowNode> nodes) {
        List<SequenceFlow> sequenceFlows;
        if (flowNode != this.currentNode && flowNode.getIncomingFlows().size() > 1 && this.isEnterWhenAllArrive(flowNode)) {
            int dynamics = 0;
            for (SequenceFlow s : flowNode.getIncomingFlows()) {
                if (s.isDynamic()) continue;
                ++dynamics;
            }
            if (dynamics > 1) {
                nodes.add(flowNode);
                return nodes;
            }
        }
        if (!((sequenceFlows = this.getNodeOutgoingSequences(flowNode, variableScope)).size() <= 1 || flowNode.getFork() != null && flowNode.getFork().booleanValue() && "leavewhenallmeet".equals(flowNode.getOutSet()))) {
            throw new KDException(WFErrorCode.getNextNodeErrorProcessDesigenEr(), new Object[]{flowNode.getId()});
        }
        block24: for (SequenceFlow s : sequenceFlows) {
            String nextNodeId = s.getTargetRef();
            super.filterNodeIdMapAgreePersonId(nextNodeId);
            FlowNode nextFlowNode = this.process.findFlowElementsOfTypeAndId(FlowNode.class, nextNodeId, false);
            try {
                switch (nextFlowNode.getType()) {
                    case "AutoTask": {
                        this.nodeIdMapExecutionType.put(nextFlowNode.getId(), "byAuto");
                        this.getNextUseableUserTaskNodes(nextFlowNode, variableScope, nodes);
                        break;
                    }
                    case "NotifyTask": 
                    case "WaitTask": 
                    case "SSCImageUpload": 
                    case "SSCImageUploadNew": {
                        this.nodeIdMapExecutionType.put(nextFlowNode.getId(), "byAuto");
                        this.getNextUseableUserTaskNodes(nextFlowNode, variableScope, nodes);
                        break;
                    }
                    case "AuditTask": {
                        AuditTask auditTask = (AuditTask)nextFlowNode;
                        List<Long> userIds = null;
                        ParticipatantModel pm = auditTask.getParticipant();
                        if (pm != null && pm.isSkipNodeWithoutPart() && WfUtils.isEmptyForCollection(userIds = this.getUidsForCurrentNode(pm, variableScope))) {
                            this.nodeIdMapAgreePersonId.put(auditTask.getId(), "");
                            this.nodeIdMapAuditNumber.put(auditTask.getId(), "");
                            this.nodeIdMapExecutionType.put(auditTask.getId(), "skip");
                            this.getNextUseableUserTaskNodes(nextFlowNode, variableScope, nodes);
                            break;
                        }
                        if (this.isSkipTask(auditTask, variableScope)) {
                            this.nodeIdMapAgreePersonId.put(auditTask.getId(), "");
                            this.nodeIdMapAuditNumber.put(auditTask.getId(), "");
                            this.nodeIdMapExecutionType.put(auditTask.getId(), "skip");
                            this.getNextUseableUserTaskNodes(nextFlowNode, variableScope, nodes);
                            break;
                        }
                        if (this.isStarterSameAsAuditor(pm, variableScope, auditTask, null)) {
                            DecisionOption defaultDecision = WfUtils.getDefaultDecision(auditTask);
                            if (defaultDecision == null) {
                                throw new KDException(WFErrorCode.withoutDefaultDecisionError(), new Object[]{auditTask.getId()});
                            }
                            this.addNodesWhenAutoAudit(flowNode, nodes, nextFlowNode, auditTask, defaultDecision.getAuditType(), defaultDecision.getNumber(), variableScope);
                            break;
                        }
                        if (this.isAutoAuditTask(auditTask, variableScope)) {
                            String nextFlowNodeAuditType = super.getAutoAuditAuditType(auditTask);
                            String auditNumber = auditTask.getAutoAudit().getAutoDecisionWhenMatch();
                            this.addNodesWhenAutoAudit(flowNode, nodes, nextFlowNode, auditTask, nextFlowNodeAuditType, auditNumber, variableScope);
                            break;
                        }
                        if (auditTask.isRepeaterbtn() && "skip".equals(auditTask.getRepeaterModel())) {
                            userIds = this.getUidsForCurrentNode(pm, variableScope);
                            if (userIds != null && userIds.size() == 1) {
                                Collection values = this.nodeIdMapAgreePersonId.values();
                                if (values.contains(userIds.get(0).toString()) || values.contains("")) {
                                    this.nodeIdMapAgreePersonId.put(auditTask.getId(), "");
                                    this.nodeIdMapAuditNumber.put(auditTask.getId(), "");
                                    this.nodeIdMapExecutionType.put(auditTask.getId(), "skip");
                                    this.getNextUseableUserTaskNodes(nextFlowNode, variableScope, nodes);
                                    break;
                                }
                                this.addNode(nodes, nextFlowNode, userIds);
                                break;
                            }
                            this.addNode(nodes, nextFlowNode, userIds);
                            break;
                        }
                        if (auditTask.isRepeaterbtn() && "auto".equals(auditTask.getRepeaterModel())) {
                            userIds = this.getUidsForCurrentNode(pm, variableScope);
                            if (userIds != null && userIds.size() == 1) {
                                Iterator entrySetIte;
                                Set entrySet;
                                String partic = userIds.get(0).toString();
                                String repeaterKey = "";
                                String personIdInMap = null;
                                if (null != this.nodeIdMapAgreePersonId && null != (entrySet = this.nodeIdMapAgreePersonId.entrySet()) && null != (entrySetIte = entrySet.iterator())) {
                                    Map.Entry entry = null;
                                    while (entrySetIte.hasNext()) {
                                        entry = entrySetIte.next();
                                        if (null == entry || !(personIdInMap = (String)entry.getValue()).equals(partic)) continue;
                                        this.lastNodId = auditTask.getId();
                                        repeaterKey = (String)entry.getKey();
                                        break;
                                    }
                                }
                                if (WfUtils.isNotEmpty(repeaterKey)) {
                                    this.nodeIdMapAgreePersonId.put(auditTask.getId(), partic);
                                    this.lastAssign = partic;
                                    String nextFlowNodeAuditType = "approval";
                                    this.nodeIdMapAuditNumber.put(auditTask.getId(), this.getDecisionNumber(auditTask, nextFlowNodeAuditType, (String)this.nodeIdMapAuditNumber.get(repeaterKey)));
                                    this.nodeIdMapExecutionType.put(auditTask.getId(), "byAuto");
                                    this.getNextUseableUserTaskNodes(nextFlowNode, variableScope, nodes);
                                    break;
                                }
                                this.addNode(nodes, nextFlowNode, userIds);
                                break;
                            }
                            this.addNode(nodes, nextFlowNode, userIds);
                            break;
                        }
                        if ("skip".equals(this.process.getProcessMode())) {
                            userIds = this.getUidsForCurrentNode(pm, variableScope);
                            boolean allowRepeaters = WfConfigurationUtil.getRepeaterApprovalConfig(userIds);
                            if (userIds != null && CollectionUtil.isNotEmpty(userIds) && allowRepeaters && RequestContext.get().getUserId().equals(userIds.get(0) + "")) {
                                this.nodeIdMapAgreePersonId.put(auditTask.getId(), "");
                                this.nodeIdMapAuditNumber.put(auditTask.getId(), "");
                                this.nodeIdMapExecutionType.put(auditTask.getId(), "skip");
                                this.getNextUseableUserTaskNodes(auditTask, variableScope, nodes);
                                break;
                            }
                            this.addNode(nodes, nextFlowNode, userIds);
                            break;
                        }
                        if ("auto".equals(this.process.getProcessMode())) {
                            userIds = this.getUidsForCurrentNode(pm, variableScope);
                            boolean allowRepeaters = WfConfigurationUtil.getRepeaterApprovalConfig(userIds);
                            if (userIds != null && CollectionUtil.isNotEmpty(userIds) && allowRepeaters && RequestContext.get().getUserId().equals(userIds.get(0) + "")) {
                                this.nodeIdMapAgreePersonId.put(auditTask.getId(), userIds.get(0) + "");
                                String defaultAuditType = "approve";
                                this.nodeIdMapExecutionType.put(auditTask.getId(), "byAuto");
                                this.nodeIdMapAuditNumber.put(auditTask.getId(), this.getDecisionNumber(auditTask, defaultAuditType, null));
                                this.getNextUseableUserTaskNodes(auditTask, variableScope, nodes);
                                break;
                            }
                            this.addNode(nodes, nextFlowNode, userIds);
                            break;
                        }
                        this.addNode(nodes, nextFlowNode, userIds);
                        break;
                    }
                    case "UserTask": {
                        UserTask userTask = (UserTask)nextFlowNode;
                        if (this.isSkipTask(userTask, variableScope)) {
                            this.nodeIdMapAgreePersonId.put(userTask.getId(), "");
                            this.nodeIdMapAuditNumber.put(userTask.getId(), "");
                            this.nodeIdMapExecutionType.put(userTask.getId(), "skip");
                            this.getNextUseableUserTaskNodes(nextFlowNode, super.getNodeTask(nextFlowNode), nodes);
                            break;
                        }
                        this.addNode(nodes, nextFlowNode);
                        break;
                    }
                    case "YunzhijiaTask": {
                        YunzhijiaTask yzjTask = (YunzhijiaTask)nextFlowNode;
                        if (this.isSkipTask(yzjTask, variableScope)) {
                            this.nodeIdMapAgreePersonId.put(yzjTask.getId(), "");
                            this.nodeIdMapAuditNumber.put(yzjTask.getId(), "");
                            this.nodeIdMapExecutionType.put(yzjTask.getId(), "skip");
                            this.getNextUseableUserTaskNodes(nextFlowNode, variableScope, nodes);
                            break;
                        }
                        DecisionOption defaultDecision = WfUtils.getDefaultDecision(yzjTask);
                        if (this.isStarterSameAsAuditor(yzjTask.getParticipant(), variableScope, yzjTask, defaultDecision)) {
                            if (defaultDecision == null) {
                                throw new KDException(WFErrorCode.withoutDefaultDecisionError(), new Object[]{yzjTask.getId()});
                            }
                            this.addNodesWhenAutoAudit(flowNode, nodes, nextFlowNode, (AuditTask)yzjTask, defaultDecision.getAuditType(), defaultDecision.getNumber(), variableScope);
                            break;
                        }
                        List<Long> userIds = null;
                        ParticipatantModel pm = yzjTask.getParticipant();
                        if (pm != null && pm.isSkipNodeWithoutPart() && WfUtils.isEmptyForCollection(userIds = this.getUidsForCurrentNode(pm, variableScope))) {
                            this.nodeIdMapAgreePersonId.put(yzjTask.getId(), "");
                            this.nodeIdMapAuditNumber.put(yzjTask.getId(), "");
                            this.nodeIdMapExecutionType.put(yzjTask.getId(), "skip");
                            this.getNextUseableUserTaskNodes(nextFlowNode, variableScope, nodes);
                            break;
                        }
                        this.addNode(nodes, nextFlowNode);
                        break;
                    }
                    case "EndNoneEvent": {
                        if (nodes.contains(nextFlowNode)) continue block24;
                        nodes.add(nextFlowNode);
                        break;
                    }
                    case "SSCApprove": {
                        break;
                    }
                    default: {
                        this.addNode(nodes, nextFlowNode);
                    }
                }
            }
            catch (Exception e) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u8282\u70b9\u9884\u8ba1\u7b97\u51fa\u73b0\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002\u53ef\u80fd\u539f\u56e0\uff1a\u6761\u4ef6\u8868\u8fbe\u5f0f\u4e0d\u652f\u6301\u6d41\u7a0b\u76f8\u5173\u53d8\u91cf\u8ba1\u7b97\u3002", (String)GETNEXTUSEABLEUSERTASKNODEFORPROCESSSTARTCMD_1, (String)"bos-wf-engine", (Object[])new Object[0]), nextFlowNode.getName()));
            }
        }
        return nodes;
    }

    private List<Long> getUidsForCurrentNode(ParticipatantModel participatantModel, VariableScope variableScope) {
        List<ParticipantModelEntityImpl> participants;
        List<Long> userIds = null;
        if (participatantModel != null && WfUtils.isNotEmptyForCollection(participants = participatantModel.getParticipant())) {
            String businessKey = null;
            if (variableScope instanceof IBusinessModel && WfUtils.isNotEmpty(businessKey = ((IBusinessModel)((Object)variableScope)).getBusinessKey()) && "0".equalsIgnoreCase(businessKey)) {
                businessKey = null;
            }
            userIds = this.participantCalculator.getUserIds(businessKey, variableScope, participants);
        }
        return userIds;
    }

    private List<Map<String, Object>> getUsersFormatData(List<FlowNode> finalUserTaskNodes, CommandContext commandContext) {
        ArrayList<Map<String, Object>> list = null;
        if (WfUtils.isNotEmptyForCollection(finalUserTaskNodes)) {
            list = new ArrayList(finalUserTaskNodes.size());
            for (FlowNode flowNode : finalUserTaskNodes) {
                HashMap<String, FlowNode> map = new HashMap<String, FlowNode>();
                map.put("nextNode", flowNode);
                map.put("users", (FlowNode)this.nodeIdMapAgreePersonId.get(flowNode.getId()));
                this.log.debug("GetNextUseableUserTaskNodeForProcessStartCmd -- getUsersFormatData -- map -- nextNodeId: " + flowNode.getId() + "\uff0cusers\uff1a" + (String)this.nodeIdMapAgreePersonId.get(flowNode.getId()));
                list.add(map);
            }
        } else {
            list = new ArrayList<Map<String, Object>>(1);
        }
        return list;
    }

    protected List<SequenceFlow> getNodeOutgoingSequences(FlowNode flowNode, VariableScope variableScope) {
        ArrayList<SequenceFlow> sequenceFlows = new ArrayList<SequenceFlow>();
        String defaultSequenceFlowId = ((Activity)flowNode).getDefaultFlow();
        SequenceFlow defaultSequenceFlow = null;
        try {
            String conditionRuleExpression = null;
            for (SequenceFlow sequenceFlow : flowNode.getOutgoingFlows()) {
                if (sequenceFlow.isDynamic()) continue;
                String expression = "";
                conditionRuleExpression = sequenceFlow.getOrignalExpression();
                if (WfUtils.isEmpty(conditionRuleExpression)) {
                    conditionRuleExpression = sequenceFlow.getConditionExpression();
                }
                if (WfUtils.isNotEmpty(conditionRuleExpression) && !conditionRuleExpression.contains("auditNumber")) {
                    expression = ConditionUtil.handleMacroForCalculateNextNode(conditionRuleExpression, this.nodeIdMapAuditNumber, this.nodeIdMapAgreePersonId, this.lastAssign, this.nodeIdMapExecutionType, variableScope);
                }
                if (WfUtils.isNotEmpty(expression) && expression.contains("proc")) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u8282\u70b9\u9884\u8ba1\u7b97\u51fa\u73b0\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002\u53ef\u80fd\u539f\u56e0\uff1a\u6761\u4ef6\u8868\u8fbe\u5f0f\u4e0d\u652f\u6301\u6d41\u7a0b\u76f8\u5173\u53d8\u91cf\u8ba1\u7b97\u3002", (String)GETNEXTUSEABLEUSERTASKNODEFORPROCESSSTARTCMD_1, (String)"bos-wf-engine", (Object[])new Object[0]), sequenceFlow.getId()));
                }
                if (WfUtils.isNotEmpty(expression) && ConditionUtil.hasTrueCondition(expression, variableScope, null) && (defaultSequenceFlowId == null || !defaultSequenceFlowId.equals(sequenceFlow.getId()))) {
                    sequenceFlows.add(sequenceFlow);
                    continue;
                }
                if (defaultSequenceFlowId != null && sequenceFlow.getId().equals(defaultSequenceFlowId)) {
                    defaultSequenceFlow = sequenceFlow;
                    continue;
                }
                if (!WfUtils.isEmpty(expression)) continue;
                sequenceFlows.add(sequenceFlow);
            }
        }
        catch (Exception e) {
            this.log.warn(e.getMessage());
            throw e;
        }
        if (sequenceFlows.size() <= 0 && defaultSequenceFlow != null) {
            sequenceFlows.add(defaultSequenceFlow);
        }
        return sequenceFlows;
    }

    private boolean isSkipTask(UserTask userTask, VariableScope variableScope) {
        if (ConditionUtil.isConditionAvailable(userTask.getSkipCondition())) {
            if (WfUtils.isNotEmpty(userTask.getSkipCondition().getPlugin())) {
                this.log.debug(userTask.getId() + "\u8282\u70b9\u9884\u8ba1\u7b97\u4e0d\u652f\u6301\u63d2\u4ef6 \uff01");
                return false;
            }
            String expression = userTask.getSkipCondition().getExpression();
            if (WfUtils.isNotEmpty(expression) && expression.contains("proc")) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u8282\u70b9\u9884\u8ba1\u7b97\u51fa\u73b0\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002\u53ef\u80fd\u539f\u56e0\uff1a\u6761\u4ef6\u8868\u8fbe\u5f0f\u4e0d\u652f\u6301\u6d41\u7a0b\u76f8\u5173\u53d8\u91cf\u8ba1\u7b97\u3002", (String)GETNEXTUSEABLEUSERTASKNODEFORPROCESSSTARTCMD_1, (String)"bos-wf-engine", (Object[])new Object[0]), userTask.getName()));
            }
            if (ConditionUtil.hasTrueCondition(ConditionUtil.handleMacroForCalculateNextNode(userTask.getSkipCondition().getExpression(), this.nodeIdMapAuditNumber, this.nodeIdMapAgreePersonId, this.lastAssign, this.nodeIdMapExecutionType, variableScope), variableScope, null)) {
                return true;
            }
        }
        return false;
    }

    protected boolean isAutoAuditTask(AuditTask auditTask, VariableScope variableScope) {
        if (this.isAutoAuditWhenMatch(auditTask) && this.isAutoAuditConditionExpressionNotEmpty(auditTask) && WfUtils.isNotEmpty(auditTask.getAutoAudit().getAutoDecisionWhenMatch())) {
            if (variableScope == null) {
                return false;
            }
            String expression = auditTask.getAutoAudit().getAutoAuditCondition().getExpression();
            if (WfUtils.isNotEmpty(expression) && expression.contains("proc")) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u8282\u70b9\u9884\u8ba1\u7b97\u51fa\u73b0\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002\u53ef\u80fd\u539f\u56e0\uff1a\u6761\u4ef6\u8868\u8fbe\u5f0f\u4e0d\u652f\u6301\u6d41\u7a0b\u76f8\u5173\u53d8\u91cf\u8ba1\u7b97\u3002", (String)GETNEXTUSEABLEUSERTASKNODEFORPROCESSSTARTCMD_1, (String)"bos-wf-engine", (Object[])new Object[0]), auditTask.getName()));
            }
            if (ConditionUtil.hasTrueCondition(ConditionUtil.handleMacroForCalculateNextNode(auditTask.getAutoAudit().getAutoAuditCondition().getExpression(), this.nodeIdMapAuditNumber, this.nodeIdMapAgreePersonId, this.lastAssign, this.nodeIdMapExecutionType, variableScope), variableScope, null)) {
                return true;
            }
        }
        if (this.isAutoAuditWhenMatch(auditTask) && auditTask.getAutoAudit().getAutoAuditCondition() != null && WfUtils.isNotEmpty(auditTask.getAutoAudit().getAutoAuditCondition().getPlugin())) {
            this.log.debug(auditTask.getId() + "\u8282\u70b9\u9884\u8ba1\u7b97\u4e0d\u652f\u6301\u63d2\u4ef6 \uff01");
            return false;
        }
        return false;
    }

    private boolean isAutoAuditWhenMatch(AuditTask auditTask) {
        return auditTask.getAutoAudit() != null && auditTask.getAutoAudit().isAutoAuditWhenMatch();
    }

    private boolean isAutoAuditConditionExpressionNotEmpty(AuditTask auditTask) {
        return auditTask.getAutoAudit().getAutoAuditCondition() != null && WfUtils.isNotEmpty(auditTask.getAutoAudit().getAutoAuditCondition().getExpression());
    }

    protected void addNodesWhenAutoAudit(FlowNode flowNode, List<FlowNode> nodes, FlowNode nextFlowNode, AuditTask auditTask, String nextFlowNodeAuditType, String auditNumber, VariableScope variableScope) {
        this.nodeIdMapAgreePersonId.put(auditTask.getId(), "");
        this.nodeIdMapAuditNumber.put(auditTask.getId(), auditNumber);
        this.nodeIdMapExecutionType.put(auditTask.getId(), "byAuto");
        if ("terminate".equals(nextFlowNodeAuditType)) {
            List<EndEvent> ends = this.process.findFlowElementsOfType(EndEvent.class);
            nodes.add(ends.get(0));
        } else if (super.isDynamicReject(nextFlowNodeAuditType, auditTask)) {
            List<DecisionOption> options = auditTask.getDecisionOptions();
            for (DecisionOption d : options) {
                if (!auditNumber.equals(d.getNumber())) continue;
                List<SelectNodesModel> rejectOptions = d.getRejectOptions();
                if (rejectOptions != null) {
                    SelectNodesModel map = null;
                    for (int i = rejectOptions.size() - 1; i >= 0; --i) {
                        map = rejectOptions.get(i);
                        UserTask userTask = this.process.findFlowElementsOfTypeAndId(UserTask.class, map.getItemId(), false);
                        if (nodes.contains(userTask) || this.hasNotParticipant(userTask, variableScope)) continue;
                        if (this.isSkipTask(userTask, variableScope)) {
                            this.nodeIdMapAgreePersonId.put(userTask.getId(), "");
                            this.nodeIdMapAuditNumber.put(userTask.getId(), "");
                            this.nodeIdMapExecutionType.put(auditTask.getId(), "skip");
                            this.getNextUseableUserTaskNodes(userTask, this.getNodeTask(userTask), nodes);
                            continue;
                        }
                        if (userTask instanceof AuditTask && this.isAutoAuditTask((AuditTask)userTask, variableScope)) {
                            this.nodeIdMapAgreePersonId.put(userTask.getId(), "");
                            String autoAuditType = this.getAutoAuditAuditType((AuditTask)userTask);
                            this.nodeIdMapAuditNumber.put(userTask.getId(), super.getDecisionNumber(userTask, autoAuditType, null));
                            this.nodeIdMapExecutionType.put(auditTask.getId(), "byAuto");
                            this.getNextUseableUserTaskNodes(userTask, this.getNodeTask(userTask), nodes);
                            continue;
                        }
                        super.addNodes("reject", nodes, userTask);
                    }
                }
                break;
            }
        } else {
            this.getNextUseableUserTaskNodes(nextFlowNode, variableScope, nodes);
        }
    }

    public boolean isStarterSameAsAuditor(ParticipatantModel participatantModel, VariableScope variableScope, FlowElement element, DecisionOption decision) {
        if (Boolean.TRUE.equals(this.process.getAutoAuditWhenSamePerson())) {
            List<Long> userIds = this.getUidsForCurrentNode(participatantModel, variableScope);
            if (WfUtils.isEmptyForCollection(userIds)) {
                return false;
            }
            Long starterId = this.getStarterIdFromProcess(variableScope);
            if (null != userIds && userIds.contains(starterId)) {
                if ("YunzhijiaTask".equals(element.getType())) {
                    return this.isStarterSameAsAuditorForYzj((YunzhijiaTask)element, decision, userIds.size());
                }
                return true;
            }
        }
        return false;
    }

    private boolean isStarterSameAsAuditorForYzj(YunzhijiaTask yzjTask, DecisionOption decision, int userIdSize) {
        String businessModel;
        switch (businessModel = yzjTask.getBusinessModel()) {
            case "passByOne": {
                if (!"approve".equals(decision.getAuditType())) break;
                return true;
            }
            case "oneVoteVeto": {
                if (!"reject".equals(decision.getAuditType())) break;
                return true;
            }
            case "voteOnProportion": {
                if (!"approve".equals(decision.getAuditType()) || !(100.0 / Double.parseDouble(String.valueOf(userIdSize)) >= yzjTask.getVotePercentage())) break;
                return true;
            }
            case "allVote": {
                if (userIdSize != 1 || !"approve".equals(decision.getAuditType())) break;
                return true;
            }
        }
        return false;
    }

    private Long getStarterIdFromProcess(VariableScope variableScope) {
        List<Variable> processVariables = this.process.getVariables();
        Long bizApplier = null;
        String express = null;
        Expression expression = null;
        Object defaultValue = null;
        if (WfUtils.isNotEmptyForCollection(processVariables)) {
            for (Variable variable : processVariables) {
                if (null == variable) continue;
                express = (String)variable.getDefaultValue();
                expression = Context.getProcessEngineConfiguration().getExpressionManager().createExpression(express);
                defaultValue = expression.getValue(variableScope);
                if (!"bizApplier".equals(variable.getName()) || !WfUtils.isNotEmptyString(defaultValue)) continue;
                try {
                    bizApplier = (Long)defaultValue;
                }
                catch (Exception e) {
                    this.log.error(WfUtils.getExceptionStacktrace(e));
                }
            }
        }
        if (null == bizApplier) {
            bizApplier = Long.valueOf(RequestContext.get().getUserId());
        }
        return bizApplier;
    }

    protected boolean hasNotParticipant(UserTask flowNode, VariableScope variableScope) {
        List<Long> userIds;
        return null != flowNode && ((userIds = this.getUidsForCurrentNode(flowNode.getParticipant(), variableScope)) == null || userIds.size() <= 0) && flowNode.getParticipant() != null && flowNode.getParticipant().isSkipNodeWithoutPart();
    }

    protected void addNode(List<FlowNode> nodes, FlowNode nextFlowNode, List<Long> userIds) {
        UserTask userTask;
        if (!nodes.contains(nextFlowNode)) {
            nodes.add(nextFlowNode);
        }
        String nodeId = null;
        if (null != nextFlowNode && BpmnModelUtil.instanceofUserTask(nextFlowNode.getType()) && null != (userTask = (UserTask)nextFlowNode)) {
            nodeId = userTask.getId();
            if (null == userIds) {
                ParticipatantModel pm = userTask.getParticipant();
                BusinessModelVariableScope variableScope = new BusinessModelVariableScope(this.model);
                userIds = this.getUidsForCurrentNode(pm, variableScope);
            }
        }
        if (null != nodeId && WfUtils.isNotEmptyForCollection(userIds)) {
            String userIdsStr = WfUtils.listToString(userIds, "\uff0c");
            this.nodeIdMapAgreePersonId.put(nodeId, userIdsStr);
        }
    }

    protected void addNode(List<FlowNode> nodes, FlowNode nextFlowNode) {
        this.addNode(nodes, nextFlowNode, new ArrayList<Long>());
    }
}

