/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.util.ArrayList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.ParticipantRangeSettingModel;
import kd.bos.workflow.bpmn.model.ParticipatantModel;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.RuntimeService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.bpmn.behavior.TaskBehaviorUtil;
import kd.bos.workflow.engine.impl.calculator.ParticipantRangeUtil;
import kd.bos.workflow.engine.impl.cmd.task.ParticipantScope;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.ParticipantModelEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.PreComputatorExecutionEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;

public class GetNodeParticipantCmd
implements Command<ParticipantScope> {
    private String businessKey;
    private String currentNodeId;
    private DynamicObject dynamicObject;
    private Long processDefinitionId;
    private Long processInstanceId;
    private String schemeId;
    private Long taskId;

    public GetNodeParticipantCmd(String schemeId, String businessKey, String currentNodeId, Long processDefinitionId, Long processInstanceId, Long taskId, DynamicObject dynamicObject) {
        this.schemeId = schemeId;
        this.businessKey = businessKey;
        this.currentNodeId = currentNodeId;
        this.processDefinitionId = processDefinitionId;
        this.processInstanceId = processInstanceId;
        this.taskId = taskId;
        this.dynamicObject = dynamicObject;
    }

    @Override
    public ParticipantScope execute(CommandContext commandContext) {
        ParticipantScope participantScope = new ParticipantScope();
        UserTask userTask = this.getUserTask();
        if (userTask == null) {
            return null;
        }
        ParticipatantModel participant = userTask.getParticipant();
        if (participant.isPersonrangeformanual()) {
            participantScope.setIsPersonRangeOpen(Boolean.TRUE);
            ParticipantRangeSettingModel setting = userTask.getParticipantRangeSetting();
            if (setting != null) {
                Boolean allowAddPerson = setting.isAllowanyone();
                participantScope.setIsAllowAddPerson(allowAddPerson);
                RuntimeService runtimeService = WfUtils.getWfService().getRuntimeService();
                VariableScope variableScope = this.getVariableScope(commandContext);
                List<ParticipantModelEntityImpl> participantAllow = setting.getParticipantAllow();
                if (WfUtils.isNotEmptyForCollection(participantAllow)) {
                    participantScope.setPersonScopeHasData(Boolean.TRUE);
                    List<Long> whiteList = runtimeService.getUserIdsByCalculate(this.businessKey, variableScope, participantAllow);
                    participantScope.setWhiteParticipantList(whiteList);
                    String nodeType = userTask.getType();
                    if ("YunzhijiaTask".equals(nodeType)) {
                        ArrayList<ParticipantModelEntityImpl> participantAllowForRequired = new ArrayList<ParticipantModelEntityImpl>();
                        for (ParticipantModelEntityImpl entity : participantAllow) {
                            Boolean required = entity.getRequired();
                            if (null == required || !required.booleanValue()) continue;
                            participantAllowForRequired.add(entity);
                        }
                        if (WfUtils.isNotEmptyForCollection(participantAllowForRequired)) {
                            List<Long> mustList = runtimeService.getUserIdsByCalculate(this.businessKey, variableScope, participantAllowForRequired);
                            participantScope.setMustParticipantList(mustList);
                        }
                    }
                } else {
                    participantScope.setPersonScopeHasData(Boolean.FALSE);
                }
                List<ParticipantModelEntityImpl> participantBlackList = setting.getParticipantBlackList();
                if (WfUtils.isNotEmptyForCollection(participantBlackList)) {
                    List<Long> blackList = runtimeService.getUserIdsByCalculate(this.businessKey, variableScope, participantBlackList);
                    participantScope.setBlackParticipantList(blackList);
                }
            }
        } else {
            participantScope.setIsPersonRangeOpen(Boolean.FALSE);
            participantScope.setPersonScopeHasData(Boolean.FALSE);
        }
        return participantScope;
    }

    private PreComputatorExecutionEntityImpl getPreComputatoScope() {
        PreComputatorExecutionEntityImpl preExecution = new PreComputatorExecutionEntityImpl();
        preExecution.setProcessDefinitionId(this.processDefinitionId);
        if (this.processInstanceId != null) {
            preExecution.setProcessInstanceId(this.processInstanceId);
            preExecution.setParentId(this.processInstanceId);
            preExecution.setRootProcessInstanceId(this.processInstanceId);
        }
        DynamicObjectType type = this.dynamicObject.getDynamicObjectType();
        String entityNumber = "";
        if (type != null) {
            entityNumber = this.dynamicObject.getDynamicObjectType().getName();
        }
        preExecution.setEntityNumber(entityNumber);
        if (this.dynamicObject.getPkValue() != null) {
            preExecution.setBusinessKey(this.dynamicObject.getPkValue().toString());
        }
        preExecution.setTransientBill(this.dynamicObject);
        preExecution.setBillNo(TaskBehaviorUtil.getTaskBillNo(entityNumber, this.dynamicObject));
        preExecution.setCreateDate(WfUtils.now());
        preExecution.setCreatorId(Long.valueOf(RequestContext.get().getUserId()));
        preExecution.setStartUserId(Long.valueOf(RequestContext.get().getUserId()));
        preExecution.setCountEnabled(false);
        preExecution.setEventSubscriptionCount(0);
        preExecution.setTaskCount(0);
        preExecution.setJobCount(0);
        preExecution.setTimerJobCount(0);
        preExecution.setSuspendedJobCount(0);
        preExecution.setDeadLetterJobCount(0);
        preExecution.setVariableCount(0);
        preExecution.setIdentityLinkCount(0);
        return preExecution;
    }

    private VariableScope getVariableScope(CommandContext commandContext) {
        TaskEntity task;
        if (this.taskId != null && (task = (TaskEntity)commandContext.getTaskEntityManager().findById(this.taskId)) != null) {
            return task.getExecution();
        }
        return this.getPreComputatoScope();
    }

    private UserTask getUserTask() {
        UserTask userElement = null;
        if (this.processInstanceId == null) {
            Long schema = null;
            if (this.schemeId != null) {
                schema = Long.valueOf(this.schemeId);
            }
            BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(this.processDefinitionId, schema, this.processInstanceId);
            FlowElement flowElement = bpmnModel.getFlowElement(this.currentNodeId);
            userElement = (UserTask)flowElement;
        } else {
            userElement = ParticipantRangeUtil.getFlowElement(this.processDefinitionId, this.processInstanceId, this.currentNodeId, null);
        }
        return userElement;
    }
}

