/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntityManager;
import kd.bos.workflow.engine.msg.MessageServiceUtil;
import kd.bos.workflow.engine.msg.util.yzj.YunzhijiaCommonUtil;

public class GetParameterForYzjChatCmd
implements Command<Map<String, Object>>,
Serializable {
    private static final long serialVersionUID = -8753314848429377386L;
    private Long processInstanceId;

    public GetParameterForYzjChatCmd(Long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @Override
    public Map<String, Object> execute(CommandContext commandContext) {
        if (WfUtils.isEmpty(this.processInstanceId)) {
            return Collections.EMPTY_MAP;
        }
        TaskEntityManager managerTask = commandContext.getTaskEntityManager();
        EntityQueryBuilder queryBuilder = managerTask.createQueryBuilder();
        queryBuilder.addFilters(new QFilter[]{new QFilter("processInstanceId", "=", (Object)this.processInstanceId), new QFilter("display", "=", (Object)"1")}).orderBy("createDate desc").setLimit(1);
        List entities = managerTask.findByQueryBuilder(queryBuilder);
        if (null != entities && !entities.isEmpty()) {
            TaskEntity entity = (TaskEntity)entities.get(0);
            String webpageUrl = MessageServiceUtil.buildWebPageUrlForTaskEntity(entity) + "&type=toHandle";
            Long differentGroupKey = entity.getParentTaskId();
            if (WfUtils.isEmptyString(differentGroupKey)) {
                differentGroupKey = entity.getId();
            }
            return this.getParameterForYzjChat(entity.getSubject(), entity.getEntityName(), entity.getStartName(), entity.getBillNo(), webpageUrl, ((Object)differentGroupKey).toString());
        }
        HistoricProcessInstanceEntityManager managerProc = commandContext.getHistoricProcessInstanceEntityManager();
        HistoricProcessInstanceEntity entity = (HistoricProcessInstanceEntity)managerProc.findById(this.processInstanceId, managerProc.getSelectFields());
        if (null == entity) {
            return Collections.EMPTY_MAP;
        }
        String webpageUrl = MessageServiceUtil.buildWebPageUrlForMyApplyed(entity);
        return this.getParameterForYzjChat(null, entity.getEntraBillName(), entity.getStartName(), entity.getBillNo(), webpageUrl, entity.getBusinessKey());
    }

    private Map<String, Object> getParameterForYzjChat(ILocaleString subjectLocale, ILocaleString entityNameLocale, ILocaleString startNameLocale, String billNo, String webpageUrl, String differentGroupKey) {
        String localeId = Lang.get().toString();
        String content = null;
        if (null != subjectLocale) {
            content = WfMultiLangUtils.getValueFromLocalString(subjectLocale, localeId);
        }
        if (WfUtils.isEmpty(content)) {
            content = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u7801\uff1a%s", (String)"GetParameterForYzjChatCmd_0", (String)"bos-wf-engine", (Object[])new Object[0]), billNo);
        }
        String title = null;
        String entityName = WfMultiLangUtils.getValueFromLocalString(entityNameLocale, localeId);
        if (null == startNameLocale) {
            title = entityName;
        } else {
            String startName = WfMultiLangUtils.getValueFromLocalString(startNameLocale, localeId);
            title = String.format(ResManager.loadKDString((String)"%1$s\u7684%2$s", (String)"GetParameterForYzjChatCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]), startName, entityName);
        }
        LinkedHashMap<String, Object> parameters = new LinkedHashMap<String, Object>();
        parameters.put("content", content);
        parameters.put("title", title);
        parameters.put("webpageUrl", webpageUrl);
        parameters.put("businessKey", differentGroupKey);
        parameters.put("assignGroupOwner", Boolean.FALSE);
        String lightAppId = null;
        lightAppId = WfConfigurationUtil.isEnabled("yunzhijia") ? WfConfigurationUtil.getLightAppId("yunzhijia", "flowassist", null) : WfConfigurationUtil.getLightAppId("yunzhijiaeco", "flowassist", null);
        if (WfUtils.isNotEmpty(lightAppId)) {
            parameters.put("lightAppId", YunzhijiaCommonUtil.encode(lightAppId));
        }
        return parameters;
    }
}

