/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.history.HistoricIdentityLink;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntityManager;

public class GetParticipantInfoByTaskIdAndUserIdCmd
implements Command<Map<String, Object>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected Long taskId;
    protected Long userId;
    public static final String MAPKEYFORIDENTITYLINKTYPE = "mapKeyForIdentityLinkType";
    public static final String MAPKEYFORISCURRENT = "mapKeyForIsCurrent";
    public static final String ISDELEGTE = "isDelegte";
    public static final String REALTASKID = "realTaskId";
    private Log logger = LogFactory.getLog(this.getClass());

    public GetParticipantInfoByTaskIdAndUserIdCmd(Long taskId, Long userId) {
        this.taskId = taskId;
        this.userId = userId;
    }

    @Override
    public Map<String, Object> execute(CommandContext commandContext) {
        this.logger.debug("kd.bos.workflow.engine.impl.cmd.task.GetParticipantInfoByTaskIdAndUserIdCmd.execute params userid :" + this.userId + "; taskid :" + this.taskId);
        HashMap<String, Object> returnInfo = new HashMap<String, Object>();
        if (WfUtils.isEmpty(this.userId)) {
            return returnInfo;
        }
        HistoricIdentityLinkEntityManager manager = commandContext.getHistoricIdentityLinkEntityManager();
        List<HistoricIdentityLinkEntity> infos = manager.findParticipantsByTaskId(this.taskId, "userId, taskId, parenttaskid, endTime, type, delegateid", "createDate desc");
        if (null == infos || infos.isEmpty()) {
            return returnInfo;
        }
        HistoricIdentityLink info = null;
        Long parentTaskId = null;
        for (HistoricIdentityLinkEntity hiEntity : infos) {
            if (null == hiEntity) continue;
            if (WfUtils.isEmpty(parentTaskId)) {
                parentTaskId = hiEntity.getParenttaskid();
            }
            if (!this.userId.equals(hiEntity.getUserId())) continue;
            info = hiEntity;
            break;
        }
        if (null == info && WfUtils.isNotEmpty(parentTaskId)) {
            infos = manager.findParticipantsByParentTaskId(parentTaskId, this.userId);
            if (null == infos || infos.isEmpty()) {
                return returnInfo;
            }
            info = infos.get(0);
        }
        if (null == info) {
            return returnInfo;
        }
        returnInfo.put(MAPKEYFORIDENTITYLINKTYPE, info.getType());
        returnInfo.put(REALTASKID, info.getTaskId());
        returnInfo.put(ISDELEGTE, WfUtils.isNotEmpty(info.getDelegateId()) ? Boolean.TRUE : Boolean.FALSE);
        this.logger.debug("kd.bos.workflow.engine.impl.cmd.task.GetParticipantInfoByTaskIdAndUserIdCmd.execute result: " + returnInfo);
        return returnInfo;
    }
}

