/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.component.approvalrecord.ApprovalAttachmentInfo;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.task.RecordItemAttachmentInfo;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;

public class GetProcessAttachmentsInfoCmd
implements Command<Map<String, List<ApprovalAttachmentInfo>>>,
Serializable {
    private static final long serialVersionUID = 678868592618149790L;
    private String entityNumber;
    private String businessKey;

    public GetProcessAttachmentsInfoCmd(String entityNumber, String businessKey) {
        this.entityNumber = entityNumber;
        this.businessKey = businessKey;
    }

    @Override
    public Map<String, List<ApprovalAttachmentInfo>> execute(CommandContext commandContext) {
        boolean printTrdApprovalRecord;
        if (WfUtils.isEmpty(this.entityNumber) || WfUtils.isEmpty(this.businessKey)) {
            return Collections.EMPTY_MAP;
        }
        ArrayList<Long> commentIds = new ArrayList<Long>();
        List<Long> commentIdsTemp = this.getCommentIds("wf_hicomment");
        if (null != commentIdsTemp && !commentIdsTemp.isEmpty()) {
            commentIds.addAll(commentIdsTemp);
        }
        if ((printTrdApprovalRecord = WfConfigurationUtil.printTrdApprovalRecord()) && null != (commentIdsTemp = this.getCommentIds("wf_trdhicomment")) && !commentIdsTemp.isEmpty()) {
            commentIds.addAll(commentIdsTemp);
        }
        if (commentIds.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        return this.getProcessAttachmentsInfo(commentIds, commandContext);
    }

    private Map<String, List<ApprovalAttachmentInfo>> getProcessAttachmentsInfo(List<Long> commentIds, CommandContext commandContext) {
        HashMap<String, List<ApprovalAttachmentInfo>> attachmentInfosFormat = new HashMap<String, List<ApprovalAttachmentInfo>>(commentIds.size());
        StringBuilder contentIds = new StringBuilder("(");
        int index = 0;
        int size = commentIds.size();
        for (Long key : commentIds) {
            contentIds.append(key);
            if (index < size - 1) {
                contentIds.append(',');
            }
            ++index;
        }
        contentIds.append(')');
        Map<String, RecordItemAttachmentInfo> attachmentInfos = commandContext.getHistoricAttachmentEntityManager().getAttachmentInfo(contentIds.toString(), null);
        if (null == attachmentInfos || attachmentInfos.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        Set<Map.Entry<String, RecordItemAttachmentInfo>> entrySet = attachmentInfos.entrySet();
        Iterator<Map.Entry<String, RecordItemAttachmentInfo>> entrySetIte = entrySet.iterator();
        Map.Entry<String, RecordItemAttachmentInfo> entry = null;
        List<ApprovalAttachmentInfo> attachments = null;
        RecordItemAttachmentInfo recordItemAttachmentInfo = null;
        while (entrySetIte.hasNext()) {
            entry = entrySetIte.next();
            if (null == entry || null == (recordItemAttachmentInfo = entry.getValue()) || null == (attachments = recordItemAttachmentInfo.getAttachments()) || attachments.isEmpty()) continue;
            attachmentInfosFormat.put(entry.getKey(), attachments);
        }
        return attachmentInfosFormat;
    }

    private List<Long> getCommentIds(String table) {
        QFilter[] filters = new QFilter[]{new QFilter("businessKey", "=", (Object)this.businessKey), new QFilter("entitynumber", "=", (Object)this.entityNumber)};
        DynamicObjectCollection collection = QueryServiceHelper.query((String)table, (String)"id", (QFilter[])filters);
        if (null == collection || collection.isEmpty()) {
            return null;
        }
        ArrayList<Long> commentIds = new ArrayList<Long>(collection.size());
        for (DynamicObject dynamicObject : collection) {
            if (null == dynamicObject) continue;
            commentIds.add(dynamicObject.getLong("id"));
        }
        return commentIds;
    }
}

