/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.EndEvent;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.NotifyTask;
import kd.bos.workflow.bpmn.model.StartEvent;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.dynprocess.freeflow.WFFlowNode;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;

public class GetRejectedPreNodeCmd
implements Command<List<WFFlowNode>> {
    private Log logger = LogFactory.getLog(this.getClass());
    private Long taskId;

    public GetRejectedPreNodeCmd(Long taskId) {
        this.taskId = taskId;
    }

    @Override
    public List<WFFlowNode> execute(CommandContext commandContext) {
        Long processInstanceId;
        this.logger.debug(String.format("GetCurrNodePreNode taskId is:%s", this.taskId));
        String selectFields = "taskDefinitionKey,processDefinitionId,processInstanceId";
        TaskEntity taskEntity = (TaskEntity)commandContext.getTaskEntityManager().findById(this.taskId, selectFields);
        if (taskEntity == null) {
            return new ArrayList<WFFlowNode>();
        }
        String nodeId = taskEntity.getTaskDefinitionKey();
        Long processDefId = taskEntity.getProcessDefinitionId();
        BpmnModel model = ProcessDefinitionUtil.getBpmnModel(processDefId, processInstanceId = taskEntity.getProcessInstanceId());
        if (model == null || BpmnModelUtil.isBizFlow(model.getMainProcess().getProcessType()) || ModelType.NoCodeFlow.toString().equals(model.getMainProcess().getProcessType())) {
            return new ArrayList<WFFlowNode>();
        }
        List<Object> nodes = new ArrayList();
        try {
            nodes = BpmnModelUtil.getRejectNodes(model, nodeId);
            nodes = this.filterOptionalNodes(nodes);
        }
        catch (Exception e) {
            this.logger.error(WfUtils.getExceptionStacktrace(e));
        }
        ArrayList<WFFlowNode> wfNodes = new ArrayList<WFFlowNode>(nodes.size());
        StringBuilder nodeIds = new StringBuilder();
        for (FlowElement flowElement : nodes) {
            WFFlowNode wfFlowNode = new WFFlowNode();
            wfFlowNode.setId(flowElement.getId());
            wfFlowNode.setName(new LocaleString(flowElement.getName()));
            wfFlowNode.setNumber(flowElement.getNumber());
            nodeIds.append(flowElement.getNumber()).append(",");
            wfFlowNode.setType(flowElement.getType());
            if (flowElement instanceof UserTask) {
                wfFlowNode.setExtAttrGroup(BpmnModelUtil.extendAttributeGroupConverterToWF(flowElement));
            }
            wfNodes.add(wfFlowNode);
        }
        this.logger.debug(String.format("nodeIds are %s", nodeIds));
        return wfNodes;
    }

    private List<FlowElement> filterOptionalNodes(List<FlowElement> nodesWithoutFilter) {
        ArrayList<FlowElement> filterNodes = new ArrayList<FlowElement>(nodesWithoutFilter.size());
        for (FlowElement node : nodesWithoutFilter) {
            if (node instanceof StartEvent || node instanceof EndEvent || node instanceof NotifyTask) continue;
            filterNodes.add(node);
        }
        return filterNodes;
    }
}

