/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.engine.TableNameConstant;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.BillSubjectModelEntity;

public class GetTCBillInfoCmd
implements Command<Map<String, String>>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Long fId;
    private String type;

    public GetTCBillInfoCmd(Long fId, String type) {
        this.fId = fId;
        this.type = type;
    }

    @Override
    public Map<String, String> execute(CommandContext commandContext) {
        Map<String, String> billInfo = null;
        switch (this.type) {
            case "toHandle": {
                billInfo = this.getToHandleBillInfo();
                break;
            }
            case "handled": {
                billInfo = this.getHandledBillInfo(commandContext);
                break;
            }
            case "applyed": {
                billInfo = this.getApplyedBillInfo();
                break;
            }
            case "toApply": {
                billInfo = this.getToApplyBillInfo();
                break;
            }
        }
        return billInfo;
    }

    public Map<String, String> getToHandleBillInfo() {
        String sql = "select a.fentitynumber entitynumber,a.fbusinesskey businesskey,a.fformkey formkey,b.fformkey formkeyview,a.fbilltype billtype,a.fprocinstid processinstanceid,a.FTASKDEFID taskDefinitionKey,a.fcontrol control,a.fprocesstype processtype  from t_wf_task a left join t_wf_billsubjectmodel b on a.fentitynumber=b.fentitynumber where a.fid =?";
        Object[] params = new Object[]{this.fId};
        return this.exeSql(sql, "WfTaskCenter.wf_task.queryBillInfo", params);
    }

    public Map<String, String> getHandledBillInfo(CommandContext commandContext) {
        StringBuilder sql = new StringBuilder();
        sql.append("select ").append("a.fentitynumber entitynumber, ").append("a.fbusinesskey businesskey, ").append("a.fformkey formkey, ").append("a.fformkey formkeyview, ").append("a.fbilltype billtype, ").append("a.fprocinstid processinstanceid, ").append("a.FTASKDEFKEY taskDefinitionKey, ").append("a.fprocesstype processtype ").append("from ").append(TableNameConstant.getHiTaskInstTableName()).append(" a where a.fid =?");
        Object[] params = new Object[]{this.fId};
        Map<String, String> billInfo = this.exeSql(sql.toString(), "WfTaskCenter.wf_hitaskinst.queryBillInfo", params);
        if (null == billInfo || billInfo.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        String entityNumberObj = billInfo.get("entitynumber");
        if (null == entityNumberObj || WfUtils.isEmptyString(entityNumberObj)) {
            return billInfo;
        }
        BillSubjectModelEntity billSubjectModelEntity = commandContext.getBillSubjectModelEntityManager().findBillSubjectByEntityNumber(entityNumberObj.toString());
        if (null == billSubjectModelEntity) {
            return billInfo;
        }
        billInfo.put("formkeyview", billSubjectModelEntity.getFormKey());
        return billInfo;
    }

    public Map<String, String> getApplyedBillInfo() {
        StringBuilder sql = new StringBuilder();
        sql.append("select ").append("a.fentitynumber entitynumber,").append("a.fbusinesskey businesskey,").append("'' formkey, '' formkeyview, ").append("a.fbilltype billtype,").append("a.fid processinstanceid, '' taskDefinitionKey,").append("a.fprocesstype processtype ").append(" from ").append(TableNameConstant.getHiProcInstTableName()).append(" a where a.fid = ?;");
        Object[] params = new Object[]{this.fId};
        Map<String, String> exeSql = this.exeSql(sql.toString(), "WfTaskCenter.wf_hiprocinst.queryBillInfo", params);
        String entityNumber = exeSql.get("entitynumber");
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"wf_billsubjectmodel", (String)"formkey", (QFilter[])new QFilter[]{new QFilter("entitynumber", "=", (Object)entityNumber)});
        if (load != null && load.length > 0) {
            exeSql.put("formkeyview", load[0].getString("formkey"));
        }
        return exeSql;
    }

    public Map<String, String> getToApplyBillInfo() {
        String sql = "select a.fentitynumber entitynumber,a.fbusinesskey businesskey,'' formkey,b.fformkey formkeyview,a.fbilltype billtype,a.fprocinstid processinstanceid, '' taskDefinitionKey,a.fprocesstype processtype  from t_wf_execution a left join t_wf_billsubjectmodel b on a.fentitynumber=b.fentitynumber where a.fid =?";
        Object[] params = new Object[]{this.fId};
        return this.exeSql(sql, "WfTaskCenter.wf_execution.queryBillInfo", params);
    }

    private Map<String, String> exeSql(String sql, String queryKey, Object[] params) {
        HashMap<String, String> billInfo = new HashMap<String, String>();
        try (DataSet ds = DB.queryDataSet((String)queryKey, (DBRoute)WfUtils.WFS, (String)sql, (Object[])params);){
            Iterator iter = ds.iterator();
            if (iter.hasNext()) {
                Row row = (Row)iter.next();
                billInfo.put("entitynumber", row.getString("entitynumber"));
                billInfo.put("businesskey", row.getString("businesskey"));
                billInfo.put("formkey", row.getString("formkey"));
                billInfo.put("formkeyview", row.getString("formkeyview"));
                billInfo.put("billtype", row.getString("billtype"));
                billInfo.put("taskDefinitionKey", row.getString("taskDefinitionKey"));
                billInfo.put("processtype", row.getString("processtype"));
                Long procInstanceId = row.getLong("processinstanceid");
                if (WfUtils.isNotEmpty(procInstanceId)) {
                    billInfo.put("processinstanceid", String.valueOf(procInstanceId));
                }
            }
        }
        return billInfo;
    }
}

