/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.url.UrlService;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskCenterNavigationEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskCenterNavigationEntityImpl;
import org.apache.commons.collections.CollectionUtils;

public class GetTCNavigationTreeDataCmd
implements Command<List<TaskCenterNavigationEntity>>,
Serializable {
    private static final long serialVersionUID = 1L;
    private long uid;
    private static final String COUNT = "count";
    private static final String GETGENERALCHILDREN_CONST = "getGeneralChildren";

    public GetTCNavigationTreeDataCmd(long uid) {
        this.uid = uid;
    }

    @Override
    public List<TaskCenterNavigationEntity> execute(CommandContext commandContext) {
        ArrayList<TaskCenterNavigationEntity> navigationNodes = new ArrayList<TaskCenterNavigationEntity>();
        navigationNodes.addAll(this.getGeneralNavigationNodes());
        navigationNodes.addAll(this.getTransferNavigationNodes());
        navigationNodes.addAll(this.getCustomNavigationNodes(this.uid, commandContext));
        return navigationNodes;
    }

    private List<TaskCenterNavigationEntity> getCustomNavigationNodes(long userId, CommandContext commandContext) {
        List<TaskCenterNavigationEntity> customNavigationNodes = commandContext.getTaskCenterNavigationEntityManager().getNavigationByUserid(userId);
        if (WfUtils.isNotEmptyForCollection(customNavigationNodes)) {
            StringBuilder nodes = new StringBuilder();
            for (TaskCenterNavigationEntity node : customNavigationNodes) {
                nodes.append(node.getId()).append(",");
            }
            String nodesStr = nodes.substring(0, nodes.length() - 1);
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT count(1) count, c.FRULEID ruleid FROM t_wf_task a ");
            sql.append("INNER JOIN t_wf_rtrelation c ON a.fid = c.FTASKID ");
            sql.append("WHERE c.FRULEID in (");
            sql.append(nodesStr);
            sql.append(") AND a.FISDISPLAY = '1' AND a.fendtype != 'mobile' ");
            sql.append(" group by c.FRULEID");
            try (DataSet ds = DB.queryDataSet((String)"WfTaskCenterCustom.queryGridData", (DBRoute)DBRoute.workflow, (String)sql.toString());){
                block10: for (Row r : ds) {
                    for (int j = 0; j < customNavigationNodes.size(); ++j) {
                        if (!customNavigationNodes.get(j).getId().equals(r.getLong("ruleid"))) continue;
                        customNavigationNodes.get(j).setCount(r.getInteger(COUNT));
                        continue block10;
                    }
                }
            }
        }
        Collections.reverse(customNavigationNodes);
        customNavigationNodes = this.serializationTaskCenterNavigationEntitys(customNavigationNodes);
        return customNavigationNodes;
    }

    private List<TaskCenterNavigationEntity> serializationTaskCenterNavigationEntitys(List<TaskCenterNavigationEntity> allNodes) {
        if (allNodes == null || allNodes.size() < 1) {
            return allNodes;
        }
        List<TaskCenterNavigationEntity> roots = this.findRoots(allNodes);
        List notRoots = (List)CollectionUtils.subtract(allNodes, roots);
        for (TaskCenterNavigationEntity root : roots) {
            root.setChildren(this.findChildren(root, notRoots));
        }
        return roots;
    }

    public List<TaskCenterNavigationEntity> findRoots(List<TaskCenterNavigationEntity> allNodes) {
        ArrayList<TaskCenterNavigationEntity> roots = new ArrayList<TaskCenterNavigationEntity>();
        for (TaskCenterNavigationEntity node : allNodes) {
            if (0L != node.getParentid()) continue;
            roots.add(node);
        }
        return roots;
    }

    private List<TaskCenterNavigationEntity> findChildren(TaskCenterNavigationEntity root, List<TaskCenterNavigationEntity> notRoots) {
        ArrayList<TaskCenterNavigationEntity> children = new ArrayList<TaskCenterNavigationEntity>();
        for (TaskCenterNavigationEntity node : notRoots) {
            if (!node.getParentid().equals(root.getId())) continue;
            children.add(node);
        }
        List notChildren = (List)CollectionUtils.subtract(notRoots, children);
        for (TaskCenterNavigationEntity child : children) {
            List<TaskCenterNavigationEntity> tmpChildren = this.findChildren(child, notChildren);
            child.setChildren(tmpChildren);
        }
        return children;
    }

    public List<TaskCenterNavigationEntity> getGeneralNavigationNodes() {
        String fileServerUrl = UrlService.getImageFullUrl((String)"");
        String lang = RequestContext.get().getLang().toString();
        ArrayList<TaskCenterNavigationEntity> generalNodes = new ArrayList<TaskCenterNavigationEntity>();
        TaskCenterNavigationEntityImpl toHandleNode = new TaskCenterNavigationEntityImpl();
        String sql = "select count(*) count,b.fentityName entityname,a.FENTITYNUMBER entitynumber from t_wf_task a  INNER JOIN t_wf_task_l b on a.fid=b.fid  INNER JOIN t_wf_participant on a.fid=t_wf_participant.ftaskid where t_wf_participant.fuserid = ? and a.FISDISPLAY = ? AND a.fendtype != 'mobile' GROUP BY a.FENTITYNUMBER,b.fentityName";
        Object[] params = new Object[]{this.uid, "1"};
        toHandleNode.setName((ILocaleString)new LocaleString(ResManager.loadKDString((String)"\u5f85\u529e\u4efb\u52a1", (String)"GetTCNavigationTreeDataCmd_1", (String)"bos-wf-engine", (Object[])new Object[0])));
        toHandleNode.setNumber("wf_task");
        toHandleNode.setImgSrc(fileServerUrl + "private/wf/navigation/toHandle.png");
        toHandleNode.setHoverImgSrc(fileServerUrl + "private/wf/navigation/toHandle_L.png");
        toHandleNode.setChildren(this.getGeneralChildren(sql, params, "getToHandNavigation", "toHandle".hashCode()));
        generalNodes.add(toHandleNode);
        TaskCenterNavigationEntityImpl handledNode = new TaskCenterNavigationEntityImpl();
        sql = "SELECT count(*) count,b.fentityName entityname,a.FENTITYNUMBER entitynumber from t_wf_hitaskinst a INNER JOIN t_wf_hitaskinst_l b on a.FID = b.FID where a.FASSIGNEEID=? AND a.FENDTIME is not null and a.FISDISPLAY = ? AND a.fendtype != 'mobile' GROUP BY a.FENTITYNUMBER,b.fentityName";
        params = new Object[]{this.uid, "1"};
        handledNode.setName((ILocaleString)new LocaleString(ResManager.loadKDString((String)"\u5df2\u529e\u4efb\u52a1", (String)"GetTCNavigationTreeDataCmd_2", (String)"bos-wf-engine", (Object[])new Object[0])));
        handledNode.setNumber("wf_hitaskinst");
        handledNode.setImgSrc(fileServerUrl + "private/wf/navigation/handled11.png");
        handledNode.setHoverImgSrc(fileServerUrl + "private/wf/navigation/handled_L.png");
        handledNode.setChildren(this.getGeneralChildren(sql, params, GETGENERALCHILDREN_CONST, "handled".hashCode()));
        generalNodes.add(handledNode);
        TaskCenterNavigationEntityImpl toApplyNode = new TaskCenterNavigationEntityImpl();
        sql = "SELECT count(*) count,b.fentrabillname entityname,a.FENTITYNUMBER entitynumber from t_wf_execution a LEFT JOIN t_wf_execution_l b ON a.fid = b.fid WHERE a.FPARENTID=0 AND a.FSTARTUSERID =? AND b.FLOCALEID = ? GROUP BY a.FENTITYNUMBER,b.fentrabillname";
        params = new Object[]{this.uid, lang};
        toApplyNode.setName((ILocaleString)new LocaleString(ResManager.loadKDString((String)"\u5728\u529e\u7533\u8bf7", (String)"GetTCNavigationTreeDataCmd_3", (String)"bos-wf-engine", (Object[])new Object[0])));
        toApplyNode.setNumber("wf_execution");
        toApplyNode.setImgSrc(fileServerUrl + "private/wf/navigation/toApply.png");
        toApplyNode.setHoverImgSrc(fileServerUrl + "private/wf/navigation/toApply_L.png");
        toApplyNode.setChildren(this.getGeneralChildren(sql, params, GETGENERALCHILDREN_CONST, "toApply".hashCode()));
        generalNodes.add(toApplyNode);
        TaskCenterNavigationEntityImpl applyedNode = new TaskCenterNavigationEntityImpl();
        sql = "SELECT count(*) count,b.fentrabillname entityname,a.FENTITYNUMBER entitynumber from t_wf_hiprocinst a LEFT JOIN t_wf_hiprocinst_l b ON a.fid = b.fid AND b.FLOCALEID = ? WHERE a.FCREATORID =? AND a.FENDTIME is not NULL AND FENDTYPE <> '20' GROUP BY a.FENTITYNUMBER,b.fentrabillname";
        params = new Object[]{lang, this.uid};
        applyedNode.setName((ILocaleString)new LocaleString(ResManager.loadKDString((String)"\u5df2\u529e\u7533\u8bf7", (String)"GetTCNavigationTreeDataCmd_4", (String)"bos-wf-engine", (Object[])new Object[0])));
        applyedNode.setNumber("wf_hiprocinst");
        applyedNode.setImgSrc(fileServerUrl + "private/wf/navigation/applyed.png");
        applyedNode.setHoverImgSrc(fileServerUrl + "private/wf/navigation/applyed_L.png");
        applyedNode.setChildren(this.getGeneralChildren(sql, params, GETGENERALCHILDREN_CONST, "applyed".hashCode()));
        generalNodes.add(applyedNode);
        return generalNodes;
    }

    private List<TaskCenterNavigationEntity> getTransferNavigationNodes() {
        ArrayList<TaskCenterNavigationEntity> entitys = new ArrayList<TaskCenterNavigationEntity>();
        TaskCenterNavigationEntityImpl entity = new TaskCenterNavigationEntityImpl();
        entity.setName((ILocaleString)new LocaleString(String.format(ResManager.loadKDString((String)"\u6211\u7684%s", (String)"GetTCNavigationTreeDataCmd_5", (String)"bos-wf-engine", (Object[])new Object[0]), WfConfigurationUtil.getTransferName())));
        entity.setNumber("transfer");
        String sql = "select count(*) count from t_wf_task a WHERE a.fid in (SELECT ftaskId FROM t_wf_taskhandlelog l WHERE l.FOWNERID = ? AND l.ftype = 'transfer' ) AND a.fendtype != 'mobile' ";
        Object[] params = new Object[]{this.uid};
        int count = 0;
        try (DataSet ds = DB.queryDataSet((String)"wf_toHandle_transfer_count", (DBRoute)DBRoute.workflow, (String)sql, (Object[])params);){
            Iterator iter = ds.iterator();
            if (iter.hasNext()) {
                Row row = (Row)iter.next();
                count = row.getInteger(COUNT);
            }
        }
        entity.setCount(count);
        entitys.add(entity);
        return entitys;
    }

    public List<TaskCenterNavigationEntity> getGeneralChildren(String sql, Object[] params, String queryKey, long parentid) {
        ArrayList<TaskCenterNavigationEntity> navigationChildren = new ArrayList<TaskCenterNavigationEntity>();
        try (DataSet ds = DB.queryDataSet((String)queryKey, (DBRoute)DBRoute.workflow, (String)sql, (Object[])params);){
            Iterator iter = ds.iterator();
            while (iter.hasNext()) {
                TaskCenterNavigationEntityImpl child = new TaskCenterNavigationEntityImpl();
                Row row = (Row)iter.next();
                child.setParentid(parentid);
                child.setName((ILocaleString)new LocaleString(row.getString("entityname")));
                child.setNumber(row.getString("entitynumber"));
                child.setCount(row.getInteger(COUNT));
                navigationChildren.add(child);
            }
        }
        return navigationChildren;
    }
}

