/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.workflow.engine.TableNameConstant;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;

public class GetTCTaskInfoCmd
implements Command<Map<String, Object>>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Long fId;
    private String type;

    public GetTCTaskInfoCmd(Long fId, String type) {
        this.fId = fId;
        this.type = type;
    }

    @Override
    public Map<String, Object> execute(CommandContext commandContext) {
        Map<String, Object> billInfo = null;
        switch (this.type) {
            case "toHandle": {
                billInfo = this.getToHandleTaskInfo();
                break;
            }
            case "handled": {
                billInfo = this.getHandledTaskInfo();
                break;
            }
            case "applyed": {
                billInfo = this.getApplyedTaskInfo();
                break;
            }
            case "toApply": {
                billInfo = this.getToApplyTaskInfo();
                break;
            }
        }
        return billInfo;
    }

    public Map<String, Object> getToApplyTaskInfo() {
        String sql = "select a.FPROCINSTID PROCINSTID, a.FBUSINESSKEY BUSINESSKEY, a.FENTITYNUMBER ENTITYNUMBER, a.FPROCESSTYPE PROCESSTYPE, a.FPROCDEFID PROCDEFID from t_wf_execution a where a.FID=? ";
        Object[] params = new Object[]{this.fId};
        return this.exeSql(sql, "WfTaskCenter.wf_task.queryTaskInfo", params);
    }

    public Map<String, Object> getHandledTaskInfo() {
        StringBuilder sql = new StringBuilder();
        sql.append("select ").append("a.FPROCINSTID PROCINSTID, ").append("a.FBUSINESSKEY BUSINESSKEY, ").append("a.FENTITYNUMBER ENTITYNUMBER, ").append("a.FPROCESSTYPE PROCESSTYPE, ").append("a.FPROCDEFID PROCDEFID ").append("from ").append(TableNameConstant.getHiTaskInstTableName()).append(" a where a.FID=? ");
        Object[] params = new Object[]{this.fId};
        return this.exeSql(sql.toString(), "WfTaskCenter.wf_hitaskinst.queryTaskInfo", params);
    }

    public Map<String, Object> getApplyedTaskInfo() {
        StringBuilder sql = new StringBuilder();
        sql.append("select ").append("a.FPROCINSTID PROCINSTID, ").append("a.FBUSINESSKEY BUSINESSKEY, ").append("a.FENTITYNUMBER ENTITYNUMBER, ").append("a.FPROCESSTYPE PROCESSTYPE, ").append("a.FPROCDEFID PROCDEFID ").append("from ").append(TableNameConstant.getHiProcInstTableName()).append(" a where a.FID=? ");
        Object[] params = new Object[]{this.fId};
        return this.exeSql(sql.toString(), "WfTaskCenter.wf_hiprocinst.queryTaskInfo", params);
    }

    public Map<String, Object> getToHandleTaskInfo() {
        String sql = "select a.FPROCINSTID PROCINSTID, a.FBUSINESSKEY BUSINESSKEY, a.FENTITYNUMBER ENTITYNUMBER,a.FPROCESSTYPE PROCESSTYPE, a.FPROCDEFID PROCDEFID from t_wf_task a where a.FID=? ";
        Object[] params = new Object[]{this.fId};
        return this.exeSql(sql, "WfTaskCenter.wf_execution.queryTaskInfo", params);
    }

    private Map<String, Object> exeSql(String sql, String queryKey, Object[] params) {
        HashMap<String, Object> taskInfo = new HashMap<String, Object>();
        try (DataSet ds = DB.queryDataSet((String)queryKey, (DBRoute)WfUtils.WFS, (String)sql, (Object[])params);){
            Iterator iter = ds.iterator();
            if (iter.hasNext()) {
                Row row = (Row)iter.next();
                taskInfo.put("processInstanceId", row.getLong("PROCINSTID"));
                taskInfo.put("businesskey", row.getString("BUSINESSKEY"));
                taskInfo.put("entitynumber", row.getString("ENTITYNUMBER"));
                taskInfo.put("processtype", row.getString("PROCESSTYPE"));
                taskInfo.put("procdefId", row.getLong("PROCDEFID"));
            }
        }
        return taskInfo;
    }
}

