/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.util.List;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;

public class GetTasksByFilterCmd
implements Command<List<TaskEntity>> {
    private QFilter[] filters;
    private String orderBy;
    private int count;

    public GetTasksByFilterCmd(QFilter[] filters) {
        this.filters = (QFilter[])filters.clone();
    }

    public GetTasksByFilterCmd(QFilter[] filters, String orderBy, int count) {
        this.filters = filters;
        this.orderBy = orderBy;
        this.count = count;
    }

    @Override
    public List<TaskEntity> execute(CommandContext commandContext) {
        EntityQueryBuilder queryBuilder = commandContext.getTaskEntityManager().createQueryBuilder();
        queryBuilder.addFilters(this.filters);
        if (WfUtils.isNotEmpty(this.orderBy)) {
            queryBuilder.orderBy(this.orderBy);
        }
        if (this.count > 0) {
            queryBuilder.setLimit(this.count);
        }
        return commandContext.getTaskEntityManager().findByQueryBuilder(queryBuilder);
    }
}

