/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;

public class GetToHandleTasksMessageCmd
implements Command<List<Map<String, Object>>>,
Serializable {
    private static final long serialVersionUID = 1698590707312617829L;
    private static Log logger = LogFactory.getLog(GetToHandleTasksMessageCmd.class);
    private Long userId;
    private Integer topCount;
    private Map<String, String> stateMap = new HashMap<String, String>();
    public static final String ENTITYNAME = "entityname";
    public static final String STARTNAME = "startname";
    public static final String HANDLESTATE = "handlestate";
    public static final String CREATEDATE = "createdate";
    public static final String SUBJECT = "subject";
    public static final String ID = "id";
    public static final String CONTENT = "content";
    public static final String TITLE = "title";
    public static final String TIME = "time";

    public GetToHandleTasksMessageCmd(Long userId, Integer topCount) {
        this.userId = userId;
        this.topCount = topCount;
        this.stateMap.put("dismissed", ResManager.loadKDString((String)"\u88ab\u9a73\u56de", (String)"GetToHandleTasksMessageCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]));
        this.stateMap.put("willApproval", ResManager.loadKDString((String)"\u5f85\u5ba1\u6279", (String)"GetToHandleTasksMessageCmd_2", (String)"bos-wf-engine", (Object[])new Object[0]));
        this.stateMap.put("freeze", ResManager.loadKDString((String)"\u5df2\u51bb\u7ed3", (String)"GetToHandleTasksMessageCmd_3", (String)"bos-wf-engine", (Object[])new Object[0]));
        this.stateMap.put("willHandled", ResManager.loadKDString((String)"\u5f85\u5904\u7406", (String)"GetToHandleTasksMessageCmd_4", (String)"bos-wf-engine", (Object[])new Object[0]));
    }

    @Override
    public List<Map<String, Object>> execute(CommandContext commandContext) {
        ArrayList<Map<String, Object>> tasksForMsg = new ArrayList<Map<String, Object>>();
        DynamicObjectCollection taskResultCollection = null;
        try {
            taskResultCollection = commandContext.getTaskEntityManager().getTasksForMsgByUid(this.userId, this.topCount);
            if (taskResultCollection == null) {
                return Collections.emptyList();
            }
            for (DynamicObject taskResult : taskResultCollection) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put(ID, taskResult.getLong(ID));
                map.put(TITLE, String.format(ResManager.loadKDString((String)"%1$s\u63d0\u4ea4\u7684%2$s", (String)"GetToHandleTasksMessageCmd_5", (String)"bos-wf-engine", (Object[])new Object[0]), taskResult.getString(STARTNAME), taskResult.getString(ENTITYNAME)));
                map.put(CONTENT, taskResult.getString(SUBJECT));
                String handleState = taskResult.getString(HANDLESTATE);
                if (WfUtils.isNotEmpty(handleState)) {
                    map.put(HANDLESTATE, this.stateMap.get(handleState));
                }
                map.put(TIME, taskResult.getDate(CREATEDATE));
                tasksForMsg.add(map);
            }
        }
        catch (Exception e) {
            logger.info("catch error info:" + e.getMessage());
        }
        return tasksForMsg;
    }
}

