/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntityManager;
import kd.bos.workflow.engine.msg.MessageServiceUtil;

public class GetUrlByTypeCmd
implements Command<String> {
    private static Log logger = LogFactory.getLog(GetUrlByTypeCmd.class);
    private Long taskId;
    private Long processInstanceId;
    private String type;
    private static final String TYPE_CIRCULATE = "circulate";

    public GetUrlByTypeCmd(Long taskId, Long processInstanceId, String type) {
        this.taskId = taskId;
        this.processInstanceId = processInstanceId;
        this.type = type;
    }

    @Override
    public String execute(CommandContext commandContext) {
        logger.info("GetUrlByTypeCmd.execute taskId:" + this.taskId + ";processInstanceId:" + this.processInstanceId + ";type:" + this.type);
        HistoricTaskInstanceEntity taskInfo = null;
        if (WfUtils.isNotEmpty(this.taskId)) {
            HistoricTaskInstanceEntityManager taskManager = commandContext.getHistoricTaskInstanceEntityManager();
            taskInfo = (HistoricTaskInstanceEntity)taskManager.findById(this.taskId);
        }
        if (TYPE_CIRCULATE.equals(this.type)) {
            if (null == taskInfo) {
                return "";
            }
            return MessageServiceUtil.buildWebPageForTaskInfoAndCirculation(taskInfo);
        }
        return "";
    }
}

