/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.util.Map;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.relservice.BusinessLogicServiceHelper;

public class InvokeBusinessOperationCmd
implements Command<OperationResult> {
    private Log logger = LogFactory.getLog(this.getClass());
    private Long taskId;
    private String operation;
    private Map<String, String> variable;

    public InvokeBusinessOperationCmd(Long taskId, String operation, Map<String, String> variable) {
        this.taskId = taskId;
        this.operation = operation;
        this.variable = variable;
    }

    @Override
    public OperationResult execute(CommandContext commandContext) {
        TaskEntity task = (TaskEntity)commandContext.getTaskEntityManager().findById(this.taskId);
        if (task != null) {
            return BusinessLogicServiceHelper.invokeOperationService(this.operation, task.getEntityNumber(), new Object[]{task.getBusinessKey()}, this.variable, task, task.getExecution());
        }
        this.logger.debug(String.format("task[%s] is not exist!", this.taskId));
        return null;
    }
}

