/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.domain.model.NodeForkJoinModel;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.agenda.ForkJoinUtils;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.DefaultCommandContextCloseListener;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;

public class JudgeForkTaskCanRejectCmd
implements Command<Boolean> {
    private Long processInstanceId;
    private String taskdefinitionkey;
    private String targetNodeId;

    public JudgeForkTaskCanRejectCmd(Long processInstanceId, String taskdefinitionkey) {
        this.processInstanceId = processInstanceId;
        this.taskdefinitionkey = taskdefinitionkey;
    }

    public JudgeForkTaskCanRejectCmd(Long processInstanceId, String taskdefinitionkey, String targetNodeId) {
        this.processInstanceId = processInstanceId;
        this.taskdefinitionkey = taskdefinitionkey;
        this.targetNodeId = targetNodeId;
    }

    @Override
    public Boolean execute(CommandContext commandContext) {
        boolean result = false;
        if (WfUtils.isEmpty(this.processInstanceId) || WfUtils.isEmpty(this.taskdefinitionkey)) {
            return Boolean.FALSE;
        }
        ExecutionEntity e = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(this.processInstanceId);
        if (e != null) {
            Process process = ProcessDefinitionUtil.getProcess(e.getProcessDefinitionId(), e.getProcessInstanceId());
            Map<String, NodeForkJoinModel> models = process.getForkJoinModels();
            FlowNode node = (FlowNode)process.getFlowElement(this.taskdefinitionkey);
            if (node instanceof AuditTask && ((AuditTask)node).isDynamicReject()) {
                NodeForkJoinModel targetModel;
                NodeForkJoinModel model = models.get(this.taskdefinitionkey);
                if (model == null || WfUtils.isEmpty(model.getLatestForkNode())) {
                    return Boolean.FALSE;
                }
                if (this.targetNodeId != null && (targetModel = models.get(this.targetNodeId)) != null && model.getForkStructure().contains(targetModel.getForkStructure() + "$")) {
                    final String cacheKey = e.getProcessInstanceId() + model.getLatestForkNode();
                    if (!WfCacheHelper.existCanRejectLock(cacheKey)) {
                        try (DLock lock = DLock.create((String)String.format("wf/canReject/%s", cacheKey), (String)String.format(ResManager.loadKDString((String)"\u662f\u5426\u53ef\u4ee5\u6267\u884c\u9a73\u56de\u5224\u65ad\u903b\u8f91[%s]", (String)"JudgeForkTaskCanRejectCmd_0", (String)"bos-wf-engine", (Object[])new Object[0]), cacheKey)).fastMode();){
                            boolean canRejectLock = lock.tryLock(60000L);
                            if (canRejectLock && !WfCacheHelper.existCanRejectLock(cacheKey)) {
                                WfCacheHelper.putCanRejectLock(cacheKey, cacheKey);
                                commandContext.addCloseListener(new DefaultCommandContextCloseListener(""){

                                    @Override
                                    public void closed(CommandContext commandContext) {
                                        WfCacheHelper.removeCanRejectLock(cacheKey);
                                    }
                                });
                                Boolean bl = this.canReject(model, e);
                                return bl;
                            }
                            Boolean bl = Boolean.TRUE;
                            return bl;
                        }
                    }
                    return Boolean.TRUE;
                }
                result = this.canReject(model, e);
            }
        }
        return result;
    }

    private boolean canReject(NodeForkJoinModel currentModel, ExecutionEntity e) {
        String forkNodeId = currentModel.getLatestForkNode();
        int cycle = ForkJoinUtils.getEnterForkCycle(forkNodeId, e);
        return WfUtils.isNotEmpty(ForkJoinUtils.getJoinNodeRejectKey(forkNodeId, cycle, e));
    }
}

