/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntityManager;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;

public class RepairCommentCmd
implements Command<Void> {
    private Date startDate;
    private Date endDate;

    public RepairCommentCmd(Date startDate, Date endDate) {
        this.startDate = (Date)startDate.clone();
        this.endDate = (Date)endDate.clone();
    }

    @Override
    public Void execute(CommandContext commandContext) {
        QFilter startFilter = new QFilter("time", ">", (Object)this.startDate);
        QFilter endFilter = new QFilter("time", "<", (Object)this.endDate);
        CommentEntityManager mgr = commandContext.getCommentEntityManager();
        HashMap<Long, Long> proInstIdsMapProdefId = null;
        List comments = mgr.findByQueryFilters(new QFilter[]{startFilter, endFilter});
        proInstIdsMapProdefId = WfUtils.isNotEmptyForCollection(comments) ? new HashMap(comments.size()) : new HashMap<Long, Long>(1);
        for (CommentEntity comment : comments) {
            proInstIdsMapProdefId.put(comment.getProcessInstanceId(), 0L);
        }
        QFilter filter = new QFilter("id", "in", proInstIdsMapProdefId.keySet());
        List proInsts = commandContext.getHistoricProcessInstanceEntityManager().findByQueryFilters(new QFilter[]{filter}, "id,processDefinitionId", null);
        for (HistoricProcessInstanceEntity h : proInsts) {
            proInstIdsMapProdefId.put(h.getId(), h.getProcessDefinitionId());
        }
        for (CommentEntity comment : comments) {
            Process process;
            FlowElement ele;
            Long prodefId = (Long)proInstIdsMapProdefId.get(comment.getProcessInstanceId());
            if (!WfUtils.isNotEmpty(prodefId) || !((ele = (process = ProcessDefinitionUtil.getProcess(prodefId, null)).getFlowElement(comment.getActivityId())) instanceof UserTask)) continue;
            String bizIdentifyKey = ((UserTask)ele).getBizIdentifyKey();
            if (!WfUtils.isEmpty(comment.getBizIdentifyKey()) || !WfUtils.isNotEmpty(bizIdentifyKey)) continue;
            comment.setBizIdentifyKey(bizIdentifyKey);
            mgr.update(comment);
        }
        return null;
    }
}

