/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfDBUtils;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntity;
import kd.bos.workflow.feature.taskfield.TaskExtendFieldHelper;
import kd.bos.workflow.feature.taskfield.util.TaskExtendFieldUtil;

public class RepairTaskBusinessFieldCmd
implements Command<Void> {
    private static final int UPDATE_SIZE = 300;
    private static final int UPDATE_TIMES = 5;
    private static final String UPDATE_LASTDATE = "2022-5-10 00:00:00";
    private static final String KEY_SIZE = "workflow.task.needUpdateExtField.size";
    private static final String KEY_TIMES = "workflow.task.needUpdateExtField.times";
    private static final String KEY_HISTASKUPDATELASTDATE = "workflow.task.needUpdateExtField.hitask.lastdate";
    private static final String STR_WFTASK = "wf_task";
    private static final String STR_WFPARTICIPANT = "wf_participant";
    private static final String STR_WFHITASK = "wf_hitaskinst";
    private static final String STR_APOINT = "A.";
    private static final String STR_DATEFORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String[] MULFIELDARR = new String[]{"biz_strmul1", "biz_strmul2"};
    private String entityNumbers;
    private Log logger = LogFactory.getLog(RepairTaskBusinessFieldCmd.class);

    public RepairTaskBusinessFieldCmd(String entityNumbers) {
        this.entityNumbers = entityNumbers;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (StringUtils.isBlank((CharSequence)this.entityNumbers)) {
            return null;
        }
        Map needUpdateMap = (Map)SerializationUtils.fromJsonString((String)this.entityNumbers, Map.class);
        Object confSize = WfConfigurationUtil.getConfigCenterVal(KEY_SIZE);
        Object confTimes = WfConfigurationUtil.getConfigCenterVal(KEY_TIMES);
        Object confHiTaskUpdateLastDate = WfConfigurationUtil.getConfigCenterVal(KEY_HISTASKUPDATELASTDATE);
        int size = StringUtils.isNotBlank((Object)confSize) ? Integer.parseInt((String)confSize) : 300;
        int times = StringUtils.isNotBlank((Object)confTimes) ? Integer.parseInt((String)confTimes) : 5;
        this.logger.debug(String.format("RepairTaskBusinessFieldCmd_startrepairdata\uff1asize%s, times%s", size, times));
        List<String> needUpdateEntitys = this.getUpdateEntitys(needUpdateMap, times);
        HashMap<String, LinkedHashMap<String, String>> taskFieldMap = new HashMap<String, LinkedHashMap<String, String>>(2);
        SimpleDateFormat format = new SimpleDateFormat(STR_DATEFORMAT);
        for (String entry : needUpdateEntitys) {
            Date date;
            String DateStr;
            String[] arr = entry.split("#");
            String entityNumber = arr[0];
            String scope = arr[1];
            Object entityObj = needUpdateMap.get(entityNumber);
            boolean isNewFormat = true;
            Map tempEntityMap = null;
            if (entityObj instanceof Map) {
                tempEntityMap = (Map)entityObj;
                Map scopeObj = (Map)((Map)entityObj).get(scope);
                DateStr = (String)scopeObj.values().stream().sorted(Comparator.reverseOrder()).findFirst().get();
            } else {
                isNewFormat = false;
                DateStr = (String)entityObj;
            }
            try {
                date = format.parse(DateStr);
            }
            catch (Exception e) {
                date = new Date();
                this.logger.warn("\u65e5\u671f\u8f6c\u6362\u62a5\u9519\uff1a" + e.getMessage());
            }
            List<Entity> tasks = this.getTaskEntitys(scope, entityNumber, date, size);
            ArrayList<Object[]> mailTableParams = new ArrayList<Object[]>();
            HashMap<String, List<Object[]>> mulTableParams = new HashMap<String, List<Object[]>>();
            ArrayList<Object[]> extendTableParams = new ArrayList<Object[]>();
            ArrayList<Object> ids = new ArrayList<Object>();
            LinkedHashMap<String, String> taskField = this.getBusinessField(scope, taskFieldMap);
            this.calcAndCollectParams(tasks, taskField, mailTableParams, extendTableParams, mulTableParams, ids, scope);
            boolean particiapntUpdateFinish = WfConfigurationUtil.isUpdateTaskToParticipantComplete();
            if (WfUtils.isNotEmptyForCollection(tasks)) {
                this.logger.debug("RepairTaskBusinessFieldCmd_\u5f00\u59cb\u5199\u5e93");
                if (STR_WFTASK.equals(scope)) {
                    this.executeUpdateSql("t_wf_task", taskField, ids, mailTableParams, extendTableParams, mulTableParams, size);
                    if (particiapntUpdateFinish) {
                        this.executeIdentityLinkUpdateSql(taskField, ids, mailTableParams, extendTableParams, mulTableParams, size);
                    } else if (tempEntityMap != null) {
                        if (tempEntityMap.get(STR_WFPARTICIPANT) == null) {
                            HashMap firstDate = new HashMap((Map)tempEntityMap.get(scope));
                            tempEntityMap.put(STR_WFPARTICIPANT, firstDate);
                        } else {
                            Map task = (Map)tempEntityMap.get(scope);
                            Map participangt = (Map)tempEntityMap.get(STR_WFPARTICIPANT);
                            task.entrySet().forEach(field -> {
                                if (WfUtils.isNotEmpty((String)participangt.get(field.getKey()))) {
                                    String formatDate = (String)participangt.get(field.getKey());
                                    if (((String)field.getValue()).compareTo(formatDate) > 0) {
                                        participangt.put(field.getKey(), field.getValue());
                                    }
                                } else {
                                    participangt.put(field.getKey(), field.getValue());
                                }
                            });
                        }
                    }
                } else if (STR_WFPARTICIPANT.equals(scope)) {
                    if (particiapntUpdateFinish) {
                        this.executeIdentityLinkUpdateSql(taskField, ids, mailTableParams, extendTableParams, mulTableParams, size);
                    }
                } else {
                    this.executeUpdateSql("t_wf_hitaskinst", taskField, ids, mailTableParams, extendTableParams, mulTableParams, size);
                    this.executeUpdateHicomementSql(taskField, ids, mailTableParams, extendTableParams, mulTableParams, size);
                }
                this.logger.debug("RepairTaskBusinessFieldCmd_\u5199\u5e93\u5b8c\u6210");
            }
            if (tasks.size() == size) {
                Date lastDate = tasks.get(size - 1).getCreateDate();
                if (isNewFormat && tempEntityMap != null) {
                    String formatDate = format.format(lastDate);
                    Date updateLastDate = null;
                    try {
                        updateLastDate = format.parse(confHiTaskUpdateLastDate != null ? (String)confHiTaskUpdateLastDate : UPDATE_LASTDATE);
                    }
                    catch (ParseException e) {
                        this.logger.info("format updateLastDate is error, errorinfo is:" + confHiTaskUpdateLastDate);
                    }
                    if (STR_WFHITASK.equals(scope) && updateLastDate != null && lastDate.before(updateLastDate)) {
                        tempEntityMap.remove(scope);
                        if (!tempEntityMap.isEmpty()) continue;
                        needUpdateMap.remove(entityNumber);
                        continue;
                    }
                    if (STR_WFPARTICIPANT.equals(scope) && !particiapntUpdateFinish) continue;
                    Map scopeMap = (Map)tempEntityMap.get(scope);
                    scopeMap.entrySet().forEach(field -> {
                        if (((String)field.getValue()).compareTo(formatDate) > 0) {
                            scopeMap.put(field.getKey(), formatDate);
                        }
                    });
                    tempEntityMap.put(scope, scopeMap);
                    needUpdateMap.put(entityNumber, tempEntityMap);
                    continue;
                }
                needUpdateMap.put(entityNumber, lastDate);
                continue;
            }
            if (isNewFormat && tempEntityMap != null) {
                if (STR_WFPARTICIPANT.equals(scope) && !particiapntUpdateFinish) continue;
                tempEntityMap.remove(scope);
                if (!tempEntityMap.isEmpty()) continue;
                needUpdateMap.remove(entityNumber);
                continue;
            }
            needUpdateMap.remove(entityNumber);
        }
        String confValue = SerializationUtils.toJsonString((Object)needUpdateMap);
        this.updateNeedUpdateExtFieldEntitynumbers(confValue);
        return null;
    }

    private void executeUpdateHicomementSql(LinkedHashMap<String, String> taskField, List<Object> taskIds, List<Object[]> mainTableParams, List<Object[]> extendTableParams, Map<String, List<Object[]>> mulTableParams, int size) {
        HashMap map = new HashMap();
        ArrayList<Long> taskIdList = new ArrayList<Long>(taskIds.size());
        taskIds.forEach(x -> taskIdList.add((Long)x));
        List<CommentEntity> comments = Context.getCommandContext().getCommentEntityManager().findByTaskIds(taskIdList);
        comments.forEach(comment -> {
            List idList = Optional.ofNullable(map.get(comment.getTaskId())).orElseGet(ArrayList::new);
            idList.add(comment.getId());
            map.put(comment.getTaskId(), idList);
        });
        ArrayList<Object[]> newParams = new ArrayList<Object[]>(mainTableParams.size());
        ArrayList<Object[]> newExtendTableParams = new ArrayList<Object[]>(extendTableParams.size());
        ArrayList<Object> ids = new ArrayList<Object>(taskIds.size());
        int len = taskIds.size();
        for (int i = 0; i < len; ++i) {
            if (!WfUtils.isNotEmptyForCollection((Collection)map.get(taskIds.get(i)))) continue;
            List tempList = (List)map.get(taskIds.get(i));
            for (Long id : tempList) {
                ids.add(id);
                Object[] mainTableParam = ArrayUtils.clone((Object[])mainTableParams.get(i));
                mainTableParam[mainTableParam.length - 1] = id;
                newParams.add(mainTableParam);
                Object[] extendTableParam = ArrayUtils.clone((Object[])extendTableParams.get(i));
                extendTableParam[0] = id;
                newExtendTableParams.add(extendTableParam);
            }
        }
        HashMap<String, List<Object[]>> newMulTableParams = new HashMap<String, List<Object[]>>(mulTableParams.size());
        mulTableParams.forEach((lang, paramList) -> {
            ArrayList tmpList = new ArrayList(paramList.size());
            for (int i = 0; i < paramList.size(); ++i) {
                Object[] params = (Object[])paramList.get(i);
                Object tmpTaskId = params[params.length - 2];
                List hicommentIds = (List)map.get(tmpTaskId);
                if (!WfUtils.isNotEmptyForCollection(hicommentIds)) continue;
                hicommentIds.forEach(id -> {
                    ArrayList<Long> tmp = new ArrayList<Long>();
                    Collections.addAll(tmp, params);
                    tmp.set(tmp.size() - 2, (Long)id);
                    tmpList.add(tmp.toArray());
                });
            }
            newMulTableParams.put((String)lang, tmpList);
        });
        this.executeUpdateSql("t_wf_hicomment", taskField, ids, newParams, newExtendTableParams, newMulTableParams, size);
    }

    private void executeIdentityLinkUpdateSql(LinkedHashMap<String, String> taskField, List<Object> taskIds, List<Object[]> mainTableParams, List<Object[]> extendTableParams, Map<String, List<Object[]>> mulTableParams, int size) {
        HashMap map = new HashMap();
        Long[] tasks = new Long[taskIds.size()];
        for (int i = 0; i < taskIds.size(); ++i) {
            tasks[i] = (Long)taskIds.get(i);
        }
        List<IdentityLinkEntity> identityLinkEntities = Context.getCommandContext().getIdentityLinkEntityManager().findIdentityLinksByTaskIds(tasks);
        identityLinkEntities.forEach(identityLinkEntity -> {
            List idList = Optional.ofNullable(map.get(identityLinkEntity.getTaskId())).orElseGet(ArrayList::new);
            idList.add(identityLinkEntity.getId());
            map.put(identityLinkEntity.getTaskId(), idList);
        });
        ArrayList<Object[]> newParams = new ArrayList<Object[]>(mainTableParams.size());
        ArrayList<Object[]> newExtendTableParams = new ArrayList<Object[]>(extendTableParams.size());
        ArrayList<Object> ids = new ArrayList<Object>(taskIds.size());
        int len = taskIds.size();
        for (int i = 0; i < len; ++i) {
            if (!WfUtils.isNotEmptyForCollection((Collection)map.get(taskIds.get(i)))) continue;
            List tempList = (List)map.get(taskIds.get(i));
            for (Long id : tempList) {
                ids.add(id);
                Object[] mainTableParam = ArrayUtils.clone((Object[])mainTableParams.get(i));
                mainTableParam[mainTableParam.length - 1] = id;
                newParams.add(mainTableParam);
                Object[] extendTableParam = ArrayUtils.clone((Object[])extendTableParams.get(i));
                extendTableParam[0] = id;
                newExtendTableParams.add(extendTableParam);
            }
        }
        HashMap<String, List<Object[]>> newMulTableParams = new HashMap<String, List<Object[]>>(mulTableParams.size());
        mulTableParams.forEach((lang, paramList) -> {
            ArrayList tmpList = new ArrayList(paramList.size());
            for (int i = 0; i < paramList.size(); ++i) {
                Object[] params = (Object[])paramList.get(i);
                Object tmpTaskId = params[params.length - 2];
                List hiIdentityIds = (List)map.get(tmpTaskId);
                if (!WfUtils.isNotEmptyForCollection(hiIdentityIds)) continue;
                hiIdentityIds.forEach(id -> {
                    ArrayList<Long> tmp = new ArrayList<Long>();
                    Collections.addAll(tmp, params);
                    tmp.set(tmp.size() - 2, (Long)id);
                    tmpList.add(tmp.toArray());
                });
            }
            newMulTableParams.put((String)lang, tmpList);
        });
        this.executeUpdateSql("t_wf_participant", taskField, ids, newParams, newExtendTableParams, newMulTableParams, size);
    }

    private void calcAndCollectParams(List<Entity> tasks, LinkedHashMap<String, String> taskField, List<Object[]> mainTableParams, List<Object[]> extendTableParams, Map<String, List<Object[]>> mulTableParams, List<Object> ids, String scope) {
        tasks.forEach(entity -> {
            ArrayList<Object> param = new ArrayList<Object>(taskField.size());
            ArrayList<Long> extendTableParam = new ArrayList<Long>(taskField.size());
            HashMap tempLangParamArr = new HashMap(taskField.size());
            TaskExtendFieldHelper.setTaskBizField(entity, scope);
            DynamicObject dynamicObject = entity.getDynamicObject();
            taskField.forEach((key, field) -> {
                if (StringUtils.startsWith((CharSequence)field, (CharSequence)STR_APOINT)) {
                    extendTableParam.add((Long)dynamicObject.get(key));
                } else if (ArrayUtils.contains((Object[])MULFIELDARR, (Object)key)) {
                    this.addLocaleStringField(param, tempLangParamArr, dynamicObject.getLocaleString(key));
                } else {
                    param.add(dynamicObject.get(key));
                }
            });
            ids.add(entity.getId());
            param.add(dynamicObject.getString("bizformat"));
            param.add(entity.getId());
            mainTableParams.add(param.toArray());
            for (Map.Entry entry : tempLangParamArr.entrySet()) {
                List list = (List)entry.getValue();
                list.add(entity.getId());
                list.add(entry.getKey());
                List<Object> langParam = mulTableParams.get(entry.getKey()) == null ? new ArrayList<Object[]>() : (List)mulTableParams.get(entry.getKey());
                langParam.add(list.toArray());
                mulTableParams.put((String)entry.getKey(), (List<Object[]>)langParam);
            }
            extendTableParam.add(0, entity.getId());
            extendTableParams.add(extendTableParam.toArray());
        });
    }

    private void executeUpdateSql(String tableName, LinkedHashMap<String, String> taskField, List<Object> ids, List<Object[]> mainTableParams, List<Object[]> extendTableParams, Map<String, List<Object[]>> mulTableParams, int size) {
        try {
            StringBuilder taskMainsql = new StringBuilder();
            taskMainsql.append("update ").append(tableName).append(" set ");
            taskField.entrySet().stream().filter(entry -> !StringUtils.startsWith((CharSequence)((CharSequence)entry.getValue()), (CharSequence)STR_APOINT)).forEach(entry -> taskMainsql.append((String)entry.getValue()).append("=?, "));
            taskMainsql.append("fextendformat = ? where fid = ?");
            WfDBUtils.executeBatch(taskMainsql.toString(), mainTableParams, size);
            StringBuilder mulTableSql = new StringBuilder();
            mulTableSql.append("update ").append(tableName).append("_l set ");
            taskField.entrySet().stream().filter(entry -> ArrayUtils.contains((Object[])MULFIELDARR, entry.getKey())).forEach(entry -> mulTableSql.append((String)entry.getValue()).append("=?,"));
            mulTableSql.replace(mulTableSql.length() - 1, mulTableSql.length(), "");
            mulTableSql.append(" where fid = ? and flocaleid = ?");
            for (Map.Entry<String, List<Object[]>> entrySet : mulTableParams.entrySet()) {
                WfDBUtils.executeBatch(mulTableSql.toString(), entrySet.getValue(), size);
            }
            String taskClearSplitTableSql = "delete from " + tableName + "_A where fid in (?)";
            WfDBUtils.executeBatchDeleteByIn(taskClearSplitTableSql, ids, null, false);
            StringBuilder taskSplitTablesql = new StringBuilder();
            taskSplitTablesql.append("insert into ").append(tableName).append("_A").append(" (fid");
            List<Map.Entry> splitFieldList = taskField.entrySet().stream().filter(entry -> StringUtils.startsWith((CharSequence)((CharSequence)entry.getValue()), (CharSequence)STR_APOINT)).collect(Collectors.toList());
            splitFieldList.forEach(entry -> taskSplitTablesql.append(",").append(((String)entry.getValue()).replace(STR_APOINT, "")));
            taskSplitTablesql.append(") values (?");
            splitFieldList.forEach(entry -> taskSplitTablesql.append(",").append("?"));
            taskSplitTablesql.append(")");
            WfDBUtils.executeBatch(taskSplitTablesql.toString(), extendTableParams, size);
        }
        catch (Exception e) {
            this.logger.info("executeUpdateSql:" + WfUtils.getExceptionStacktrace(e));
        }
    }

    private List<Entity> getTaskEntitys(String scope, String entityNumber, Date date, int size) {
        ArrayList<Entity> entitys = new ArrayList<Entity>();
        if (STR_WFTASK.equals(scope) || STR_WFPARTICIPANT.equals(scope)) {
            entitys.addAll(Context.getCommandContext().getTaskEntityManager().findTasksByEntityNumber(entityNumber, date, "createdate desc", size));
        } else {
            entitys.addAll(Context.getCommandContext().getHistoricTaskInstanceEntityManager().getHiTasksByEntitynumber(entityNumber, date, "createdate desc", size));
        }
        this.logger.debug("RepairTaskBusinessFieldCmd_\u67e5\u8be2\u5230\u7684\u6570\u91cf:" + entitys.size());
        return entitys;
    }

    private List<String> getUpdateEntitys(Map<String, Object> updateMap, int size) {
        ArrayList<String> list = new ArrayList<String>(5);
        ArrayList<String> tempHiTaskList = new ArrayList<String>(size);
        ArrayList<String> participant = new ArrayList<String>(size);
        for (Map.Entry<String, Object> entry : updateMap.entrySet()) {
            String entityNumber = entry.getKey();
            Object entityObj = entry.getValue();
            if (entityObj instanceof Map) {
                Map entityMap = (Map)entityObj;
                if (entityMap.containsKey(STR_WFTASK)) {
                    list.add(this.buildTempValue(entityNumber, STR_WFTASK));
                }
                if (entityMap.containsKey(STR_WFPARTICIPANT) && participant.size() <= size) {
                    participant.add(entityNumber);
                }
                if (entityMap.containsKey(STR_WFHITASK) && tempHiTaskList.size() <= size) {
                    tempHiTaskList.add(entityNumber);
                }
            } else {
                list.add(this.buildTempValue(entityNumber, STR_WFTASK));
            }
            if (list.size() < size) continue;
            return list;
        }
        if (!tempHiTaskList.isEmpty()) {
            int len = tempHiTaskList.size();
            for (int i = 0; i < len; ++i) {
                list.add(this.buildTempValue((String)tempHiTaskList.get(i), STR_WFHITASK));
                if (list.size() < size) continue;
                return list;
            }
        }
        if (!participant.isEmpty()) {
            int len = participant.size();
            for (int i = 0; i < len; ++i) {
                list.add(this.buildTempValue((String)participant.get(i), STR_WFPARTICIPANT));
                if (list.size() < size) continue;
                return list;
            }
        }
        return list;
    }

    private String buildTempValue(String key, String value) {
        return key + "#" + value;
    }

    private LinkedHashMap<String, String> getBusinessField(String scope, Map<String, LinkedHashMap<String, String>> map) {
        if (map.get(scope) != null) {
            return map.get(scope);
        }
        LinkedHashMap<String, String> fieldMap = new LinkedHashMap<String, String>();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)scope);
        Boolean allowExtendTaskFields = WfConfigurationUtil.isAllowExtendTaskFields();
        dataEntityType.getAllFields().entrySet().forEach(entry -> {
            if (TaskExtendFieldUtil.isBusinessMappingField((IDataEntityProperty)entry.getValue()) || allowExtendTaskFields.booleanValue() && TaskExtendFieldUtil.isBusinessMappingExtField((IDataEntityProperty)entry.getValue())) {
                if (StringUtils.isNotBlank((CharSequence)((IDataEntityProperty)entry.getValue()).getTableGroup())) {
                    fieldMap.put((String)entry.getKey(), ((IDataEntityProperty)entry.getValue()).getTableGroup() + "." + ((IDataEntityProperty)entry.getValue()).getAlias());
                } else {
                    fieldMap.put((String)entry.getKey(), ((IDataEntityProperty)entry.getValue()).getAlias());
                }
            }
        });
        map.put(scope, fieldMap);
        return fieldMap;
    }

    private void updateNeedUpdateExtFieldEntitynumbers(String value) {
        QFilter filter = new QFilter("key", "=", (Object)"workflow.task.needUpdateExtFieldEntitynumbers");
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"wf_confcenter", (String)"value", (QFilter[])new QFilter[]{filter});
        if (dynamicObject != null) {
            dynamicObject.set("value", (Object)value);
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
    }

    private void addLocaleStringField(List<Object> tempParamArr, Map<String, List<Object>> tempLangParamArr, ILocaleString ls) {
        Lang[] supportLangs;
        tempParamArr.add(StringUtils.isNotBlank((CharSequence)ls.toString()) ? ls.toString() : " ");
        for (Lang lang : supportLangs = WfMultiLangUtils.getSupportLangs()) {
            String key = lang.name();
            String value = (String)ls.get((Object)key);
            List paramList = Optional.ofNullable(tempLangParamArr.get(key)).orElseGet(ArrayList::new);
            if (StringUtils.isNotBlank((CharSequence)value)) {
                paramList.add(value);
            } else {
                paramList.add(" ");
            }
            tempLangParamArr.put(key, paramList);
        }
    }
}

